<?php
// Start session
session_start();

// Include database connection
require_once '../config/connection.php';

// Check if user is logged in and has IT privileges
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'it') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

// Set header for JSON response
header('Content-Type: application/json');

// Check if buyer_id is provided
if (!isset($_GET['buyer_id']) || empty($_GET['buyer_id'])) {
    echo json_encode(['success' => false, 'message' => 'Buyer ID is required']);
    exit();
}

// Sanitize input
$buyer_id = intval($_GET['buyer_id']);

// Validate buyer_id
if ($buyer_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid Buyer ID']);
    exit();
}

// Query to get collections based on buyer_id
$query = "SELECT id, nama_collection 
          FROM collections 
          WHERE buyer_id = ? 
          ORDER BY nama_collection ASC";

$stmt = $conn->prepare($query);
$stmt->bind_param("i", $buyer_id);
$stmt->execute();
$result = $stmt->get_result();

// Check if collections found
if ($result->num_rows > 0) {
    $collections = [];
    
    while ($row = $result->fetch_assoc()) {
        $collections[] = [
            'id' => $row['id'],
            'nama_collection' => $row['nama_collection']
        ];
    }
    
    echo json_encode([
        'success' => true,
        'collections' => $collections,
        'total' => count($collections)
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'No collections found for this buyer',
        'collections' => []
    ]);
}

// Close statement and connection
$stmt->close();
$conn->close();
?>