<?php
session_start();
require_once '../config/connection.php';

// Check if user is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'it') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

header('Content-Type: application/json');

// Get code parameter
if (!isset($_GET['code']) || empty(trim($_GET['code']))) {
    echo json_encode(['success' => false, 'message' => 'Code parameter required']);
    exit();
}

$code = trim($_GET['code']);

// Validate format
if (!preg_match('/^\d{3}$/', $code)) {
    echo json_encode(['success' => false, 'message' => 'Invalid code format']);
    exit();
}

// Check if code exists in database
$query = "SELECT csi.id, csi.master_color_id, csi.component_id, csi.lokasi_penyimpanan,
                 mc.color_name, cc.component_name
          FROM color_stock_items csi
          JOIN master_color mc ON csi.master_color_id = mc.id
          JOIN color_components cc ON csi.component_id = cc.id
          WHERE csi.code_barang_lemari5 = ?
          LIMIT 1";

$stmt = $conn->prepare($query);
$stmt->bind_param("s", $code);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    
    echo json_encode([
        'success' => true,
        'exists' => true,
        'data' => [
            'master_color' => $row['color_name'],
            'component' => $row['component_name'],
            'lokasi' => $row['lokasi_penyimpanan']
        ]
    ]);
} else {
    echo json_encode([
        'success' => true,
        'exists' => false
    ]);
}

$stmt->close();
$conn->close();
?>