<?php
// TAMBAHKAN INI DI PALING ATAS sebelum include header
ob_start(); // Start output buffering

$page_title = "Ajukan Peminjaman";
include '../template_borrower/header.php';

$borrower_id = $_SESSION['user_id'];

if (!isset($_SESSION['cart'])) {
    $_SESSION['cart'] = array();
}

// Handle AJAX request untuk scan barcode
if (isset($_POST['ajax_scan']) && $_POST['ajax_scan'] == '1') {
    // Clear any previous output
    ob_clean();
    
    // Set header JSON
    header('Content-Type: application/json');
    
    $code_color = trim($_POST['code_color']);
    
    // Cek apakah sudah ada di cart
    $already_in_cart = false;
    foreach ($_SESSION['cart'] as $cart_item) {
        if ($cart_item['code_color'] == $code_color) {
            $already_in_cart = true;
            break;
        }
    }
    
    if ($already_in_cart) {
        echo json_encode([
            'success' => false,
            'message' => 'Maaf, data ini sudah di-scan!',
            'code' => $code_color
        ]);
        exit;
    }
    
    // Cek ke database - pastikan item available dan tidak sedang dipinjam
    $query_check = "SELECT csi.*, mc.color_name 
                    FROM color_stock_items csi
                    JOIN master_color mc ON csi.master_color_id = mc.id
                    WHERE csi.code_color = ? AND csi.status = 'available'";
    $stmt_check = $conn->prepare($query_check);
    
    if (!$stmt_check) {
        echo json_encode([
            'success' => false,
            'message' => 'Database error: ' . $conn->error
        ]);
        exit;
    }
    
    $stmt_check->bind_param("s", $code_color);
    $stmt_check->execute();
    $result_check = $stmt_check->get_result();
    
    if ($result_check->num_rows > 0) {
        $item = $result_check->fetch_assoc();
        
        // Double check - pastikan tidak ada yang sedang meminjam item ini
        $query_borrowed = "SELECT ti.id FROM transaction_items ti 
                          JOIN stock_transactions st ON ti.transaction_id = st.id 
                          WHERE ti.code_color = ? AND ti.borrow_status = 'borrowed' AND st.status = 'approved'";
        $stmt_borrowed = $conn->prepare($query_borrowed);
        $stmt_borrowed->bind_param("s", $code_color);
        $stmt_borrowed->execute();
        $result_borrowed = $stmt_borrowed->get_result();
        
        if ($result_borrowed->num_rows > 0) {
            echo json_encode([
                'success' => false,
                'message' => 'Code Color ' . $code_color . ' sedang dipinjam oleh orang lain!',
                'code' => $code_color
            ]);
            $stmt_borrowed->close();
            $stmt_check->close();
            exit;
        }
        $stmt_borrowed->close();
        
        $_SESSION['cart'][] = array(
            'code_color' => $item['code_color'],
            'stock_item_id' => $item['id'],
            'color_name' => $item['color_name'],
            'lokasi_penyimpanan' => $item['lokasi_penyimpanan'],
            'lemari_number' => $item['lemari_number']
        );
        
        echo json_encode([
            'success' => true,
            'message' => 'Item ' . $code_color . ' berhasil ditambahkan!',
            'item' => [
                'code_color' => $item['code_color'],
                'color_name' => $item['color_name']
            ],
            'cart_count' => count($_SESSION['cart'])
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Code Color ' . $code_color . ' tidak ditemukan atau sudah dipinjam!',
            'code' => $code_color
        ]);
    }
    
    $stmt_check->close();
    exit;
}

// Clear output buffer untuk normal page load
ob_end_flush();

// Remove item dari cart
if (isset($_GET['remove'])) {
    $remove_index = $_GET['remove'];
    if (isset($_SESSION['cart'][$remove_index])) {
        unset($_SESSION['cart'][$remove_index]);
        $_SESSION['cart'] = array_values($_SESSION['cart']);
        $success_message = "Item berhasil dihapus dari keranjang!";
    }
}

// Submit peminjaman
if (isset($_POST['submit_peminjaman'])) {
    if (count($_SESSION['cart']) > 0) {
        $conn->begin_transaction();
        
        try {
            $week_number = date('W');
            
            $query_last_resv = "SELECT transaction_number FROM stock_transactions 
                               WHERE transaction_number LIKE ? 
                               ORDER BY id DESC LIMIT 1";
            $like_pattern = "resv/%/" . $week_number;
            $stmt_last = $conn->prepare($query_last_resv);
            $stmt_last->bind_param("s", $like_pattern);
            $stmt_last->execute();
            $result_last = $stmt_last->get_result();
            
            if ($result_last->num_rows > 0) {
                $last_resv = $result_last->fetch_assoc()['transaction_number'];
                $parts = explode('/', $last_resv);
                $last_number = intval($parts[1]);
                $new_number = $last_number + 1;
            } else {
                $new_number = 1;
            }
            $stmt_last->close();
            
            $transaction_number = sprintf("resv/%06d/%s", $new_number, $week_number);
            
            $transaction_date = date('Y-m-d H:i:s');
            $expected_return_date = date('Y-m-d H:i:s', strtotime('+90 days'));
            
            // Status transaksi langsung "approved" karena otomatis approved
            $query_transaction = "INSERT INTO stock_transactions 
                                 (transaction_number, borrower_id, transaction_date, expected_return_date, status) 
                                 VALUES (?, ?, ?, ?, 'approved')";
            $stmt_trans = $conn->prepare($query_transaction);
            $stmt_trans->bind_param("siss", $transaction_number, $borrower_id, $transaction_date, $expected_return_date);
            $stmt_trans->execute();
            $transaction_id = $conn->insert_id;
            $stmt_trans->close();
            
            $borrow_date = date('Y-m-d H:i:s');
            $expected_return = date('Y-m-d H:i:s', strtotime('+90 days'));
            $expired_date_after_borrow = date('Y-m-d', strtotime('+90 days'));
            
            foreach ($_SESSION['cart'] as $item) {
                // Ambil expired_date sebelum peminjaman
                $query_expired = "SELECT expired_date FROM color_stock_items WHERE id = ?";
                $stmt_expired = $conn->prepare($query_expired);
                $stmt_expired->bind_param("i", $item['stock_item_id']);
                $stmt_expired->execute();
                $result_expired = $stmt_expired->get_result();
                $expired_data = $result_expired->fetch_assoc();
                $expired_date_before = $expired_data['expired_date'];
                $stmt_expired->close();
                
                // Insert transaction items dengan status "borrowed"
                $query_item = "INSERT INTO transaction_items 
                              (transaction_id, stock_item_id, code_color, borrower_id, borrow_date, expected_return_date, expired_date_before_borrow, expired_date_after_borrow, borrow_status) 
                              VALUES (?, ?, ?, ?, ?, ?, ?, ?, 'borrowed')";
                $stmt_item = $conn->prepare($query_item);
                $stmt_item->bind_param("iisiisss",
                    $transaction_id,
                    $item['stock_item_id'],
                    $item['code_color'],
                    $borrower_id,
                    $borrow_date,
                    $expected_return,
                    $expired_date_before,
                    $expired_date_after_borrow
                );
                $stmt_item->execute();
                $stmt_item->close();
                
                // Update status stock item menjadi "borrowed"
                $query_update = "UPDATE color_stock_items SET status = 'borrowed' WHERE id = ?";
                $stmt_update = $conn->prepare($query_update);
                $stmt_update->bind_param("i", $item['stock_item_id']);
                $stmt_update->execute();
                $stmt_update->close();
            }
            
            $conn->commit();
            $_SESSION['cart'] = array();
            $peminjaman_success = true;
            
        } catch (Exception $e) {
            $conn->rollback();
            $error_message = "Terjadi kesalahan: " . $e->getMessage();
        }
    } else {
        $error_message = "Keranjang kosong!";
    }
}
?>

<!-- Load Html5-QRCode Library -->
<script src="https://unpkg.com/html5-qrcode@2.3.8/html5-qrcode.min.js"></script>

<?php if (isset($peminjaman_success) && $peminjaman_success): ?>
<div id="successPopup" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50" style="animation: fadeIn 0.3s;">
    <div class="bg-white rounded-lg p-8 max-w-md text-center" style="animation: slideIn 0.3s;">
        <img src="../images/notif.png" alt="Success" class="w-32 h-32 mx-auto mb-4">
        <h3 class="text-2xl font-bold text-green-600 mb-2">Berhasil!</h3>
        <p class="text-gray-700 mb-1">Peminjaman Anda telah berhasil diproses</p>
        <p class="text-sm text-gray-500">No. Transaksi: <strong><?php echo $transaction_number; ?></strong></p>
        <p class="text-xs text-gray-400 mt-2">Status: <span class="text-green-600 font-semibold">Approved & Borrowed</span></p>
    </div>
</div>
<style>
@keyframes fadeIn { from { opacity: 0; } to { opacity: 1; } }
@keyframes slideIn { from { transform: translateY(-50px); opacity: 0; } to { transform: translateY(0); opacity: 1; } }
@keyframes fadeOut { from { opacity: 1; } to { opacity: 0; } }
</style>
<script>
setTimeout(function() {
    document.getElementById('successPopup').style.animation = 'fadeOut 0.3s';
    setTimeout(function() { window.location.href = 'ajukan_peminjaman.php'; }, 300);
}, 3000);
</script>
<?php endif; ?>

<div class="w-full max-w-7xl mx-auto px-2 sm:px-4">
    <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 mb-4 sm:mb-6">
        <div class="flex items-center mb-2">
            <i class="fas fa-barcode text-purple-500 text-2xl mr-3"></i>
            <h2 class="text-xl sm:text-2xl font-bold text-gray-800">Scan Barcode Peminjaman</h2>
        </div>
        <p class="text-sm text-gray-600">Scan barcode color panel yang ingin dipinjam menggunakan kamera</p>
    </div>

    <?php if (isset($success_message)): ?>
    <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4 rounded">
        <div class="flex items-center">
            <i class="fas fa-check-circle mr-2"></i>
            <p><?php echo $success_message; ?></p>
        </div>
    </div>
    <?php endif; ?>

    <?php if (isset($error_message)): ?>
    <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-4 rounded">
        <div class="flex items-center">
            <i class="fas fa-exclamation-circle mr-2"></i>
            <p><?php echo $error_message; ?></p>
        </div>
    </div>
    <?php endif; ?>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4 sm:gap-6">
        <div class="lg:col-span-1">
            <div class="bg-white rounded-lg shadow-md p-4 sm:p-6">
                <h3 class="text-lg font-bold text-gray-800 mb-4 flex items-center">
                    <i class="fas fa-qrcode text-purple-500 mr-2"></i>
                    Scanner Kamera
                </h3>
                
                <div class="space-y-4">
                    <!-- Camera Preview -->
                    <div id="reader" class="rounded-lg overflow-hidden border-2 border-gray-300" style="display:none;"></div>

                    <!-- Scan Status -->
                    <div id="scanStatus" class="bg-gray-50 border-2 border-dashed border-gray-300 rounded-lg p-4 text-center">
                        <i class="fas fa-camera text-gray-400 text-3xl mb-2"></i>
                        <p class="text-gray-600 text-sm font-medium">Klik tombol untuk mulai scan</p>
                    </div>

                    <!-- Tombol Scan -->
                    <button type="button" 
                            id="btnStartScan"
                            class="w-full bg-purple-500 hover:bg-purple-600 text-white font-semibold py-3 px-4 rounded-lg transition duration-200 flex items-center justify-center shadow-md">
                        <i class="fas fa-camera mr-2"></i>
                        Mulai Scan Barcode
                    </button>
                    
                    <!-- Scan Again Button (hidden by default) -->
                    <button type="button" 
                            id="btnScanAgain"
                            class="w-full bg-green-500 hover:bg-green-600 text-white font-semibold py-3 px-4 rounded-lg transition duration-200 flex items-center justify-center shadow-md hidden">
                        <i class="fas fa-plus mr-2"></i>
                        Scan Item Berikutnya
                    </button>
                </div>

                <div class="mt-6 bg-blue-50 border border-blue-200 rounded-lg p-3">
                    <h4 class="text-sm font-semibold text-blue-800 mb-2 flex items-center">
                        <i class="fas fa-info-circle mr-2"></i>
                        Cara Menggunakan
                    </h4>
                    <ul class="text-xs text-blue-700 space-y-1">
                        <li class="flex items-start">
                            <i class="fas fa-check text-blue-500 mr-2 mt-0.5"></i>
                            <span>Klik tombol "Mulai Scan Barcode"</span>
                        </li>
                        <li class="flex items-start">
                            <i class="fas fa-check text-blue-500 mr-2 mt-0.5"></i>
                            <span>Izinkan akses kamera browser</span>
                        </li>
                        <li class="flex items-start">
                            <i class="fas fa-check text-blue-500 mr-2 mt-0.5"></i>
                            <span>Arahkan kamera ke barcode</span>
                        </li>
                        <li class="flex items-start">
                            <i class="fas fa-check text-blue-500 mr-2 mt-0.5"></i>
                            <span>Scanner berhenti otomatis setelah berhasil</span>
                        </li>
                        <li class="flex items-start">
                            <i class="fas fa-check text-blue-500 mr-2 mt-0.5"></i>
                            <span>Klik "Scan Item Berikutnya" untuk lanjut</span>
                        </li>
                        <li class="flex items-start">
                            <i class="fas fa-check text-blue-500 mr-2 mt-0.5"></i>
                            <span>Durasi peminjaman: 90 hari</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="lg:col-span-2">
            <div class="bg-white rounded-lg shadow-md p-4 sm:p-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-bold text-gray-800 flex items-center">
                        <i class="fas fa-shopping-cart text-purple-500 mr-2"></i>
                        Keranjang Peminjaman
                        <span id="cartCount" class="ml-2 bg-purple-500 text-white text-xs px-2 py-1 rounded-full">
                            <?php echo count($_SESSION['cart']); ?>
                        </span>
                    </h3>
                </div>

                <div id="cartItems">
                    <?php if (count($_SESSION['cart']) > 0): ?>
                    <div class="space-y-3 mb-6">
                        <?php foreach ($_SESSION['cart'] as $index => $item): ?>
                        <div class="bg-gray-50 rounded-lg p-4 border border-gray-200 hover:shadow-md transition-shadow">
                            <div class="flex items-start justify-between">
                                <div class="flex-1">
                                    <div class="flex items-center mb-2">
                                        <span class="bg-purple-100 text-purple-800 text-xs font-semibold px-2 py-1 rounded">
                                            <?php echo htmlspecialchars($item['code_color']); ?>
                                        </span>
                                    </div>
                                    <h4 class="font-semibold text-gray-800 mb-1">
                                        <?php echo htmlspecialchars($item['color_name']); ?>
                                    </h4>
                                    <div class="grid grid-cols-2 gap-2 text-xs text-gray-600">
                                        <div>
                                            <span class="font-medium">Lokasi:</span> 
                                            <?php echo htmlspecialchars($item['lokasi_penyimpanan'] ?? '-'); ?>
                                        </div>
                                        <div>
                                            <span class="font-medium">Lemari:</span> 
                                            <?php echo htmlspecialchars($item['lemari_number'] ?? '-'); ?>
                                        </div>
                                    </div>
                                </div>
                                <a href="?remove=<?php echo $index; ?>" 
                                   class="ml-4 text-red-500 hover:text-red-700 transition-colors"
                                   onclick="return confirm('Hapus item ini dari keranjang?')">
                                    <i class="fas fa-trash text-lg"></i>
                                </a>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>

                    <div class="border-t pt-4">
                        <div class="bg-gradient-to-r from-purple-50 to-indigo-50 rounded-lg p-4 mb-4">
                            <h4 class="font-semibold text-gray-800 mb-2">Detail Peminjaman</h4>
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-2 text-sm text-gray-700">
                                <div>
                                    <span class="font-medium">Total Item:</span> 
                                    <span class="text-purple-600 font-bold"><?php echo count($_SESSION['cart']); ?></span>
                                </div>
                                <div>
                                    <span class="font-medium">Durasi:</span> 
                                    <span class="text-purple-600 font-bold">90 Hari</span>
                                </div>
                                <div>
                                    <span class="font-medium">Tanggal Pinjam:</span> 
                                    <?php echo date('d M Y'); ?>
                                </div>
                                <div>
                                    <span class="font-medium">Est. Pengembalian:</span> 
                                    <?php echo date('d M Y', strtotime('+90 days')); ?>
                                </div>
                            </div>
                        </div>

                        <form method="POST" action="" onsubmit="return confirm('Apakah Anda yakin ingin mengajukan peminjaman ini?')">
                            <button type="submit" 
                                    name="submit_peminjaman"
                                    class="w-full bg-gradient-to-r from-purple-500 to-indigo-600 hover:from-purple-600 hover:to-indigo-700 text-white font-bold py-3 px-6 rounded-lg transition duration-200 flex items-center justify-center shadow-lg">
                                <i class="fas fa-check-circle mr-2"></i>
                                Konfirmasi Peminjaman
                            </button>
                        </form>
                    </div>

                    <?php else: ?>
                    <div class="text-center py-12">
                        <i class="fas fa-shopping-cart text-gray-300 text-6xl mb-4"></i>
                        <p class="text-gray-500 text-lg mb-2">Keranjang Kosong</p>
                        <p class="text-gray-400 text-sm">Silakan scan barcode untuk menambah item</p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Toast Notification -->
<div id="toast" class="fixed top-4 right-4 z-50 hidden">
    <div class="bg-white rounded-lg shadow-lg p-4 min-w-[300px] border-l-4" id="toastContent">
        <div class="flex items-center">
            <i id="toastIcon" class="text-2xl mr-3"></i>
            <div class="flex-1">
                <p id="toastMessage" class="font-medium text-sm"></p>
            </div>
        </div>
    </div>
</div>

<style>
/* Custom styling untuk QR Code reader */
#reader {
    width: 100% !important;
    border: none !important;
}

#reader__dashboard_section {
    display: none !important;
}

#reader__scan_region {
    border-radius: 8px !important;
}

#reader video {
    border-radius: 8px !important;
}

/* Hide default select camera button */
#reader__camera_selection {
    display: none !important;
}
</style>

<script>
let html5QrCode = null;
let isScanning = false;
let isProcessing = false;
let lastScanTime = 0;
let scanCooldown = 1000; // 1 second cooldown between scans

// Toast notification function
function showToast(message, type = 'success') {
    const toast = document.getElementById('toast');
    const toastContent = document.getElementById('toastContent');
    const toastIcon = document.getElementById('toastIcon');
    const toastMessage = document.getElementById('toastMessage');
    
    if (type === 'success') {
        toastContent.classList.remove('border-red-500', 'border-yellow-500');
        toastContent.classList.add('border-green-500');
        toastIcon.className = 'fas fa-check-circle text-green-500 text-2xl mr-3';
    } else if (type === 'warning') {
        toastContent.classList.remove('border-red-500', 'border-green-500');
        toastContent.classList.add('border-yellow-500');
        toastIcon.className = 'fas fa-exclamation-triangle text-yellow-500 text-2xl mr-3';
    } else {
        toastContent.classList.remove('border-green-500', 'border-yellow-500');
        toastContent.classList.add('border-red-500');
        toastIcon.className = 'fas fa-exclamation-circle text-red-500 text-2xl mr-3';
    }
    
    toastMessage.textContent = message;
    toast.classList.remove('hidden');
    
    setTimeout(() => {
        toast.classList.add('hidden');
    }, 3000);
}

// Update scan status display
function updateScanStatus(message, icon = 'fa-camera', color = 'gray') {
    const status = document.getElementById('scanStatus');
    status.innerHTML = `
        <i class="fas ${icon} text-${color}-500 text-3xl mb-2"></i>
        <p class="text-${color}-600 text-sm font-medium">${message}</p>
    `;
}

// Update button states
function updateButtonStates(state) {
    const btnStart = document.getElementById('btnStartScan');
    const btnAgain = document.getElementById('btnScanAgain');
    
    switch(state) {
        case 'ready':
            btnStart.classList.remove('hidden');
            btnStart.innerHTML = '<i class="fas fa-camera mr-2"></i>Mulai Scan Barcode';
            btnStart.className = 'w-full bg-purple-500 hover:bg-purple-600 text-white font-semibold py-3 px-4 rounded-lg transition duration-200 flex items-center justify-center shadow-md';
            btnAgain.classList.add('hidden');
            break;
        case 'scanning':
            btnStart.innerHTML = '<i class="fas fa-stop mr-2"></i>Stop Scan';
            btnStart.className = 'w-full bg-red-500 hover:bg-red-600 text-white font-semibold py-3 px-4 rounded-lg transition duration-200 flex items-center justify-center shadow-md';
            btnAgain.classList.add('hidden');
            break;
        case 'success':
            btnStart.classList.add('hidden');
            btnAgain.classList.remove('hidden');
            break;
    }
}

// Process scanned barcode
function processBarcode(decodedText) {
    const currentTime = Date.now();
    
    // Check cooldown to prevent duplicate scans
    if (currentTime - lastScanTime < scanCooldown) {
        return;
    }
    
    // Check if already processing or not scanning
    if (!isScanning || isProcessing) {
        return;
    }
    
    // Sanitize the decoded text (remove any non-alphanumeric characters except allowed ones)
    const cleanedText = decodedText.trim().replace(/[^a-zA-Z0-9]/g, '');
    
    // Validate barcode format (adjust this according to your barcode format)
    if (cleanedText.length < 3 || cleanedText.length > 20) {
        return; // Ignore invalid barcodes
    }
    
    lastScanTime = currentTime;
    isProcessing = true;
    
    updateScanStatus('Memproses kode...', 'fa-spinner fa-spin', 'purple');
    
    const formData = new FormData();
    formData.append('ajax_scan', '1');
    formData.append('code_color', cleanedText);
    
    fetch('ajukan_peminjaman.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast(data.message, 'success');
            stopScanning();
            updateScanStatus('Scan berhasil! Klik tombol hijau untuk scan lagi', 'fa-check-circle', 'green');
            updateButtonStates('success');
            
            // Update cart count in real time
            document.getElementById('cartCount').textContent = data.cart_count;
            
            // Reload page after 2 seconds to update cart display
            setTimeout(() => {
                window.location.reload();
            }, 2000);
        } else {
            showToast(data.message, 'error');
            isProcessing = false;
            updateScanStatus('Scan gagal. Arahkan ke barcode lain...', 'fa-exclamation-circle', 'red');
            
            // Resume scanning after error
            setTimeout(() => {
                if (isScanning) {
                    updateScanStatus('Arahkan kamera ke barcode...', 'fa-camera', 'purple');
                }
            }, 2000);
        }
    })
    .catch(error => {
        console.error('Fetch Error:', error);
        showToast('Terjadi kesalahan sistem', 'error');
        isProcessing = false;
        updateScanStatus('Error sistem. Coba lagi...', 'fa-exclamation-triangle', 'red');
        
        // Resume scanning after error
        setTimeout(() => {
            if (isScanning) {
                updateScanStatus('Arahkan kamera ke barcode...', 'fa-camera', 'purple');
            }
        }, 2000);
    });
}

// Start scanning
function startScanning() {
    const readerDiv = document.getElementById('reader');
    
    if (!html5QrCode) {
        html5QrCode = new Html5Qrcode("reader");
    }
    
    updateScanStatus('Memulai kamera...', 'fa-spinner fa-spin', 'purple');
    updateButtonStates('scanning');
    readerDiv.style.display = 'block';
    
    const config = {
        fps: 10,
        qrbox: { width: 250, height: 250 },
        aspectRatio: 1.0,
        formatsToSupport: [
            Html5QrcodeSupportedFormats.CODE_128,
            Html5QrcodeSupportedFormats.CODE_39,
            Html5QrcodeSupportedFormats.EAN_13,
            Html5QrcodeSupportedFormats.EAN_8,
            Html5QrcodeSupportedFormats.UPC_A,
            Html5QrcodeSupportedFormats.UPC_E,
            Html5QrcodeSupportedFormats.QR_CODE
        ]
    };
    
    html5QrCode.start(
        { facingMode: "environment" },
        config,
        (decodedText, decodedResult) => {
            processBarcode(decodedText);
        },
        (errorMessage) => {
            // Ignore scanning errors (normal when no barcode in view)
        }
    ).then(() => {
        isScanning = true;
        isProcessing = false;
        lastScanTime = 0; // Reset scan time
        updateScanStatus('Arahkan kamera ke barcode...', 'fa-camera', 'purple');
    }).catch(err => {
        console.error('Unable to start scanning:', err);
        showToast('Gagal mengakses kamera', 'error');
        updateScanStatus('Gagal mengakses kamera', 'fa-exclamation-triangle', 'red');
        updateButtonStates('ready');
        readerDiv.style.display = 'none';
    });
}

// Stop scanning
function stopScanning() {
    const readerDiv = document.getElementById('reader');
    
    if (html5QrCode && isScanning) {
        html5QrCode.stop().then(() => {
            isScanning = false;
            isProcessing = false;
            readerDiv.style.display = 'none';
        }).catch(err => {
            console.error('Error stopping scanner:', err);
        });
    }
}

// Reset scanner for next scan
function resetScanner() {
    stopScanning();
    setTimeout(() => {
        updateScanStatus('Klik tombol untuk mulai scan', 'fa-camera', 'gray');
        updateButtonStates('ready');
    }, 500);
}

// Button click handlers
document.getElementById('btnStartScan').addEventListener('click', function() {
    if (!isScanning) {
        startScanning();
    } else {
        stopScanning();
        resetScanner();
    }
});

document.getElementById('btnScanAgain').addEventListener('click', function() {
    resetScanner();
    setTimeout(() => {
        startScanning();
    }, 600);
});

// Clean up on page unload
window.addEventListener('beforeunload', () => {
    if (html5QrCode && isScanning) {
        html5QrCode.stop();
    }
});
</script>

<?php include '../template_borrower/footer.php'; ?>