<?php
session_start();
require_once '../config/connection.php';

// Check if user is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'it') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

header('Content-Type: application/json');

$buyer_id = isset($_GET['buyer_id']) ? (int)$_GET['buyer_id'] : 0;

if ($buyer_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid buyer ID']);
    exit();
}

try {
    $query = "SELECT id, code_color, color_name 
              FROM master_color 
              WHERE buyer_id = ? 
              ORDER BY code_color ASC";
    
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $buyer_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $colors = [];
    
    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $colors[] = [
                'id' => $row['id'],
                'code_color' => htmlspecialchars($row['code_color']),
                'color_name' => htmlspecialchars($row['color_name'])
            ];
        }
    }
    
    $stmt->close();
    
    echo json_encode([
        'success' => true,
        'colors' => $colors,
        'total' => count($colors)
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}
?>