
<?php $__env->startSection('title','New Item Request'); ?>

<?php $__env->startPush('styles'); ?>
<style>
  .card-rounded{border-radius:1rem}
  .badge-soft{border:1px solid rgba(0,0,0,.05); background:rgba(13,110,253,.06); color:#0d6efd}
  .quote-table td,.quote-table th{padding:.35rem .5rem}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container my-4"
     x-data="newForm({
       company_id: '<?php echo e(old('company_id') ?? ($companies[0]->id ?? '')); ?>',
       flow_template_id: '<?php echo e(old('flow_template_id') ?? ($flows[0]->id ?? '')); ?>',
       posting_date: '<?php echo e(old('posting_date') ?? now()->toDateString()); ?>',
       vendor_name: '<?php echo e(old('vendor_name') ?? ''); ?>',
       remarks: <?php echo \Illuminate\Support\Js::from(old('remarks') ?? '')->toHtml() ?>,
       lines: <?php echo \Illuminate\Support\Js::from(old('lines') ?? [])->toHtml() ?>
     })">

  <div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="h4 mb-0">Create Item Request</h1>
    <a href="<?php echo e(route('approvals.mine')); ?>" class="btn btn-outline-secondary"><i class="fa fa-inbox me-1"></i> My Forms</a>
  </div>

  <?php if($errors->any()): ?>
    <div class="alert alert-danger"><i class="fa fa-triangle-exclamation me-1"></i><?php echo e($errors->first()); ?></div>
  <?php endif; ?>

  <form method="POST" action="<?php echo e(route('approvals.store')); ?>" enctype="multipart/form-data" novalidate>  
    <?php echo csrf_field(); ?>

    <div class="card card-rounded shadow-sm mb-3">
      <div class="card-header bg-light fw-semibold"><i class="fa fa-circle-info me-2"></i>Header</div>
      <div class="card-body">
        <div class="row g-3">
          <div class="col-md-3">
            <label class="form-label">Company</label>
            <select name="company_id" class="form-select" x-model="header.company_id" required>
              <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($c->id); ?>"><?php echo e($c->code); ?> — <?php echo e($c->name); ?></option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>
          <div class="col-md-4">
            <label class="form-label">Flow Template</label>
            <select name="flow_template_id" class="form-select" x-model="header.flow_template_id" required>
              <?php $__currentLoopData = $flows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($f->id); ?>"><?php echo e($f->name); ?> (v<?php echo e($f->version); ?>)</option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>
          <div class="col-md-3">
            <label class="form-label">Posting Date</label>
            <input type="date" name="posting_date" class="form-control" x-model="header.posting_date">
          </div>
          <div class="col-md-6">
            <label class="form-label">Vendor (header)</label>
            <input type="text" name="vendor_name" class="form-control" placeholder="Optional vendor at header" x-model="header.vendor_name">
          </div>
          <div class="col-12">
            <label class="form-label">Remarks</label>
            <textarea name="remarks" rows="2" class="form-control" x-model="header.remarks" placeholder="Any context for approvers..."></textarea>
          </div>
          <div class="card card-rounded shadow-sm mb-3">
            <div class="card-header bg-light fw-semibold d-flex justify-content-between align-items-center">
              <span><i class="fa fa-paperclip me-2"></i>Attachments</span>
              <small class="text-muted">Max 5 MB each</small>
            </div>
            <div class="card-body"
                x-data="{
                  files: [],
                  add(e){ this.files = Array.from(e.target.files || []); },
                  fmt(n){ return (n/1024/1024).toFixed(1) + ' MB'; }
                }">
              <div class="mb-2">
                <input class="form-control"
                      type="file"
                      name="attachments[]"
                      multiple
                      accept=".pdf,.jpg,.jpeg,.png,.doc,.docx,.xls,.xlsx,.csv,.txt"
                      @change="add($event)">
                <small class="text-muted">You can select several files at once.</small>
              </div>

              <template x-if="files.length">
                <div class="mt-2">
                  <div class="small text-muted mb-1">To upload</div>
                  <ul class="list-group">
                    <template x-for="(f,i) in files" :key="i">
                      <li class="list-group-item d-flex justify-content-between">
                        <span x-text="f.name"></span>
                        <span class="text-muted" x-text="fmt(f.size)"></span>
                      </li>
                    </template>
                  </ul>
                </div>
              </template>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="card card-rounded shadow-sm">
      <div class="card-header bg-light d-flex justify-content-between align-items-center">
        <span class="fw-semibold"><i class="fa fa-list me-2"></i>Lines</span>
        <div class="d-flex gap-2">
          <button type="button" class="btn btn-outline-secondary btn-sm" @click="expandAll()"><i class="fa fa-angle-down me-1"></i>Expand</button>
          <button type="button" class="btn btn-outline-secondary btn-sm" @click="collapseAll()"><i class="fa fa-angle-up me-1"></i>Collapse</button>
          <button type="button" class="btn btn-primary btn-sm" @click="add()"><i class="fa fa-plus me-1"></i>Add line</button>
        </div>
      </div>
      <div class="card-body">
        <template x-if="!lines.length">
          <div class="text-muted">No lines yet.</div>
        </template>

        <div class="accordion" id="linesAcc">
          <template x-for="(ln, idx) in lines" :key="ln._id">
            <div class="accordion-item border rounded-3 mb-2">
              <h2 class="accordion-header d-flex align-items-stretch">
                <button class="accordion-button py-2" :class="{'collapsed': !ln._open}" type="button"
                        @click="ln._open=!ln._open" :aria-expanded="ln._open">
                  <span class="me-2 badge" :class="{'text-bg-primary': ln.type==='Inventory','text-bg-success': ln.type==='Service','text-bg-warning text-dark': ln.type==='NonInventory'}">
                    #<span x-text="idx+1"></span>
                  </span>
                  <span class="ms-2" x-text="ln.article_name || 'Article name…'"></span>
                </button>
                <div class="d-flex align-items-center px-2">
                    <button type="button" class="btn btn-outline-secondary btn-sm me-2"
                          @click.stop="duplicate(idx)">
                    <i class="fa fa-copy"></i>
                  </button>
                  <button type="button" class="btn btn-outline-danger btn-sm" @click.stop="remove(idx)">
                    <i class="fa fa-trash"></i>
                  </button>
                </div>
              </h2>
              <div x-show="ln._open" x-collapse.duration.200ms>
                <div class="accordion-body bg-light">
                  <div class="row g-3">
                    <div class="col-md-6">
                      <label class="form-label">Article Name</label>
                      <input type="text" class="form-control" :name="'lines['+idx+'][article_name]'" x-model="ln.article_name" required>
                    </div>
                    <div class="col-md-3">
                      <label class="form-label">Type</label>
                      <select class="form-select" :name="'lines['+idx+'][type]'" x-model="ln.type" required>
                        <option>Inventory</option><option>Service</option><option>NonInventory</option>
                      </select>
                    </div>
                    <div class="col-md-3">
                      <label class="form-label">Base Unit</label>
                      <input type="text" class="form-control" :name="'lines['+idx+'][base_unit_code]'" x-model="ln.base_unit_code" required>
                    </div>

                    <div class="col-md-4">
                      <label class="form-label">GL Account (Service/NonInventory)</label>
                      <input type="text" class="form-control" :disabled="ln.type==='Inventory'"
                             :name="'lines['+idx+'][gl_account_no]'" x-model="ln.gl_account_no">
                    </div>
                    <div class="col-md-4">
                      <label class="form-label">Inventory Posting Group</label>
                      <input type="text" class="form-control" :name="'lines['+idx+'][inventory_posting_group_code]'" x-model="ln.inventory_posting_group_code">
                    </div>
                    <div class="col-md-4">
                      <label class="form-label">Gen. Prod. Posting Group</label>
                      <input type="text" class="form-control" :name="'lines['+idx+'][gen_prod_posting_group_code]'" x-model="ln.gen_prod_posting_group_code">
                    </div>

                    <div class="col-md-3">
                      <label class="form-label">L1</label>
                      <input type="text" class="form-control" :name="'lines['+idx+'][l1]'" x-model="ln.l1">
                    </div>
                    <div class="col-md-3">
                      <label class="form-label">L2</label>
                      <input type="text" class="form-control" :name="'lines['+idx+'][l2]'" x-model="ln.l2">
                    </div>
                    <div class="col-md-3">
                      <label class="form-label">Local Article No</label>
                      <input type="text" class="form-control" :name="'lines['+idx+'][article_no]'" x-model="ln.article_no">
                    </div>
                    <div class="col-12">
                      <label class="form-label">Line Remarks</label>
                      <textarea rows="2" class="form-control" :name="'lines['+idx+'][line_remarks]'" x-model="ln.line_remarks"></textarea>
                    </div>

                    <div class="col-12">
                      <div class="d-flex justify-content-between align-items-center">
                        <label class="form-label mb-0">Vendor Quotes</label>
                        <button type="button" class="btn btn-outline-primary btn-sm" @click="addQuote(idx)"><i class="fa fa-plus me-1"></i>Add quote</button>
                      </div>
                      <div class="table-responsive mt-2">
                        <table class="table table-sm table-bordered quote-table align-middle bg-white">
                          <thead class="table-light">
                            <tr>
                              <th style="width:38px"></th>
                              <th>Vendor</th>
                              <th style="width:160px">Price</th>
                              <th style="width:120px">Currency</th>
                              <th style="width:38px"></th>
                            </tr>
                          </thead>
                          <tbody>
                            <template x-for="(q, qidx) in ln.vendor_quotes" :key="q._id">
                              <tr>
                                <td class="text-center">
                                  <input class="form-check-input" type="radio"
                                         :name="'lines['+idx+'][vendor_selected]'"
                                         :value="qidx" x-model="ln.vendor_selected"
                                         :title="'Select '+(q.name||('Quote '+(qidx+1)))">
                                </td>
                                <td>
                                  <input type="text" class="form-control form-control-sm"
                                         :name="'lines['+idx+'][vendor_quotes]['+qidx+'][name]'"
                                         x-model="q.name" placeholder="Vendor name">
                                </td>
                                <td x-data="{
                                      display: '',
                                      init() { this.display = this.format(this.q.price) },
                                      format(val) {
                                        if (val === null || val === undefined || val === '') return '';
                                        return new Intl.NumberFormat().format(val);
                                      },
                                      parse(str) {
                                        let raw = str.replace(/,/g, '');
                                        return raw ? parseFloat(raw) : null;
                                      }
                                    }">
                                  
                                  <!-- Visible input -->
                                  <input
                                    type="text"
                                    class="form-control form-control-sm text-end"
                                    x-model="display"
                                    @input="q.price = parse(display)"
                                    @blur="display = format(q.price)"
                                    placeholder="0.00"
                                  />
                                
                                  <!-- Hidden input that goes to Laravel -->
                                  <input
                                    type="hidden"
                                    :name="'lines['+idx+'][vendor_quotes]['+qidx+'][price]'"
                                    :value="q.price"
                                  />
                                </td>
                                                            <td>
                                  <input type="text" class="form-control form-control-sm"
                                         :name="'lines['+idx+'][vendor_quotes]['+qidx+'][currency]'"
                                         x-model="q.currency" placeholder="IDR">
                                </td>
                                <td class="text-center">
                                  <button type="button" class="btn btn-outline-danger btn-sm" @click="removeQuote(idx,qidx)"><i class="fa fa-trash"></i></button>
                                </td>
                              </tr>
                            </template>
                            <template x-if="!ln.vendor_quotes.length">
                              <tr><td colspan="5" class="text-muted">No quotes yet.</td></tr>
                            </template>
                          </tbody>
                        </table>
                      </div>
                      <div class="small text-muted">Tip: select one quote to mark as preferred.</div>
                    </div>

                  </div>
                </div>
              </div>
            </div>
          </template>
        </div>
      </div>

      <div class="card-footer d-flex justify-content-end gap-2">
        <a href="<?php echo e(route('approvals.mine')); ?>" class="btn btn-outline-secondary">Cancel</a>
        <button type="submit" class="btn btn-success"><i class="fa fa-save me-1"></i> Save Draft</button>
      </div>
    </div>
  </form>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('alpine:init', () => {
  const uid = () => 'id'+Math.random().toString(36).slice(2);
  Alpine.data('newForm', (initial) => ({
    header: {
      company_id: initial.company_id || '',
      flow_template_id: initial.flow_template_id || '',
      posting_date: initial.posting_date || '',
      vendor_name: initial.vendor_name || '',
      remarks: initial.remarks || '',
    },
    lines: [],
    init(){
      if (Array.isArray(initial.lines) && initial.lines.length) {
        this.lines = initial.lines.map(l => this.hydrateLine(l));
      } else {
        this.add();
      }
    },
    hydrateLine(l){
      const base = {
        _id: uid(), _open: true,
        article_name:'', type:'Inventory', base_unit_code:'',
        gl_account_no:'', inventory_posting_group_code:'', gen_prod_posting_group_code:'',
        l1:'', l2:'', article_no:'', line_remarks:'',
        vendor_quotes: [], vendor_selected: null
      };
      base.vendor_quotes = Array.isArray(l.vendor_quotes) ? l.vendor_quotes.map(q => ({
        _id: uid(), name: q.name ?? '', price: q.price ?? '', currency: q.currency ?? 'IDR'
      })) : [];
      return Object.assign(base, l);
    },
    copyShared(prev){
      if (!prev) return {};
      return {
        type: prev.type,
        base_unit_code: prev.base_unit_code,
        inventory_posting_group_code: prev.inventory_posting_group_code,
        gen_prod_posting_group_code: prev.gen_prod_posting_group_code,
        l1: prev.l1,
        l2: prev.l2,
      };
    },
    scrollToBottom(){
      document.querySelector('#linesAcc')?.lastElementChild?.scrollIntoView({ behavior: 'smooth', block: 'start' });
    },
    add(){
      const prev = this.lines.length ? this.lines[this.lines.length - 1] : null;
      const payload = this.copyShared(prev);           
      this.lines.push(this.hydrateLine(payload));      
      this.$nextTick(() => this.scrollToBottom());
    },
    duplicate(i){
      const src = this.lines[i];
      const copy = JSON.parse(JSON.stringify(src));
      copy._id = uid();
      copy._open = true;
      copy.vendor_quotes = (copy.vendor_quotes || []).map(q => ({ ...q, _id: uid() }));
      this.lines.splice(i + 1, 0, copy);
      this.$nextTick(() => this.scrollToBottom());
    },
    remove(i){ this.lines.splice(i,1); if(!this.lines.length) this.add(); },
    expandAll(){ this.lines.forEach(l => l._open = true); },
    collapseAll(){ this.lines.forEach(l => l._open = false); },
    addQuote(i){ this.lines[i].vendor_quotes.push({_id:uid(),name:'',price:'',currency:'IDR'}); },
    removeQuote(i,qi){
      const ln = this.lines[i];
      if (String(ln.vendor_selected)===String(qi)) ln.vendor_selected = null;
      ln.vendor_quotes.splice(qi,1);
    },
  }));
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/pawc5944/public_html/bc/resources/views/approvals/new.blade.php ENDPATH**/ ?>