@extends('layouts.app')
@section('title','Admin — Approvals Management')

@push('styles')
<style>
    .pill { border-radius: 999px; }
    .card-rounded { border-radius: 1rem; }
</style>
@endpush

@section('content')
<div class="container py-4">
    @if(session('success'))
        <div class="alert alert-success"><i class="fa fa-check-circle me-1"></i>{{ session('success') }}</div>
    @endif
    @if($errors->any())
        <div class="alert alert-danger"><i class="fa fa-triangle-exclamation me-1"></i>{{ $errors->first() }}</div>
    @endif

    <ul class="nav nav-pills mb-3">
        <li class="nav-item"><a class="nav-link {{ $tab==='flows'?'active':'' }}" href="{{ route('admin.index',['tab'=>'flows']) }}#flows"><i class="fa fa-diagram-project me-1"></i>Flows</a></li>
        <li class="nav-item"><a class="nav-link {{ $tab==='users'?'active':'' }}" href="{{ route('admin.index',['tab'=>'users']) }}#users"><i class="fa fa-users me-1"></i>Users</a></li>
        <li class="nav-item"><a class="nav-link {{ $tab==='instances'?'active':'' }}" href="{{ route('admin.index',['tab'=>'instances']) }}#instances"><i class="fa fa-list-check me-1"></i>Instances</a></li>
        <li class="nav-item"><a class="nav-link {{ $tab==='requests'?'active':'' }}" href="{{ route('admin.index',['tab'=>'requests']) }}#requests"><i class="fa fa-file-pen me-1"></i>Requests</a></li>
        <li class="nav-item">
          <a class="nav-link {{ $tab==='roles'?'active':'' }}" 
             href="{{ route('admin.index',['tab'=>'roles']) }}#roles">
             <i class="fa fa-id-badge me-1"></i>Roles
          </a>
        </li>
    </ul>

    @if($tab === 'flows')
    <a id="flows"></a>
    <div class="card card-rounded mb-4">
        <div class="card-header bg-primary text-white"><i class="fa fa-plus me-1"></i>Create Flow Template</div>
        <div class="card-body">
            <form class="row g-3" method="POST" action="{{ route('admin.flows.store') }}">
                @csrf
                <div class="col-md-4">
                    <label class="form-label">Name</label>
                    <input name="name" class="form-control" placeholder="New Item SOP v2" required>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Object Type</label>
                    <input name="object_type" class="form-control" value="NewItem" required>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Version</label>
                    <input type="number" min="1" name="version" class="form-control" value="1" required>
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" name="is_active" id="is_active" value="1" checked>
                        <label class="form-check-label" for="is_active">Active</label>
                    </div>
                </div>
                <div class="col-12">
                    <button class="btn btn-primary"><i class="fa fa-save me-1"></i>Save Flow</button>
                </div>
            </form>
        </div>
    </div>

    @foreach($flows as $flow)
    <div class="card card-rounded mb-3">
        <div class="card-header d-flex justify-content-between align-items-center">
            <div>
                <span class="badge {{ $flow->is_active ? 'bg-success':'bg-secondary' }}">{{ $flow->is_active ? 'Active' : 'Inactive' }}</span>
                <strong class="ms-2">{{ $flow->name }}</strong>
                <span class="text-muted ms-1">({{ $flow->object_type }}, v{{ $flow->version }})</span>
            </div>
            <div class="d-flex gap-2">
                <form method="POST" action="{{ route('admin.flows.toggle',$flow) }}">@csrf
                    <button class="btn btn-outline-secondary btn-sm"><i class="fa fa-toggle-on"></i></button>
                </form>
                <form method="POST" action="{{ route('admin.flows.destroy',$flow) }}" onsubmit="return confirm('Delete this flow?');">
                    @csrf @method('DELETE')
                    <button class="btn btn-outline-danger btn-sm"><i class="fa fa-trash"></i></button>
                </form>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive mb-3">
                <table class="table table-sm align-middle">
                    <thead class="table-light">
                        <tr>
                            <th style="width:80px">Step</th>
                            <th>Approver (User)</th>
                            <th>Approver (Role)</th>
                            <th style="width:80px">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($flow->steps as $step)
                        <tr>
                            <td><span class="badge bg-info">#{{ $step->step_no }}</span></td>
                            <td>
                                @php $multi = $step->approvers ?? collect(); @endphp
                            
                                @if($multi->isNotEmpty())
                                  @foreach($multi as $ap)
                                    @if($ap->approver_user_id)
                                      <div class="mb-1">
                                        <strong>{{ $ap->user?->name ?? "User #{$ap->approver_user_id}" }}</strong>
                                        <div class="small text-muted">{{ $ap->user?->email ?? '—' }}</div>
                                      </div>
                                    @endif
                                  @endforeach
                                @elseif(!empty($step->approver_user_id))
                                  <strong>{{ $step->approverUser?->name ?? "User #{$step->approver_user_id}" }}</strong>
                                  <div class="small text-muted">{{ $step->approverUser?->email ?? '' }}</div>
                                @else
                                  <span class="text-muted">—</span>
                                @endif
                              </td>
                            
                              <td>
                                @if($multi->isNotEmpty())
                                  @foreach($multi as $ap)
                                    @if($ap->approver_role_id)
                                      <div class="small mb-1">{{ $ap->role?->code ?? "Role #{$ap->approver_role_id}" }}</div>
                                    @endif
                                  @endforeach
                                @elseif(!empty($step->approver_role_id))
                                  <div class="small">{{ $step->approverRole?->code ?? $step->approver_role_id }}</div>
                                @else
                                  <span class="text-muted">—</span>
                                @endif
                              </td>
                            <td>
                                <form method="POST" action="{{ route('admin.steps.destroy',$step) }}" onsubmit="return confirm('Remove this step?');">
                                    @csrf @method('DELETE')
                                    <button class="btn btn-outline-danger btn-sm"><i class="fa fa-trash"></i></button>
                                </form>
                            </td>
                        </tr>
                        @empty
                        <tr><td colspan="4" class="text-muted">No steps yet.</td></tr>
                        @endforelse
                        {{-- inline add step --}}
                        <tr>
                            <form method="POST" action="{{ route('admin.steps.store',$flow) }}">
                                @csrf
                                <td>
                                  <input type="number" min="1" class="form-control form-control-sm" name="step_no" placeholder="auto">
                                  <div class="form-check mt-1">
                                    <input class="form-check-input" type="checkbox" name="require_all" id="require_all_{{ $flow->id }}">
                                    <label class="form-check-label small" for="require_all_{{ $flow->id }}">Require all approvers</label>
                                  </div>
                                </td>
                            
                                <td>
                                  <label class="small text-muted">Users (multi)</label>
                                  <select name="approver_user_ids[]" class="form-select form-select-sm" multiple size="4">
                                    @foreach($users as $u)
                                      <option value="{{ $u->id }}">{{ $u->name }} ({{ $u->email }})</option>
                                    @endforeach
                                  </select>
                                  <div class="form-text small">Hold Ctrl/Cmd to choose more than one.</div>
                                </td>
                            
                                <td>
                                  <label class="small text-muted">Roles (multi)</label>
                                  <select name="approver_role_ids[]" class="form-select form-select-sm" multiple size="4">
                                    @foreach($roles as $r)
                                      <option value="{{ $r->id }}">{{ $r->code }}</option>
                                    @endforeach
                                  </select>
                                </td>
                            
                                <td class="align-middle">
                                  <button class="btn btn-success btn-sm"><i class="fa fa-plus"></i></button>
                                </td>
                              </form>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="small text-muted">
                Tip: leave <em>Step</em> empty to append to the end. Provide either a user or a role.
            </div>
        </div>
    </div>
    @endforeach
    @endif

    @if($tab === 'users')
    <a id="users"></a>

    <div class="card card-rounded mb-3">
    <div class="card-header bg-primary text-white"><i class="fa fa-user-plus me-1"></i> Add / Upsert User</div>
    <div class="card-body">
        <form class="row g-3" method="POST" action="{{ route('admin.users.store') }}">
        @csrf
        <div class="col-md-3">
            <label class="form-label">Name</label>
            <input name="name" class="form-control" placeholder="Full name" required>
        </div>
        <div class="col-md-4">
            <label class="form-label">Email</label>
            <input name="email" type="email" class="form-control" placeholder="user@yourtenant.onmicrosoft.com" required>
        </div>
        <div class="col-md-4">
            <label class="form-label">Notification Email(s) <small class="text-muted">(optional)</small></label>
            <input name="notify_email" type="text" class="form-control"
                    placeholder="e.g. alt@company.com or multiple separated by comma">
            <div class="form-text">You can enter multiple, separated by comma/semicolon/space.</div>
        </div>
        <div class="col-md-3">
            <label class="form-label">Role</label>
            <select name="role_id" class="form-select">
            <option value="">(none)</option>
            @foreach($roles as $r)
                <option value="{{ $r->id }}">{{ $r->code }}</option>
            @endforeach
            </select>
        </div>
        <div class="col-md-4">
          <label class="form-label">Companies</label>
          <select name="company_ids[]" class="form-select" multiple>
            @foreach($companies as $c)
              <option value="{{ $c->id }}">{{ $c->code }} — {{ $c->name }}</option>
            @endforeach
          </select>
          <div class="form-text">Hold Ctrl/Cmd to pick multiple.</div>
        </div>
                <div class="col-md-3">
          <label class="form-label">Company Codes (opt)</label>
          <input name="company_codes" class="form-control" placeholder="e.g. CI, TBI">
        </div>
        <div class="col-12">
            <button class="btn btn-primary"><i class="fa fa-save me-1"></i> Save</button>
        </div>
        </form>
        <div class="small text-muted mt-2">
        Users log in via Microsoft; adding them here just pre-creates the row and assigns a role.
        </div>
    </div>
    </div>

    <div class="card card-rounded">
    <div class="card-header bg-secondary text-white"><i class="fa fa-users me-1"></i> Users</div>
    <div class="card-body">
        <div class="table-responsive">
        <table class="table align-middle">
            <thead class="table-light">
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Notify Email</th>
                    <th>Company</th>
                    <th>Role</th>
                    <th>Change Role</th>   {{-- new explicit column --}}
                    <th>Edit</th>          {{-- full edit form sits here --}}
                    <th style="width:70px">Del</th>
                </tr>
                </thead>
                <tbody>
                @foreach($users as $u)
                <tr>
                <td>{{ $u->id }}</td>
                <td>{{ $u->name }}</td>
                <td class="small text-muted">{{ $u->email }}</td>
                <td class="small text-muted">{{ $u->notify_email ?: '—' }}</td>
                <td class="small">
                    @php $codes = $u->companies()->pluck('code')->all(); @endphp
                    {{ empty($codes) ? '—' : implode(', ', $codes) }}
                </td>

                {{-- Role badge --}}
                <td><span class="badge bg-dark">{{ $u->role?->code ?? '—' }}</span></td>
                <td>
                    <form class="d-flex gap-2" method="POST" action="{{ route('admin.users.updateRole',$u) }}">
                    @csrf
                    <select name="role_id" class="form-select form-select-sm" style="max-width:200px">
                        <option value="">(none)</option>
                        @foreach($roles as $r)
                        <option value="{{ $r->id }}" {{ $u->role_id===$r->id?'selected':'' }}>{{ $r->code }}</option>
                        @endforeach
                    </select>
                    <button class="btn btn-primary btn-sm"><i class="fa fa-save"></i></button>
                    </form>
                </td>
                <td>
                    <form class="d-flex flex-wrap gap-2 align-items-center"
                        method="POST" action="{{ route('admin.users.update', $u) }}">
                    @csrf
                    @method('PATCH')

                    <input name="name" class="form-control form-control-sm" style="max-width:180px"
                            value="{{ old('name',$u->name) }}">

                    <input name="notify_email" class="form-control form-control-sm" style="max-width:240px"
                            placeholder="alt1@x.com, alt2@x.com"
                            value="{{ old('notify_email',$u->notify_email) }}">

                    <select name="company_ids[]" class="form-select form-select-sm" style="max-width:260px" multiple>
                      @foreach($companies as $c)
                        <option value="{{ $c->id }}" {{ $u->companies->contains('id', $c->id) ? 'selected' : '' }}>
                          {{ $c->code }} — {{ $c->name }}
                        </option>
                      @endforeach
                    </select>
                    
                    {{-- (optional) codes textbox too --}}
                    <input name="company_codes" class="form-control form-control-sm" style="max-width:200px"
                           placeholder="CI, TBI">

                    <select name="role_id" class="form-select form-select-sm" style="max-width:180px">
                        <option value="">(none)</option>
                        @foreach($roles as $r)
                        <option value="{{ $r->id }}" {{ $u->role_id===$r->id?'selected':'' }}>{{ $r->code }}</option>
                        @endforeach
                    </select>

                    <button class="btn btn-primary btn-sm"><i class="fa fa-save"></i></button>
                    </form>
                </td>

                {{-- Delete --}}
                <td>
                    <form method="POST" action="{{ route('admin.users.destroy',$u) }}" onsubmit="return confirm('Delete this user?');">
                    @csrf @method('DELETE')
                    <button class="btn btn-outline-danger btn-sm"><i class="fa fa-trash"></i></button>
                    </form>
                </td>
                </tr>
                @endforeach
                </tbody>
        </table>
        {{ $users->withQueryString()->links() }}
        </div>
    </div>
    </div>
    @endif

    {{-- INSTANCES TAB --}}
    @if($tab === 'instances')
    <a id="instances"></a>
    <div class="card card-rounded">
        <div class="card-header bg-info text-white"><i class="fa fa-list-check me-1"></i>Approval Instances</div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th><th>Request #</th><th>Requester</th><th>Flow</th><th>Status</th><th>Step</th><th>Started</th><th>Completed</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($instances as $ins)
                        <tr>
                            <td>{{ $ins->id }}</td>
                            <td>
                                <a href="{{ route('approvals.show', $ins->itemRequest?->id) }}" class="text-decoration-none">
                                    <span class="badge bg-secondary">#{{ $ins->itemRequest?->id ?? '—' }}</span>
                                </a>
                            </td>
                            <td>{{ $ins->itemRequest?->requester?->name }}</td>
                            <td>{{ $ins->flow?->name }}</td>
                            <td><span class="badge {{ $ins->status==='InProgress'?'bg-warning':($ins->status==='Approved'?'bg-success':'bg-danger') }}">{{ $ins->status }}</span></td>
                            <td>{{ $ins->current_step_no }}</td>
                            <td>{{ optional($ins->started_at)->format('Y-m-d H:i') }}</td>
                            <td>{{ optional($ins->completed_at)->format('Y-m-d H:i') }}</td>
                        </tr>
                        @empty
                        <tr><td colspan="8" class="text-muted">No instances.</td></tr>
                        @endforelse
                    </tbody>
                </table>
                {{ $instances->withQueryString()->links() }}
            </div>
        </div>
    </div>
    @endif

    @if($tab === 'requests')
    <a id="requests"></a>
    <div class="card card-rounded">
    <div class="card-header bg-warning"><i class="fa fa-file-pen me-1"></i>Item Requests</div>
    <div class="card-body">
        <div class="table-responsive">
        <table class="table align-middle">
            <thead class="table-light">
            <tr>
                <th style="width:80px">ID</th>
                <th>Requester</th>
                <th>Status</th>
                <th style="width:90px">Step</th>
                <th>Flow</th>
                <th style="width:160px">Created</th>
                <th style="width:420px">Manage</th>
            </tr>
            </thead>
            <tbody>
            @forelse($requests as $r)
                @php
                $badge = match($r->status) {
                    'InReview' => 'bg-warning text-dark',
                    'Approved' => 'bg-success',
                    'Rejected' => 'bg-danger',
                    default => 'bg-secondary'
                };
                $max = \App\Models\ApprovalStepTemplate::where('flow_template_id',$r->flow_template_id)->max('step_no') ?? 0;
                @endphp
                <tr>
                <td>
                    <a href="{{ route('approvals.show',$r->id) }}" class="text-decoration-none">
                    <span class="badge bg-secondary">#{{ $r->id }}</span>
                    </a>
                </td>
                <td>{{ $r->requester?->name }}<div class="small text-muted">{{ $r->requester?->email }}</div></td>
                <td><span class="badge {{ $badge }}">{{ $r->status }}</span></td>
                <td><span class="badge bg-info text-dark">{{ $r->current_step_no ?: 0 }} / {{ $max }}</span></td>
                <td>{{ $r->flow?->name }} @if($r->flow?->version) v{{ $r->flow->version }} @endif</td>
                <td class="small text-muted">{{ $r->created_at?->format('Y-m-d H:i') }}</td>
                <td>
                    <div class="d-flex flex-wrap gap-2">
                    {{-- Reset to Draft --}}
                    <form method="POST" action="{{ route('admin.requests.reset',$r->id) }}">
                        @csrf
                        <button class="btn btn-outline-secondary btn-sm" onclick="return confirm('Reset to Draft?')">
                        <i class="fa fa-rotate-left me-1"></i> Reset Draft
                        </button>
                    </form>

                    {{-- Jump to step --}}
                    <form method="POST" action="{{ route('admin.requests.jump',$r->id) }}" class="d-flex align-items-center gap-1">
                        @csrf
                        <input type="number" name="step" min="1" class="form-control form-control-sm" style="width:80px"
                            value="{{ max(1,$r->current_step_no ?: 1) }}">
                        <button class="btn btn-outline-primary btn-sm">
                        <i class="fa fa-arrow-right-arrow-left me-1"></i> Jump
                        </button>
                    </form>

                    {{-- Force Approve --}}
                    <form method="POST" action="{{ route('admin.requests.forceApprove',$r->id) }}" class="d-flex align-items-center gap-1">
                        @csrf
                        <input type="text" name="comment" class="form-control form-control-sm" placeholder="Comment">
                        <button class="btn btn-success btn-sm"><i class="fa fa-thumbs-up me-1"></i> Approve</button>
                    </form>

                    {{-- Force Reject --}}
                    <form method="POST" action="{{ route('admin.requests.forceReject',$r->id) }}" class="d-flex align-items-center gap-1">
                        @csrf
                        <input type="text" name="comment" class="form-control form-control-sm" placeholder="Comment">
                        <button class="btn btn-danger btn-sm"><i class="fa fa-thumbs-down me-1"></i> Reject</button>
                    </form>

                    {{-- Delete --}}
                    <form method="POST" action="{{ route('admin.requests.destroy',$r->id) }}" onsubmit="return confirm('Delete this request permanently?')">
                        @csrf @method('DELETE')
                        <button class="btn btn-outline-danger btn-sm"><i class="fa fa-trash me-1"></i> Delete</button>
                    </form>
                    </div>
                </td>
                </tr>
            @empty
                <tr><td colspan="7" class="text-muted">No requests.</td></tr>
            @endforelse
            </tbody>
        </table>
        {{ $requests->withQueryString()->links() }}
        </div>
    </div>
    </div>
    @endif
    
    @if($tab === 'roles')
    <a id="roles"></a>
    
    <div class="card card-rounded mb-3">
      <div class="card-header bg-primary text-white">
        <i class="fa fa-plus me-1"></i> Add / Update Role
      </div>
      <div class="card-body">
        <form class="row g-3" method="POST" action="{{ route('admin.roles.store') }}">
          @csrf
          <div class="col-md-4">
            <label class="form-label">Code</label>
            <input name="code" class="form-control" placeholder="ADMIN" required>
          </div>
          <div class="col-md-6">
              <label class="form-label">Name</label>
              <input name="name" class="form-control" placeholder="Administrator role">
            </div>
          <div class="col-12">
            <button class="btn btn-primary"><i class="fa fa-save me-1"></i> Save</button>
          </div>
        </form>
      </div>
    </div>
    
    <div class="card card-rounded">
      <div class="card-header bg-secondary text-white">
        <i class="fa fa-id-badge me-1"></i> Roles
      </div>
      <div class="card-body">
        <div class="table-responsive">
          <table class="table align-middle">
            <thead class="table-light">
              <tr>
                <th>#</th>
                <th>Code</th>
                <th>Description</th>
                <th style="width:100px">Action</th>
              </tr>
            </thead>
            <tbody>
              @foreach($roles as $role)
              <tr>
                <td>{{ $role->id }}</td>
                <td>{{ $role->code }}</td>
                <td>{{ $role->name }}</td>
                <td>
                  <form method="POST" action="{{ route('admin.roles.destroy',$role) }}" 
                        onsubmit="return confirm('Delete this role?');">
                    @csrf @method('DELETE')
                    <button class="btn btn-outline-danger btn-sm">
                      <i class="fa fa-trash"></i>
                    </button>
                  </form>
                </td>
              </tr>
              @endforeach
            </tbody>
          </table>
          {{ $roles->withQueryString()->links() }}
        </div>
      </div>
    </div>
    @endif
</div>
@endsection
