<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'Business Central Dashboard'); ?></title>

    <!-- Bootstrap & Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- Vue & Axios (keep if you use them) -->
    <script src="https://unpkg.com/vue@3"></script>
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/xlsx/dist/xlsx.full.min.js"></script>
    
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/plugins/monthSelect/index.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/plugins/monthSelect/style.css">
    <!-- Alpine (once) -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script src="https://unpkg.com/@alpinejs/collapse@3.x.x/dist/cdn.min.js" defer></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('form').forEach(form => {
                const oldData = {};
                form.querySelectorAll('input, select, textarea').forEach(el => {
                    if (el.name) {
                        if (el.type === 'checkbox' || el.type === 'radio') {
                            oldData[el.name] = el.checked ? el.value : '';
                        } else if (el.files && el.files.length) {
                            oldData[el.name] = Array.from(el.files).map(f => f.name);
                        } else {
                            oldData[el.name] = el.value;
                        }
                    }
                });

                const input = document.createElement('input');
                input.type = 'hidden';
                input.name = '_old_data';
                input.value = JSON.stringify(oldData);
                form.appendChild(input);
            });
        });
    </script>
    <style>
        :root {
            --brand-start: #0d6efd;
            /* primary */
            --brand-end: #20c997;
            /* teal */
        }

        .navbar-gradient {
            background: linear-gradient(135deg, var(--brand-start), var(--brand-end));
        }

        .navbar .nav-link {
            border-radius: 999px;
            padding: .45rem .9rem;
            transition: background-color .15s ease, color .15s ease, transform .06s ease-in;
        }

        .navbar .nav-link:hover {
            background: rgba(255, 255, 255, .12);
        }

        .nav-link.active,
        .nav-link.nav-link-active {
            background: rgba(255, 255, 255, .22);
            color: #fff !important;
            font-weight: 600;
        }

        .dropdown-menu {
            border-radius: .8rem;
            border: 1px solid rgba(0, 0, 0, .05);
            box-shadow: 0 10px 30px rgba(0, 0, 0, .08);
        }

        .chip-role {
            font-size: .75rem;
            padding: .15rem .5rem;
            border-radius: 999px;
            background: rgba(255, 255, 255, .18);
        }

        .content-shell {
            max-width: 1320px;
        }

        .card-soft {
            border-radius: 1rem;
            border: 1px solid rgba(0, 0, 0, .06);
            box-shadow: 0 8px 24px rgba(0, 0, 0, .05);
        }

        .breadcrumb {
            --bs-breadcrumb-divider-color: currentColor;
            --bs-breadcrumb-item-active-color: inherit;
        }

        [data-theme="dark"] .dropdown-menu {
            background: #1f2937;
            border-color: rgba(255, 255, 255, .08);
        }

        [data-theme="dark"] .dropdown-item {
            color: #e5e7eb;
        }

        [data-theme="dark"] .dropdown-item:hover {
            background: rgba(255, 255, 255, .06);
        }

        /* Toast slot sits fixed bottom-right */
        .toast-slot {
            position: fixed;
            right: 1rem;
            bottom: 1rem;
            z-index: 1080;
        }
    </style>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body x-data="theme()" x-init="init()" :data-theme="mode"
    :class="mode === 'dark' ? 'bg-dark text-light' : 'bg-light text-dark'">
    <?php
        use Illuminate\Support\Str;
        use Illuminate\Support\Carbon;
        use App\Models\OpnameSchedule;

        $meEmail = session('user.email') ?? (session('user')['email'] ?? null);
        $me = $meEmail ? \App\Models\User::firstWhere('email', $meEmail) : null;

        $isAdmin = $me && $me->role?->code === 'ADMIN';
        $isUser = $me && $me->role?->code === 'User';

        $roleLabel = data_get(session('user'), 'role') ?? 'User';

        $allowedNames = [
            'Titania',
            'Feybe Anjeli Sitanggang',
            'Pratiwi',
            'Michael Daniel',
            'I Gusti Ayu Murti Adnyani',
            'Dinda',
        ];

        $canAccessRestricted = ($me && Str::contains($me->name, $allowedNames)) || $isAdmin;

        // ======================================================
        // CEK OPNAME SCHEDULE STATUS "Start" DI BULAN BERJALAN
        // ======================================================
        $me2= auth()->user();
        $unit = $me2->business_unit;

        $isOpname = OpnameSchedule::where('status', 'Start')
            ->whereMonth('start_at', Carbon::now()->month)
            ->whereYear('start_at', Carbon::now()->year)
            ->when(!$isAdmin && $unit, function ($q) use ($unit) {
                $q->where('location', $unit);
            })
            ->exists();

    ?>

    <nav class="navbar navbar-expand-lg navbar-dark navbar-gradient shadow-sm sticky-top">
        <div class="container-fluid content-shell">
            <a class="navbar-brand d-flex align-items-center gap-2" href="<?php echo e(route('dashboard')); ?>">
                <i class="fa-solid fa-clipboard-check"></i>
                <span>Stock Opname Dashboard</span>
            </a>


            <button class="navbar-toggler border-0" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"
                aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse justify-content-between" id="navbarNav">
                <ul class="navbar-nav gap-1 me-auto">

                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle <?php echo e(request()->is('item-requests*') || request()->is('approvals*') ? 'active nav-link-active' : ''); ?>"
                            href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fa-solid fa-check-double me-1"></i> Approvals
                        </a>
                        <ul class="dropdown-menu">
                            <?php if($isOpname): ?>
                                <li><a class="dropdown-item" href="<?php echo e(route('approvals.new')); ?>"><i
                                            class="fa fa-plus me-2"></i> New Opname Request</a></li>
                            <?php endif; ?>
                            <li><a class="dropdown-item" href="<?php echo e(route('approvals.mine')); ?>"><i
                                        class="fa fa-inbox me-2"></i> My Forms</a></li>
                            <li><a class="dropdown-item" href="<?php echo e(url('/approvals/inbox')); ?>"><i
                                        class="fa fa-envelope-open-text me-2"></i> Inbox</a></li>
                            <li><a class="dropdown-item" href="<?php echo e(route('approvals.all')); ?>"><i
                                        class="fa fa-clipboard-list me-2"></i> All Requests</a></li>
                            <?php if($isAdmin): ?>
                                <li>
                                    <hr class="dropdown-divider">
                                </li>
                                <li><a class="dropdown-item" href="<?php echo e(route('admin.index')); ?>"><i
                                            class="fa fa-toolbox me-2"></i> Admin (Flows, Steps, Users)</a></li>
                                <li><a class="dropdown-item" href="<?php echo e(route('admin.business.unit')); ?>"><i
                                            class="fa fa-toolbox me-2"></i> Admin (Manage User Location)</a></li>
                            <?php endif; ?>
                        </ul>
                    </li>
                    
                </ul>

                <!-- Right controls -->
                <ul class="navbar-nav align-items-center gap-2">
                    <!-- Theme toggle -->
                    <div class="position-relative dropdown me-3">
                        <button class="btn position-relative" id="commentBell" data-bs-toggle="dropdown"
                            aria-expanded="false">
                            <i class="fa-regular fa-bell fa-xl"></i>
                            <span id="bellBadge"
                                class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger d-none">
                                0
                            </span>
                        </button>

                        <ul class="dropdown-menu dropdown-menu-end shadow-lg p-2"
                            style="width: 420px; max-height: 420px; overflow-y: auto; overflow-x: hidden;"
                            id="commentList">
                            <li class="text-center text-muted small py-2">Loading comments...</li>
                        </ul>
                    </div>

                    <li class="nav-item">
                        <button class="btn btn-sm btn-outline-light d-flex align-items-center gap-2" @click="toggle()"
                            :aria-label="mode === 'dark' ? 'Switch to light mode' : 'Switch to dark mode'">
                            <i :class="mode === 'dark' ? 'fa-solid fa-sun' : 'fa-solid fa-moon'"></i>
                            <span class="d-none d-md-inline" x-text="mode === 'dark' ? 'Light' : 'Dark'"></span>
                        </button>
                    </li>

                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle d-flex align-items-center gap-2" href="#"
                            id="companyDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fa-solid fa-building"></i>
                            <span><?php echo e(session('current_company_name', data_get(session('user'), 'role'))); ?></span>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="companyDropdown">
                            <?php if(data_get(session('user'), 'role') === 'Regent'): ?>
                                <li><a class="dropdown-item" href="<?php echo e(route('switch-company', 'Regent')); ?>">Regent</a>
                                </li>
                            <?php elseif(data_get(session('user'), 'role') === 'HIN'): ?>
                                <li><a class="dropdown-item" href="<?php echo e(route('switch-company', 'HIN')); ?>">HIN</a></li>
                            <?php elseif(data_get(session('user'), 'role') === 'SUPER'): ?>
                                <li><a class="dropdown-item" href="<?php echo e(route('switch-company', 'Regent')); ?>">Regent</a>
                                </li>
                                <li><a class="dropdown-item" href="<?php echo e(route('switch-company', 'HIN')); ?>">HIN</a></li>
                            <?php endif; ?>
                        </ul>
                    </li>
                    <?php if(session('user')): ?>
                        <li class="nav-item dropdown d-flex align-items-center">
                            <a class="nav-link dropdown-toggle d-flex align-items-center" href="#"
                                id="userDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fa-solid fa-user-circle me-1"></i>
                                <span
                                    class="fw-semibold small text-dark"><?php echo e(data_get(session('user'), 'email')); ?></span>
                            </a>

                            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
                                <li>
                                    <h6 class="dropdown-header">Aplikasi</h6>
                                </li>

                                <li><a class="dropdown-item" href="https://pawindo.site/bc/login">BC</a></li>
                                <li><a class="dropdown-item" href="https://pawindo.site/butcher/login">Butcher</a>
                                </li>
                                <li><a class="dropdown-item"
                                        href="https://pawindo.site/Pastry/public_html/login">Pastry</a></li>

                                <li>
                                    <hr class="dropdown-divider">
                                </li>
                                <li><a class="dropdown-item text-danger" href="<?php echo e(route('logout')); ?>">Logout</a></li>
                            </ul>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>

    <header class="py-3">
        <div class="container content-shell">
            <?php if (! empty(trim($__env->yieldContent('breadcrumb')))): ?>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-2">
                        <?php echo $__env->yieldContent('breadcrumb'); ?>
                    </ol>
                </nav>
            <?php endif; ?>

            <?php if(session('status')): ?>
                <div class="alert alert-success card-soft mb-0">
                    <i class="fa-solid fa-circle-check me-2"></i> <?php echo e(session('status')); ?>

                </div>
            <?php endif; ?>
        </div>
    </header>

    <!-- CONTENT -->
    <main class="py-3 py-md-4">
        <div class="container content-shell">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </main>

    <!-- Toast slot -->
    <div class="toast-slot">
        <?php echo $__env->yieldPushContent('toasts'); ?>
    </div>

    <!-- FOOTER -->
    <footer class="py-4 border-top">
        <div class="container content-shell d-flex justify-content-between small text-muted">
            <span>&copy; <?php echo e(now()->year); ?> — BC Portal</span>
            <span>v<?php echo e(config('app.version', '1.0')); ?></span>
        </div>
    </footer>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function theme() {
            return {
                mode: localStorage.getItem('theme') || 'light',
                init() {
                    this.apply();
                },
                toggle() {
                    this.mode = this.mode === 'light' ? 'dark' : 'light';
                    localStorage.setItem('theme', this.mode);
                    this.apply();
                },
                apply() {
                    document.documentElement.setAttribute('data-theme', this.mode);
                    document.body.classList.toggle('bg-dark', this.mode === 'dark');
                    document.body.classList.toggle('text-light', this.mode === 'dark');
                    document.body.classList.toggle('bg-light', this.mode === 'light');
                    document.body.classList.toggle('text-dark', this.mode === 'light');
                }
            }
        }
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', async () => {
            const badge = document.getElementById('bellBadge');
            const commentList = document.getElementById('commentList');
            const commentBell = document.getElementById('commentBell');

            let allComments = []; // semua data komentar dari backend
            let visibleCount = 0; // berapa banyak komentar yang sudah ditampilkan
            const batchSize = 5; // tampilkan 5 komentar per scroll
            let loading = false;
            let allLoaded = false;

            // 🔔 Ambil jumlah komentar belum dibaca
            async function fetchUnread() {
                try {
                    const res = await fetch("<?php echo e(route('unread-comment')); ?>");
                    const data = await res.json();
                    if (data.unread > 0) {
                        badge.textContent = data.unread;
                        badge.classList.remove('d-none');
                    } else {
                        badge.classList.add('d-none');
                    }
                } catch (err) {
                    console.error('Error fetching unread count:', err);
                }
            }

            // 📩 Ambil semua komentar sekali saja
            async function fetchAllComments() {
                try {
                    const res = await fetch("<?php echo e(route('fetch-comment')); ?>");
                    const data = await res.json();
                    allComments = data.comments || [];
                    visibleCount = 0;
                    allLoaded = false;
                    commentList.innerHTML = '';

                    if (allComments.length === 0) {
                        commentList.innerHTML =
                            '<li class="text-center text-muted py-2">No comments yet.</li>';
                        allLoaded = true;
                    } else {
                        renderNextBatch();
                    }
                } catch (err) {
                    console.error('Error fetching comments:', err);
                }
            }

            // =====================================================
            // THEME HELPERS
            // =====================================================
            function isDarkMode() {
                // Ubah selector jika aplikasi kamu memakai class lain
                return document.body.classList.contains('dark-mode');
            }

            function getCommentClasses() {
                if (isDarkMode()) {
                    return {
                        itemBg: 'bg-dark text-light',
                        subText: 'text-secondary',
                        spinner: 'text-light'
                    };
                }
                return {
                    itemBg: 'bg-white text-dark',
                    subText: 'text-muted',
                    spinner: 'text-primary'
                };
            }

            // =====================================================
            //  MAIN FUNCTION
            // =====================================================
            function renderNextBatch() {
                if (loading || allLoaded) return;
                loading = true;

                const theme = getCommentClasses();

                // Hapus spinner lama (kalau masih ada)
                const oldSpinner = document.getElementById('commentSpinner');
                if (oldSpinner) oldSpinner.remove();

                // Tambahkan spinner baru
                const spinnerItem = document.createElement('li');
                spinnerItem.className = 'dropdown-item text-center py-2';
                spinnerItem.id = 'commentSpinner';
                spinnerItem.innerHTML = `
        <div class="spinner-border spinner-border-sm ${theme.spinner}" role="status"></div>
    `;
                commentList.appendChild(spinnerItem);

                // Simulasi delay agar loading terasa natural
                setTimeout(() => {
                    const start = visibleCount;
                    const end = start + batchSize;
                    const nextBatch = allComments.slice(start, end);

                    spinnerItem.remove(); // Hapus spinner sebelum render batch baru

                    nextBatch.forEach(c => {
                        const li = document.createElement('li');
                        li.className = `dropdown-item px-2 py-2 ${theme.itemBg}`;

                        const truncatedBody = c.body && c.body.length > 100 ?
                            c.body.substring(0, 100) + '...' :
                            (c.body || '');

                        const approvalUrl = "<?php echo e(route('approvals.show', ':id')); ?>".replace(
                            ':id', c.request?.id
                        );

                        const requestIdTag = c.request?.id ?
                            ` <span class="text-primary">(#${c.request.id})</span>` :
                            '';

                        li.innerHTML = `
                <a href="${approvalUrl}" class="text-decoration-none d-block ${isDarkMode() ? 'text-light' : 'text-dark'}">
                    <div class="fw-bold small">
                        ${c.user?.name || 'Unknown User'}${requestIdTag}
                    </div>
                    <div class="${theme.subText} small" 
                        style="white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">
                        ${truncatedBody}
                    </div>
                    <small class="${theme.subText}">${new Date(c.created_at).toLocaleString()}</small>
                </a>
                <hr class="my-1">
            `;

                        commentList.appendChild(li);
                    });

                    visibleCount += nextBatch.length;

                    // Jika semua komentar sudah tampil
                    if (visibleCount >= allComments.length) {
                        allLoaded = true;
                    } else {
                        // Tambahkan spinner lagi untuk batch berikutnya
                        const newSpinner = document.createElement('li');
                        newSpinner.className = 'dropdown-item text-center py-2';
                        newSpinner.id = 'commentSpinner';
                        newSpinner.innerHTML = `
                <div class="spinner-border spinner-border-sm ${theme.spinner}" role="status"></div>
            `;
                        commentList.appendChild(newSpinner);
                    }

                    loading = false;
                }, 400);
            }


            // ✅ Saat dropdown dibuka
            commentBell.addEventListener('click', async () => {
                await fetchAllComments();
                await fetch("<?php echo e(route('mark-comment')); ?>", {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                        'Content-Type': 'application/json'
                    }
                });

                fetchUnread();
            });

            // 📜 Scroll untuk load batch berikutnya
            commentList.addEventListener('scroll', () => {
                const nearBottom = commentList.scrollTop + commentList.clientHeight >= commentList
                    .scrollHeight - 5;
                if (nearBottom && !loading && !allLoaded) {
                    renderNextBatch();
                }
            });

            // ⏳ Polling badge setiap 60 detik
            fetchUnread();
            setInterval(fetchUnread, 60000);
        });
    </script>


    <script>
        document.addEventListener("DOMContentLoaded", function() {

            const autosaveForms = document.querySelectorAll("form[data-autosave='true']");
            if (!autosaveForms.length) return;

            autosaveForms.forEach(form => {

                // Tandai kalau user submit manual
                form.addEventListener('submit', () => {
                    form.dataset.submitting = '1';
                });

                // Trigger autosave saat user keluar dari form
                form.addEventListener("focusout", function(e) {
                    const next = e.relatedTarget;

                    // Pindah antar input → abaikan
                    if (next && form.contains(next)) return;

                    autoSave(form);
                });

            });

            function autoSave(form) {

                // Jangan autosave kalau submit manual
                if (form.dataset.submitting === '1') return;

                const url = form.getAttribute("action");
                const mode = form.dataset.autosaveMode || 'new' || 'edit';
                const methodAttr = (form.getAttribute("method") || "POST").toUpperCase();

                const formData = new FormData(form);

                // CSRF
                const token = document.querySelector('meta[name="csrf-token"]')?.content;
                if (token) formData.set('_token', token);

                // Method spoofing
                if (methodAttr !== "POST") {
                    formData.set('_method', methodAttr);
                }

                // Flag autosave
                formData.set("is_autosave", "1");

                fetch(url, {
                        method: "POST", // SELALU POST (Laravel-style)
                        body: formData
                    })
                    .then(res => res.json().catch(() => null))
                    .then(data => {

                        // Toast autosave
                        Swal.fire({
                            toast: true,
                            position: "top-end",
                            icon: "success",
                            title: "Autosaved",
                            showConfirmButton: false,
                            timer: 1200,
                            timerProgressBar: true,
                        });

                        // =============================
                        // NEW MODE → redirect pertama
                        // =============================
                        if (
                            mode === 'new' &&
                            data &&
                            data.new_id &&
                            data.redirect_to
                        ) {
                            document.body.classList.add("fade-out");

                            setTimeout(() => {
                                window.location.href = data.redirect_to;
                            }, 450);
                        }

                        console.log("AUTOSAVED:", {
                            mode,
                            response: data
                        });

                    })
                    .catch(err => {
                        console.error("Autosave error:", err);
                    });
            }

        });
    </script>

    <style>
        .fade-out {
            opacity: 0;
            transition: opacity 0.5s ease-in-out;
        }

        .fade-in {
            opacity: 1;
            transition: opacity 0.5s ease-in-out;
        }

        body {
            opacity: 1;
        }
    </style>






    <?php echo $__env->yieldPushContent('scripts'); ?>
    <?php echo $__env->yieldPushContent('vendor-edit-scripts'); ?>
</body>

</html>
<?php /**PATH C:\Users\Lenovo\OneDrive\Documents\Kerjaan\stockopname\resources\views/layouts/app.blade.php ENDPATH**/ ?>