
<?php $__env->startSection('title', 'Operations Dashboard'); ?>

<?php $__env->startPush('styles'); ?>
    <style>
        .location-export {
            cursor: pointer;
            position: relative;
            transition: all .2s ease;
        }

        .location-export:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 18px rgba(0, 0, 0, .12);
            background: linear-gradient(135deg, #dcfce7, #bbf7d0);
        }

        /* icon kecil kanan atas */
        .location-export::after {
            content: "⬇";
            position: absolute;
            top: 6px;
            right: 8px;
            font-size: 12px;
            opacity: .6;
        }

        /* hint text */
        .export-hint {
            font-size: .8rem;
            color: #64748b;
            margin-top: 4px;
        }

        .location-card-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(110px, 1fr));
            gap: 10px;
            margin-top: 10px;
        }

        .location-card {
            background: #f8fafc;
            border: 1px solid #e5e7eb;
            border-radius: 12px;
            padding: 10px 12px;
            text-align: center;
            font-weight: 700;
            font-size: .85rem;
            color: #0f172a;
            box-shadow: 0 4px 10px rgba(0, 0, 0, .04);
        }

        .location-card.done {
            background: linear-gradient(135deg, #ecfdf5, #d1fae5);
            border-color: #86efac;
            color: #065f46;
        }

        .location-list-container {
            max-height: 220px;
            /* Tinggi maksimum */
            overflow-y: auto;
            /* Scroll jika penuh */
            background: #ffffff;
            /* Pastikan terlihat */
            border-radius: 14px;
            border: 1px solid #e2e8f0;
            /* agar terpisah dari latar */
            padding: 10px 14px;
            margin-top: 10px;
        }

        .location-list-container ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .location-list-container li {
            padding: 5px 0;
            font-size: 0.9rem;
            border-bottom: 1px dashed #e5e7eb;
        }

        .location-list-container li:last-child {
            border-bottom: none;
        }

        .opname-hero {
            background: linear-gradient(135deg, #ffffff, #f3f6ff);
            border-radius: 22px;
            padding: 32px;
            box-shadow: 0 20px 45px rgba(0, 0, 0, .08);
        }

        .opname-title {
            font-size: 1.7rem;
            font-weight: 800
        }

        .opname-sub {
            color: #6c757d
        }

        .status-pill {
            display: inline-flex;
            padding: .45rem .9rem;
            border-radius: 999px;
            font-weight: 700;
            font-size: .8rem;
        }

        .status-pending {
            background: #fff3cd;
            color: #856404
        }

        .status-start {
            background: #e9f7ef;
            color: #198754
        }

        .status-pause {
            background: #e2e3e5;
            color: #41464b
        }

        .status-end {
            background: #e7f1ff;
            color: #084298
        }

        .status-cancel {
            background: #f8d7da;
            color: #842029
        }

        .admin-box {
            background: rgba(255, 255, 255, .9);
            border-radius: 16px;
            padding: 16px;
        }

        .btn-soft {
            background: #eef2ff;
            border: none
        }

        .btn-soft:hover {
            background: #e0e7ff
        }

        .countdown {
            margin-top: 10px;
            font-weight: 600;
            font-family: ui-monospace, Menlo, monospace;
        }

        .loader {
            width: calc(330px / cos(45deg));
            height: 14px;
            background: repeating-linear-gradient(-45deg, #000 0 15px, #0000 0 20px) left/200% 100%;
            animation: l3 2s infinite linear;
        }

        @keyframes l3 {
            100% {
                background-position: right
            }
        }

        .alert-simple.alert-success {
            border: 1px solid rgba(36, 241, 6, .46);
            background: rgba(7, 149, 66, .12);
            box-shadow: 0 0 2px #259c08;
            color: #0ad406;
        }

        .greencross {
            color: #25ff0b;
            font-size: 18px
        }

        .admin-box {
            background: rgba(255, 255, 255, .92);
            border-radius: 16px;
            padding: 18px;
            box-shadow: 0 8px 20px rgba(0, 0, 0, .06);
        }

        .admin-box-title {
            font-weight: 700;
            font-size: .9rem;
            letter-spacing: .4px;
            color: #6c757d;
            margin-bottom: 10px;
        }

        /* GRID BUTTON */
        .admin-actions {
            display: grid;
            grid-template-columns: 1fr;
            gap: 10px;
        }

        /* BASE BUTTON */
        .btn-admin {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            height: 44px;
            /* 🔥 SAMA TINGGI */
            width: 100%;
            border-radius: 10px;
            font-weight: 600;
            font-size: .9rem;
            border: none;
            transition: .25s ease;
        }

        /* HOVER EFFECT */
        .btn-admin:hover {
            transform: translateY(-1px);
            box-shadow: 0 6px 14px rgba(0, 0, 0, .12);
        }

        /* VARIANTS (SOFT & EYE-FRIENDLY) */
        .btn-start {
            background: #e8f2ff;
            color: #0d6efd;
        }

        .btn-start:hover {
            background: #dce9ff;
        }

        .btn-pause {
            background: #fff4e5;
            color: #b45309;
        }

        .btn-pause:hover {
            background: #ffebcc;
        }

        .btn-extend {
            background: #eef2ff;
            color: #4338ca;
        }

        .btn-extend:hover {
            background: #e0e7ff;
        }

        .btn-finish {
            background: #e6f7ee;
            color: #15803d;
        }

        .btn-finish:hover {
            background: #dcf5e6;
        }

        .btn-cancel {
            background: #fde8e8;
            color: #b91c1c;
        }

        .btn-cancel:hover {
            background: #fbd5d5;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container my-4">

        <div class="opname-hero mb-4">

            <div class="mb-3">
                <div class="opname-title">Halo, <?php echo e(auth()->user()->name); ?> 👋</div>
                <div class="opname-sub">Dashboard Stock Opname</div>
            </div>
            
            <?php if (! ($isAdmin)): ?>
                <div class="alert alert-info mb-4">
                    📌 Menampilkan jadwal untuk Business Unit:
                    <strong><?php echo e(auth()->user()->business_unit ?? '–'); ?></strong>
                </div>
            <?php endif; ?>

            
            <?php if($opnames->count() > 0): ?>

                
                <?php $__currentLoopData = $opnames; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opname): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="p-4 mb-4" style="border:1px solid #ddd;border-radius:20px; background:white;">
                        <div class="row align-items-center">

                            <div class="col-md-8">

                                <div class="opname-title mb-1">📦 Stock Opname — <?php echo e($opname->location); ?></div>

                                <div class="opname-sub">
                                    Periode: <strong><?php echo e($opname->periode); ?></strong><br>
                                    <?php echo e($opname->start_at?->format('d M Y')); ?> →
                                    <?php echo e($opname->end_at?->format('d M Y')); ?>

                                </div>

                                <div class="mt-2">
                                    <span class="status-pill status-<?php echo e(strtolower($opname->status)); ?>">
                                        <?php echo e(strtoupper($opname->status)); ?>

                                    </span>
                                </div>

                                <div class="countdown text-muted" data-countdown data-id="<?php echo e($opname->id); ?>"
                                    data-status="<?php echo e($opname->status); ?>"
                                    data-end="<?php echo e($opname->end_at?->format('Y-m-d H:i:s')); ?>">
                                </div>

                                
                                <?php if(!$isAdmin): ?>
                                    <?php
                                        // Ambil hanya lokasi yang SUDAH ADA DATA
                                        $completedLocations = collect($opname->location_status ?? [])
                                            ->filter(fn($done) => $done === true)
                                            ->keys();
                                    ?>

                                    <?php if($completedLocations->isNotEmpty()): ?>
                                        <div class="mt-3">
                                            <strong>📍 Lokasi yang Bisa diambil:</strong>
                                            <div class="export-hint">
                                                Klik lokasi untuk mengunduh data stock opname <i class="fa-solid fa-download"></i>
                                            </div>
                                            <div class="location-card-grid mt-2">
                                                <?php $__currentLoopData = $completedLocations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <button type="button" class="location-card done location-export"
                                                        title="Klik untuk export data stock opname"
                                                        data-location="<?php echo e($loc); ?>"
                                                        data-periode="<?php echo e($opname->periode); ?>">
                                                        <?php echo e($loc); ?>

                                                    </button>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                <?php endif; ?>


                                
                                <?php if($isAdmin): ?>
                                    <div class="mt-3">
                                        <strong>📍 Lokasi Group:</strong>
                                        <span class="badge bg-primary"><?php echo e($opname->location); ?></span>

                                        <?php
                                            $list = \App\Models\Location::where('location', $opname->location)->get();
                                        ?>

                                        <div class="location-list-container mt-2">
                                            <ul>
                                                <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php
                                                        $hasData = $opname->location_status[$loc->code] ?? false;
                                                    ?>


                                                    <li>
                                                        <?php echo e($loc->code); ?> —
                                                        <small class="text-muted"><?php echo e($loc->name); ?></small>

                                                        <?php if($hasData): ?>
                                                            <span class="badge bg-success ms-2">✔ Sudah Diambil</span>
                                                        <?php else: ?>
                                                            <span class="badge bg-danger ms-2">⛔ Belum Ada Data</span>
                                                        <?php endif; ?>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </div>
                                    </div>
                                <?php endif; ?>



                            </div>

                            
                            <?php if($isAdmin): ?>
                                <div class="col-md-4">
                                    <div class="admin-box">
                                        <div class="admin-box-title">ADMIN CONTROL</div>

                                        <div class="admin-actions">
                                            <?php if($opname->status === 'Pending'): ?>
                                                <form method="POST" action="<?php echo e(route('opname.start', $opname->id)); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <button class="btn-admin btn-start">▶ Start</button>
                                                </form>
                                                <form method="POST" action="<?php echo e(route('opname.cancel', $opname->id)); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <button class="btn-admin btn-cancel">✖ Cancel</button>
                                                </form>
                                                <button class="btn-admin btn-extend" data-bs-toggle="modal"
                                                    data-bs-target="#edit-date-<?php echo e($opname->id); ?>">
                                                    ✏ Edit Tanggal
                                                </button>
                                            <?php endif; ?>

                                            <?php if($opname->status === 'Start'): ?>
                                                <form method="POST" action="<?php echo e(route('opname.pause', $opname->id)); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <button class="btn-admin btn-pause">⏸ Pause</button>
                                                </form>
                                                <button class="btn-admin btn-extend" data-bs-toggle="modal"
                                                    data-bs-target="#extend-<?php echo e($opname->id); ?>">⏩ Extend</button>
                                                <form method="POST" action="<?php echo e(route('opname.finish', $opname->id)); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <button class="btn-admin btn-finish">✔ Finish</button>
                                                </form>
                                                
                                                <?php if($opname->status === 'Start' && !$opname->is_done_get_data): ?>
                                                    
                                                    <button class="btn btn-primary"
                                                        onclick='processGroup(
                                                        <?php echo e($opname->id); ?>,
                                                        <?php echo json_encode($opname->location, 15, 512) ?>,
                                                        <?php echo json_encode(\App\Models\Location::where('location', $opname->location)->pluck('code'), 512) ?>
                                                    )'>
                                                        🚀 Start Ambil Data
                                                    </button>
                                                    
                                                    <button class="btn btn-danger"
                                                        onclick="manualRollback(<?php echo e($opname->id); ?>)">
                                                        ↩ Rollback Data
                                                    </button>
                                                <?php else: ?>
                                                    
                                                    <span class="badge bg-success">✔ Data Lokasi Lengkap</span>
                                                <?php endif; ?>
                                            <?php endif; ?>

                                            <?php if($opname->status === 'Pause'): ?>
                                                <form method="POST" action="<?php echo e(route('opname.start', $opname->id)); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <button class="btn-admin btn-start">▶ Resume</button>
                                                </form>
                                                <button class="btn-admin btn-extend" data-bs-toggle="modal"
                                                    data-bs-target="#extend-<?php echo e($opname->id); ?>">⏩ Extend</button>
                                                <form method="POST" action="<?php echo e(route('opname.finish', $opname->id)); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <button class="btn-admin btn-finish">✔ Finish</button>
                                                </form>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>

                        </div>

                    </div>

                    
                    <div class="modal fade" id="extend-<?php echo e($opname->id); ?>">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content p-3">
                                <h5>⏩ Extend — <?php echo e($opname->location); ?></h5>
                                <form method="POST" action="<?php echo e(route('opname.extend', $opname->id)); ?>"><?php echo csrf_field(); ?>
                                    <div class="row g-2">
                                        <div class="col"><input type="number" name="days" class="form-control"
                                                placeholder="Hari"></div>
                                        <div class="col"><input type="number" name="hours" class="form-control"
                                                placeholder="Jam"></div>
                                        <div class="col"><input type="number" name="minutes" class="form-control"
                                                placeholder="Menit"></div>
                                    </div>
                                    <button class="btn btn-primary w-100 mt-3">Simpan</button>
                                </form>
                            </div>
                        </div>
                    </div>
                    
                    <div class="modal fade" id="edit-date-<?php echo e($opname->id); ?>">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">

                                <div class="modal-header">
                                    <h5 class="modal-title fw-bold">
                                        ✏ Edit Jadwal — <?php echo e($opname->location); ?>

                                    </h5>
                                    <button class="btn-close" data-bs-dismiss="modal"></button>
                                </div>

                                <div class="modal-body">

                                    <div id="editDateSuccess-<?php echo e($opname->id); ?>"
                                        class="alert alert-simple alert-success d-none"></div>

                                    <form id="editDateForm-<?php echo e($opname->id); ?>">
                                        <?php echo csrf_field(); ?>

                                        <div class="mb-2">
                                            <label class="fw-bold">Tanggal Mulai</label>
                                            <input type="date" name="start_at" class="form-control"
                                                value="<?php echo e($opname->start_at?->format('Y-m-d')); ?>" required>
                                        </div>

                                        <div class="mb-2">
                                            <label class="fw-bold">Tanggal Selesai</label>
                                            <input type="date" name="end_at" class="form-control"
                                                value="<?php echo e($opname->end_at?->format('Y-m-d')); ?>" required>
                                        </div>
                                    </form>

                                    <div id="editDateLoader-<?php echo e($opname->id); ?>" class="loader d-none mt-3"></div>

                                </div>

                                <div class="modal-footer">
                                    <button class="btn btn-light" data-bs-dismiss="modal">Batal</button>
                                    <button class="btn btn-primary" onclick="submitEditDate(<?php echo e($opname->id); ?>)">
                                        Simpan
                                    </button>
                                </div>

                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
            <?php else: ?>
                
                <div class="text-center py-4">
                    <h4 class="fw-bold mb-2">Tidak ada jadwal Stock Opname</h4>
                    <?php if($isAdmin): ?>
                        <button class="btn btn-primary btn-lg" data-bs-toggle="modal" data-bs-target="#createModal">
                            ➕ Buat Jadwal
                        </button>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

        </div>

        
        <?php if($isAdmin && $opnames->isEmpty()): ?>
            <div class="modal fade" id="createModal">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">

                        <div class="modal-header">
                            <h5 class="modal-title fw-bold">Buat Jadwal Stock Opname</h5>
                            <button class="btn-close" data-bs-dismiss="modal"></button>
                        </div>

                        <div class="modal-body">

                            <div id="createSuccess" class="alert alert-simple alert-success d-none"></div>

                            <form id="createForm"><?php echo csrf_field(); ?>
                                <label class="fw-bold mb-1">Periode</label>
                                <input type="text" id="periodePicker" name="periode" class="form-control mb-3"
                                    required>

                                <div class="row g-2">
                                    <div class="col">
                                        <label class="fw-bold mb-1">Tanggal Mulai</label>
                                        <input type="date" name="start_at" class="form-control" required>
                                    </div>
                                    <div class="col">
                                        <label class="fw-bold mb-1">Tanggal Selesai</label>
                                        <input type="date" name="end_at" class="form-control" required>
                                    </div>
                                </div>
                            </form>

                            <div id="createLoader" class="loader d-none mt-3"></div>

                        </div>

                        <div class="modal-footer">
                            <button class="btn btn-light" data-bs-dismiss="modal">Batal</button>
                            <button class="btn btn-primary" onclick="submitCreate()">Simpan</button>
                        </div>

                    </div>
                </div>
            </div>
        <?php endif; ?>

        
        <?php if($isAdmin && $opnames->isEmpty()): ?>
            <div class="modal fade" id="extendModal">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">

                        <div class="modal-header">
                            <h5 class="modal-title fw-bold">⏩ Extend Stock Opname</h5>
                            <button class="btn-close" data-bs-dismiss="modal"></button>
                        </div>

                        <div class="modal-body">

                            <div id="extendSuccess" class="alert alert-simple alert-success d-none"></div>

                            <form id="extendForm"><?php echo csrf_field(); ?>
                                <div class="row g-2">
                                    <div class="col">
                                        <label class="fw-bold mb-1">Hari</label>
                                        <input type="number" name="days" class="form-control" value="0"
                                            min="0" placeholder="Hari">
                                    </div>
                                    <div class="col">
                                        <label class="fw-bold mb-1">Jam</label>
                                        <input type="number" name="hours" class="form-control" value="0"
                                            min="0" placeholder="Jam">
                                    </div>
                                    <div class="col">
                                        <label class="fw-bold mb-1">Menit</label>
                                        <input type="number" name="minutes" class="form-control" value="0"
                                            min="0" placeholder="Menit">
                                    </div>
                                </div>
                            </form>

                            <div id="extendLoader" class="loader d-none mt-3"></div>

                        </div>

                        <div class="modal-footer">
                            <button class="btn btn-light" data-bs-dismiss="modal">Batal</button>
                            <button class="btn btn-primary" onclick="submitExtend()">Extend</button>
                        </div>

                    </div>
                </div>
            </div>
        <?php endif; ?>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        // ======================
        // 1. DATE PICKER SETUP
        // ======================
        const now = new Date();
        const minMonth = new Date(now.getFullYear(), now.getMonth(), 1);

        flatpickr("#periodePicker", {
            plugins: [
                new monthSelectPlugin({
                    shorthand: true,
                    dateFormat: "Y-m",
                    altFormat: "F Y"
                })
            ],
            minDate: minMonth,
        });

        // ======================================================
        // 2. MULTI-COUNTDOWN (Per-Opname) — Fixed & Final
        // ======================================================
        document.addEventListener("DOMContentLoaded", () => {

            document.querySelectorAll("[data-countdown]").forEach(el => {

                const end = el.dataset.end;
                const status = el.dataset.status;

                if (!end || status !== 'Start') {
                    el.textContent = "—";
                    return;
                }

                function fmt(sec) {
                    sec = Math.max(0, Math.floor(sec));
                    return `${Math.floor(sec/86400)} hari ${Math.floor(sec%86400/3600)} jam ${Math.floor(sec%3600/60)} menit`;
                }

                function tick() {
                    const now = new Date();
                    const endD = new Date(end.replace(' ', 'T'));

                    if (endD > now) {
                        el.innerText = `⏱ Sisa ${fmt((endD - now)/1000)}`;
                    } else {
                        el.innerText = '✔ Selesai';
                    }
                }
                tick();
                setInterval(tick, 60000);
            });

        });

        // ======================================================
        // 3. SUBMIT CREATE (AJAX)
        // ======================================================
        function submitCreate() {
            const l = document.getElementById('createLoader');
            const s = document.getElementById('createSuccess');

            l.classList.remove('d-none');
            s.classList.add('d-none');

            fetch("<?php echo e(route('opname.store')); ?>", {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('input[name=_token]').value,
                        'Accept': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: new FormData(document.getElementById('createForm'))
                })
                .then(async res => {
                    const type = res.headers.get('content-type');
                    if (type && type.includes('application/json')) return res.json();
                    throw new Error(await res.text());
                })
                .then(res => {
                    l.classList.add('d-none');
                    s.innerHTML = `<span class="greencross">✔</span> ${res.message}`;
                    s.classList.remove('d-none');

                    setTimeout(() => {
                        window.location.href = res.redirect;
                    }, 1200);
                })
                .catch(err => {
                    l.classList.add('d-none');
                    console.error('Server response:', err);
                    alert('Terjadi kesalahan. Cek console.');
                });
        }

        // ======================================================
        // 4. SUBMIT EXTEND (AJAX)
        // ======================================================
        function submitExtend() {
            const openedModal = document.querySelector('.modal.show');
            if (!openedModal) return alert("Modal tidak ditemukan.");

            const form = openedModal.querySelector('form');
            const actionUrl = form.getAttribute('action'); // ⬅️ ambil URL dari route()

            const l = openedModal.querySelector('#extendLoader');
            const s = openedModal.querySelector('#extendSuccess');

            l.classList.remove('d-none');
            s.classList.add('d-none');

            fetch(actionUrl, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Accept': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: new FormData(form)
                })
                .then(res => {
                    if (!res.ok) throw res;
                    return res.json();
                })
                .then(res => {
                    l.classList.add('d-none');
                    s.innerHTML = `
                    <span class="greencross">✔</span> ${res.message}<br>
                    <small class="text-muted">End at baru: ${res.new_end}</small>
                `;
                    s.classList.remove('d-none');

                    // ⏩ langsung kembali ke dashboard
                    setTimeout(() => {
                        window.location.href = "<?php echo e(route('dashboard')); ?>";
                    }, 1200);
                })
                .catch(async err => {
                    l.classList.add('d-none');
                    console.error(await err.text());
                    alert('Gagal memperpanjang waktu stock opname.');
                });
        }

        let cancelProcess = false;
        let controller = null;

        // ===================================================
        // 🚀 PROSES GROUP (STEP 1)
        // ===================================================
        async function processGroup(id, group, locations) {

            if (!Array.isArray(locations) || locations.length === 0) {
                return Swal.fire({
                    icon: "warning",
                    title: "Tidak Ada Lokasi",
                    text: `Lokasi tidak ditemukan untuk group ${group}.`
                });
            }

            cancelProcess = false;
            let errors = [];

            // 🔥 START MESSAGE
            Swal.fire({
                title: `🚀 Mulai Ambil Data — ${group}`,
                html: `Memulai proses...`,
                allowEscapeKey: false,
                allowOutsideClick: false,
                showConfirmButton: false,
                footer: `<button id="cancelBtn" class="btn btn-danger w-100 mt-3">❌ Batalkan</button>`,
                didOpen: () => {
                    Swal.showLoading();
                    Swal.getFooter()
                        ?.querySelector("#cancelBtn")
                        ?.addEventListener("click", () => cancelProcess = true);
                }
            });

            for (let i = 0; i < locations.length; i++) {

                if (cancelProcess) return handleCancel(id);

                const loc = locations[i];

                Swal.fire({
                    title: `📍 Memproses ${loc}`,
                    html: `
                Progress: ${i + 1} / ${locations.length}<br>
                <small class="text-muted">Klik cancel untuk menghentikan</small>
            `,
                    allowEscapeKey: false,
                    allowOutsideClick: false,
                    showConfirmButton: false,
                    footer: `<button id="cancelBtn2" class="btn btn-danger w-100">❌ Batalkan</button>`,
                    didOpen: () => {
                        Swal.showLoading();
                        Swal.getFooter()
                            ?.querySelector("#cancelBtn2")
                            ?.addEventListener("click", () => cancelProcess = true);
                    }
                });

                try {
                    controller = new AbortController();

                    const url = `<?php echo e(route('opname.process.location', ['id' => '__ID__', 'loc' => '__LOC__'])); ?>`
                        .replace('__ID__', id)
                        .replace('__LOC__', loc);

                    const res = await fetch(url, {
                        method: "POST",
                        signal: controller.signal,
                        headers: {
                            "X-CSRF-TOKEN": document.querySelector("meta[name='csrf-token']").content,
                            "Accept": "application/json"
                        }
                    });

                    if (cancelProcess) return handleCancel(id);

                    if (!res.ok) {
                        errors.push(loc);
                        continue;
                    }

                    const json = await res.json();
                    if (!json || json.status !== "success") {
                        errors.push(loc);
                        continue;
                    }

                } catch (err) {
                    if (err.name !== "AbortError") errors.push(loc);
                    if (cancelProcess) return handleCancel(id);
                }
            }

            // ===================================================
            // 🎉 FINISH (TANPA ROLLBACK)
            // ===================================================
            Swal.fire({
                icon: "success",
                title: "🎉 Proses Selesai",
                html: errors.length ?
                    `Beberapa lokasi gagal:<br><b>${errors.join(", ")}</b>` : `Semua lokasi berhasil diproses.`,
                confirmButtonText: "OK",
                footer: `
            <button onclick="manualRollback(${id})"
                class="btn btn-outline-danger w-100">
                ↩ Rollback Manual
            </button>
        `,
                allowOutsideClick: false,
            }).then(() => location.reload());
        }


        // ===================================================
        // 🛑 CANCEL USER → ROLLBACK
        // ===================================================
        async function handleCancel(id) {

            if (controller) controller.abort();

            Swal.fire({
                icon: "warning",
                title: "⛔ Dibatalkan Pengguna",
                html: "Menjalankan rollback...",
                allowOutsideClick: false,
                allowEscapeKey: false,
                showConfirmButton: false,
                didOpen: () => Swal.showLoading()
            });

            await fetch(`<?php echo e(route('opname.rollback', ['id' => '__ID__'])); ?>`
                .replace('__ID__', id), {
                    method: "POST",
                    headers: {
                        "X-CSRF-TOKEN": document.querySelector("meta[name='csrf-token']").content
                    }
                });

            Swal.fire({
                icon: "info",
                title: "↩ Rollback Selesai",
                confirmButtonText: "OK",
                allowOutsideClick: false
            }).then(() => location.reload());
        }


        // ===================================================
        // 🔥 MANUAL ROLLBACK
        // ===================================================
        async function manualRollback(id) {

            const res = await Swal.fire({
                icon: "question",
                title: "Rollback Data Ini?",
                text: "Semua data untuk schedule ini akan dihapus.",
                showCancelButton: true,
                confirmButtonText: "Ya, rollback",
                cancelButtonText: "Batal",
                confirmButtonColor: "#dc3545"
            });

            if (!res.isConfirmed) return;

            Swal.fire({
                allowOutsideClick: false,
                showConfirmButton: false,
                html: "Rollback..."
            });

            await fetch(`<?php echo e(route('opname.rollback', ['id' => '__ID__'])); ?>`
                .replace('__ID__', id), {
                    method: "POST",
                    headers: {
                        "X-CSRF-TOKEN": document.querySelector("meta[name='csrf-token']").content
                    }
                });

            Swal.fire({
                icon: "success",
                title: "Rollback Selesai",
                timer: 1400,
                showConfirmButton: false
            }).then(() => location.reload());
        }
    </script>

    <script>
        function submitEditDate(id) {

            const form = document.getElementById(`editDateForm-${id}`);
            const loader = document.getElementById(`editDateLoader-${id}`);
            const success = document.getElementById(`editDateSuccess-${id}`);

            loader.classList.remove('d-none');
            success.classList.add('d-none');

            fetch(`<?php echo e(route('opname.update.date', ['id' => '__ID__'])); ?>`
                    .replace('__ID__', id), {
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': document
                                .querySelector("meta[name='csrf-token']")
                                .content,
                            'Accept': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        },
                        body: new FormData(form)
                    })
                .then(res => {
                    if (!res.ok) throw res;
                    return res.json();
                })
                .then(res => {
                    loader.classList.add('d-none');
                    success.innerHTML = `
                <span class="greencross">✔</span>
                ${res.message}
            `;
                    success.classList.remove('d-none');

                    // 🔄 refresh dashboard
                    setTimeout(() => location.reload(), 1200);
                })
                .catch(async err => {
                    loader.classList.add('d-none');
                    console.error(await err.text());
                    alert('Gagal memperbarui tanggal.');
                });
        }
    </script>
    <?php if(session('error') || session('success')): ?>
        <script>
            document.addEventListener('DOMContentLoaded', () => {

                const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-end',
                    showConfirmButton: false,
                    timer: 4500,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                });

                <?php if(session('error')): ?>
                    Toast.fire({
                        icon: 'warning',
                        title: `<?php echo session('error'); ?>`
                    });
                <?php endif; ?>

                <?php if(session('success')): ?>
                    Toast.fire({
                        icon: 'success',
                        title: `<?php echo session('success'); ?>`
                    });
                <?php endif; ?>
            });
        </script>
    <?php endif; ?>
    <script>
        document.addEventListener('DOMContentLoaded', () => {

            document.querySelectorAll('.location-export').forEach(card => {

                card.addEventListener('click', async () => {

                    const location = card.dataset.location;
                    const periode = card.dataset.periode;

                    Swal.fire({
                        title: '📤 Export Excel',
                        text: `Mengambil data ${location} (${periode})`,
                        allowOutsideClick: false,
                        didOpen: () => Swal.showLoading()
                    });

                    try {
                        const res = await fetch(
                            `<?php echo e(route('opname.export.location')); ?>?location=${location}&periode=${periode}`, {
                                headers: {
                                    'Accept': 'application/json'
                                }
                            }
                        );

                        if (!res.ok) throw new Error(await res.text());

                        const json = await res.json();

                        if (!json.data || json.data.length === 0) {
                            Swal.fire('Kosong', 'Tidak ada data untuk lokasi ini', 'info');
                            return;
                        }

                        const ws = XLSX.utils.json_to_sheet(json.data);

                        /* =========================
                           1. SET LEBAR KOLOM
                           ========================= */
                        ws['!cols'] = [{
                                wch: 5
                            }, // No
                            {
                                wch: 16
                            }, // Storage Location
                            {
                                wch: 18
                            }, // Code
                            {
                                wch: 76
                            }, // Material Description (LEBAR)
                            {
                                wch: 12
                            }, // Actual
                            {
                                wch: 18
                            }, // Base Unit of Measure
                            {
                                wch: 35
                            }, // Note (LEBAR)
                        ];

                        /* =========================
                           2. SET TINGGI BARIS
                           ========================= */
                        ws['!rows'] = Array(json.data.length + 1).fill({
                            hpt: 25
                        });

                        /* =========================
                           3. WRAP TEXT UNTUK NOTE
                           ========================= */
                        function enableWrap(ws, colIndex) {
                            const range = XLSX.utils.decode_range(ws['!ref']);

                            for (let r = 1; r <= range.e.r; r++) {
                                const cellAddr = XLSX.utils.encode_cell({
                                    r,
                                    c: colIndex
                                });
                                if (!ws[cellAddr]) continue;

                                ws[cellAddr].s = {
                                    alignment: {
                                        wrapText: true,
                                        vertical: "top"
                                    }
                                };
                            }
                        }

                        // Kolom NOTE = index ke-6 (0-based)
                        enableWrap(ws, 6);

                        /* =========================
                           4. BUAT & DOWNLOAD FILE
                           ========================= */
                        const wb = XLSX.utils.book_new();
                        XLSX.utils.book_append_sheet(wb, ws, 'Stock Opname');
                        XLSX.writeFile(wb, json.filename);


                        Swal.fire({
                            icon: 'success',
                            title: 'Export Berhasil',
                            timer: 1200,
                            showConfirmButton: false
                        });

                    } catch (err) {
                        console.error(err);
                        Swal.fire('Error', 'Gagal export data', 'error');
                    }
                });

            });

        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Lenovo\OneDrive\Documents\Kerjaan\stockopname\resources\views/dashboard/index.blade.php ENDPATH**/ ?>