@push('styles')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <style>
        /* ===== HEADER ===== */
        .page-title {
            font-size: 1.25rem;
            font-weight: 600;
        }

        .page-subtitle {
            font-size: .8rem;
            color: #6c757d;
        }

        /* ===== CONTEXT CARD ===== */
        .context-card {
            background: #ffffff;
            border-radius: 1rem;
            padding: 1rem 1.25rem;
            box-shadow: 0 6px 24px rgba(0, 0, 0, .08);
        }

        /* ===== CONTROL PANEL ===== */
        .control-panel {
            background: #ffffff;
            border-radius: 1rem;
            padding: 1.25rem 1.25rem;
            box-shadow: 0 6px 28px rgba(0, 0, 0, .1);
        }

        .control-panel label {
            font-size: .7rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: .08em;
            color: #6c757d;
            margin-bottom: .25rem;
        }

        /* ===== SELECT2 CORE ===== */
        .select2-container {
            width: 100% !important;
        }

        .select2-container--default .select2-selection--single {
            height: 40px;
            border-radius: .75rem;
            border: 1px solid #ced4da;
            padding: 6px 10px;
            font-size: .85rem;
            transition: all .2s ease;
            background-color: #ffffff;
        }

        /* Focus state */
        .select2-container--default.select2-container--focus .select2-selection--single {
            border-color: #0d6efd;
            box-shadow: 0 0 0 .15rem rgba(13, 110, 253, .15);
        }

        .select2-selection__rendered {
            line-height: 26px !important;
            padding-left: 0 !important;
        }

        .select2-selection__arrow {
            height: 38px !important;
        }

        /* ===== SEARCH BOX ===== */
        .select2-container--default .select2-search--dropdown .select2-search__field {
            border-radius: .6rem;
            border: 1px solid #ced4da;
            padding: .4rem .6rem;
            font-size: .85rem;
            transition: all .2s ease;
        }

        .select2-search__field:focus {
            border-color: #0d6efd;
            box-shadow: 0 0 0 .15rem rgba(13, 110, 253, .15);
            outline: none;
        }

        /* ===== DROPDOWN OPTION ===== */
        .select2-container--default .select2-results__option {
            font-size: .85rem;
            padding: .45rem .6rem;
        }

        .select2-container--default .select2-results__option--highlighted {
            background-color: #f1f5ff;
            color: #0d6efd;
        }

        /* ===== TABLE ===== */
        .scroll-table {
            max-height: 65vh;
            overflow-y: auto;
        }

        .scroll-table thead th {
            position: sticky;
            top: 0;
            background: #f4f6f9;
            z-index: 2;
            font-size: .7rem;
            text-transform: uppercase;
            letter-spacing: .08em;
        }

        .card {
            border-radius: 1rem;
            border: none;
            box-shadow: 0 6px 26px rgba(0, 0, 0, .08);
        }

        .card-header {
            font-size: .75rem;
            font-weight: 700;
            letter-spacing: .08em;
        }

        .table td {
            font-size: .85rem;
            vertical-align: middle;
        }

        /* ===== IMPACT ===== */
        .impact-card {
            background: #ffffff;
            border-radius: 1rem;
            padding: 1.25rem 1.5rem;
            box-shadow: 0 6px 28px rgba(0, 0, 0, .1);
        }

        .impact-label {
            font-size: .7rem;
            letter-spacing: .1em;
            text-transform: uppercase;
            color: #6c757d;
        }

        .impact-value {
            font-size: 2rem;
            font-weight: 700;
        }

        /* ===== BUTTON ===== */
        .btn-primary {
            border-radius: .7rem;
            font-size: .85rem;
            padding: .6rem 1.1rem;
        }

        .btn-outline-secondary {
            border-radius: .7rem;
            font-size: .85rem;
        }
    </style>
@endpush

@extends('layouts.app')

@section('content')
    <div class="container-fluid px-4 my-4">

        @php
            $fmt = fn($v) => fmod($v, 1) == 0 ? number_format($v, 0) : number_format($v, 4);

            $receiptTotal = $receiptItems->sum('total_cost');
            $shipmentTotal = $shipmentItems->sum('total_cost');
            $grandTotal = $receiptTotal + $shipmentTotal;

            $grandClass = $grandTotal > 0 ? 'text-success' : ($grandTotal < 0 ? 'text-danger' : 'text-muted');
        @endphp

        {{-- ===== HEADER ===== --}}
        <div class="mb-3">
            <div class="page-title">Inventory Receipt / Shipment</div>
            <div class="page-subtitle">{{ $location }} · {{ $periode }}</div>
        </div>

        {{-- ===== CONTEXT ===== --}}
        <div class="context-card mb-4">
            <div class="row text-center">
                <div class="col">
                    <div class="impact-label">Receipt Items</div>
                    <div class="fw-semibold">{{ $receiptItems->count() }}</div>
                </div>
                <div class="col">
                    <div class="impact-label">Shipment Items</div>
                    <div class="fw-semibold">{{ $shipmentItems->count() }}</div>
                </div>
                <div class="col">
                    <div class="impact-label">Posting Date</div>
                    <div class="fw-semibold">
                        {{ \Carbon\Carbon::parse($req->requested_at)->format('d M Y') }}
                    </div>
                </div>
            </div>
        </div>

        {{-- ===== CONTROL PANEL ===== --}}
        <div class="control-panel mb-4">
            <div class="row g-3 align-items-end">

                <div class="col-md-4">
                    <label>Gen. Business</label>
                    <select id="gen_bus_code" class="form-select select2">
                        <option value="">Select Gen. Business</option>
                        @foreach ($genBusList as $gb)
                            <option value="{{ $gb->code }}">
                                {{ $gb->code }} — {{ $gb->description }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-4">
                    <label>Department</label>
                    <select id="department_code" class="form-select select2">
                        <option value="">Select Department</option>
                        @foreach ($departmentList as $dept)
                            <option value="{{ $dept->code }}">
                                {{ $dept->code }} — {{ $dept->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-4 d-flex gap-2">
                    <button class="btn btn-outline-primary w-100" onclick="processInventory()">
                        🚀 Process Inventory
                    </button>
                    <a href="{{ url()->previous() }}" class="btn btn-outline-secondary ">
                        Back
                    </a>
                </div>

            </div>
        </div>

        {{-- ===== TABLES ===== --}}
        <div class="row g-4">

            {{-- RECEIPT --}}
            <div class="col-xl-6">
                <div class="card h-100">
                    <div class="card-header bg-success text-white">INVENTORY RECEIPT</div>
                    <div class="card-body p-0">
                        <div class="table-responsive scroll-table">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th>Item</th>
                                        <th>Description</th>
                                        <th>UOM</th>
                                        <th class="text-end">Blind</th>
                                        <th class="text-end">+Var</th>
                                        <th class="text-end">Cost</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($receiptItems as $row)
                                        <tr>
                                            <td>{{ $row->item_no }}</td>
                                            <td>{{ $row->item_description }}</td>
                                            <td>{{ $row->uom }}</td>
                                            <td class="text-end">{{ $fmt($row->blind_count) }}</td>
                                            <td class="text-end text-success">+{{ $fmt($row->variance) }}</td>
                                            <td class="text-end">{{ number_format($row->total_cost, 2) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            {{-- SHIPMENT --}}
            <div class="col-xl-6">
                <div class="card h-100">
                    <div class="card-header bg-danger text-white">INVENTORY SHIPMENT</div>
                    <div class="card-body p-0">
                        <div class="table-responsive scroll-table">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th>Item</th>
                                        <th>Description</th>
                                        <th>UOM</th>
                                        <th class="text-end">Blind</th>
                                        <th class="text-end">-Var</th>
                                        <th class="text-end">Cost</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($shipmentItems as $row)
                                        <tr>
                                            <td>{{ $row->item_no }}</td>
                                            <td>{{ $row->item_description }}</td>
                                            <td>{{ $row->uom }}</td>
                                            <td class="text-end">{{ $fmt($row->blind_count) }}</td>
                                            <td class="text-end text-danger">{{ $fmt($row->variance) }}</td>
                                            <td class="text-end">{{ number_format($row->total_cost, 2) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        {{-- ===== IMPACT ===== --}}
        <div class="mt-4">
            <div class="impact-card d-flex justify-content-between align-items-center">
                <div>
                    <div class="impact-label">Inventory Adjustment Impact</div>
                    <div class="fw-semibold">Grand Total</div>
                </div>
                <div class="impact-value {{ $grandClass }}">
                    {{ number_format($grandTotal, 2) }}
                </div>
            </div>
        </div>

    </div>

    @push('scripts')
        <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
        <script>
            $(document).ready(function() {
                $('.select2').select2({
                    width: '100%',
                    placeholder: 'Type to search…',
                    allowClear: true
                });
            });
        </script>
        <script>
            function processInventory() {

                const genBusCode = document.getElementById('gen_bus_code').value;
                const departmentCode = document.getElementById('department_code').value;

                if (!genBusCode) {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Gen. Business belum dipilih',
                        text: 'Silakan pilih Gen. Business sebelum memproses inventory'
                    });
                    return;
                }

                if (!departmentCode) {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Department belum dipilih',
                        text: 'Silakan pilih Department sebelum memproses inventory'
                    });
                    return;
                }

                const location = @json($location);
                const postingDate = @json(\Carbon\Carbon::parse($req->requested_at)->format('Y-m-d'));

                const receiptLines = @json(
                    $receiptItems->map(fn($i) => [
                                'item_no' => $i->item_no,
                                'quantity' => (float) $i->variance,
                            ])->values());

                const shipmentLines = @json(
                    $shipmentItems->map(fn($i) => [
                                'item_no' => $i->item_no,
                                'quantity' => abs((float) $i->variance),
                            ])->values());

                if (receiptLines.length === 0 && shipmentLines.length === 0) {
                    Swal.fire({
                        icon: 'info',
                        title: 'Tidak ada data',
                        text: 'Tidak ada Inventory Receipt maupun Shipment untuk diproses'
                    });
                    return;
                }

                const businessUnit = location.split('.')[0];

                const payload = {
                    location_code: location,
                    posting_date: postingDate,
                    gen_bus_code: genBusCode,
                    business_unit: businessUnit,
                    department_code: departmentCode,

                    receipt: receiptLines.length ? {
                        no_series: `IR.${businessUnit}`,
                        lines: receiptLines
                    } : null,

                    shipment: shipmentLines.length ? {
                        no_series: `IS.${businessUnit}`,
                        lines: shipmentLines
                    } : null
                };

                Swal.fire({
                    icon: 'question',
                    title: 'Proses Inventory?',
                    html: `
            <div>Location: <b>${location}</b></div>
            <div>Business Unit: <b>${businessUnit}</b></div>
            <div>Department: <b>${departmentCode}</b></div>
            <div>Gen. Business: <b>${genBusCode}</b></div>
            <div>Receipt: <b>${receiptLines.length}</b> item</div>
            <div>Shipment: <b>${shipmentLines.length}</b> item</div>
        `,
                    showCancelButton: true,
                    confirmButtonText: 'Ya, proses',
                    cancelButtonText: 'Batal'
                }).then(result => {

                    if (!result.isConfirmed) return;

                    Swal.fire({
                        title: 'Memproses...',
                        allowOutsideClick: false,
                        didOpen: () => Swal.showLoading()
                    });

                    fetch("{{ route('item-request.inventory.process', $req->id) }}", {
                            method: "POST",
                            headers: {
                                "X-CSRF-TOKEN": document.querySelector("meta[name='csrf-token']").content,
                                "Content-Type": "application/json",
                                "Accept": "application/json"
                            },
                            body: JSON.stringify(payload)
                        })
                        .then(res => res.json())
                        .then(json => {
                            if (json.status !== 'success') {
                                throw new Error(json.message || 'Process failed');
                            }

                            Swal.fire({
                                icon: 'success',
                                title: 'Berhasil',
                                text: 'Inventory Receipt / Shipment berhasil diproses'
                            }).then(() => {
                                window.location.href = "{{ route('approvals.show', $req->id) }}";
                            });
                        })
                        .catch(err => {
                            Swal.fire({
                                icon: 'error',
                                title: 'Gagal',
                                text: err.message
                            });
                        });
                });
            }
        </script>
    @endpush
@endsection
