@extends('layouts.app')

@push('styles')
    <style>
        .preview-blur {
            filter: blur(3px);
            opacity: .75;
            pointer-events: none;
        }

        .preview-overlay {
            position: absolute;
            inset: 0;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            color: var(--bs-secondary);
            background: rgba(255, 255, 255, .25);
            /* TIPIS, BUKAN BETON */
        }

        .preview-overlay:hover {
            background: rgba(255, 255, 255, .35);
            color: var(--bs-secondary);
        }


        .hero {
            background: linear-gradient(135deg, #0d6efd 0%, #20c997 100%);
            color: #fff;
            border-radius: 1rem
        }

        .card-rounded {
            border-radius: 1rem
        }

        .badge-status {
            font-weight: 600
        }

        .sig-box {
            min-height: 100px;
            border: 1px dashed #d0d7de;
            border-radius: .75rem;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #fff
        }

        .sig-box img {
            max-height: 90px;
            max-width: 100%;
            object-fit: contain
        }

        @media print {
            .d-print-none {
                display: none !important
            }

            .hero {
                background: #fff;
                color: #000
            }

            .card {
                box-shadow: none !important
            }
        }
    </style>
@endpush

@section('content')
    @php use Illuminate\Support\Str; @endphp

    <div class="container my-4">

        {{-- ================= ALERT ================= --}}
        @if (session('success'))
            <div class="alert alert-success d-print-none">
                <i class="fa fa-check-circle me-2"></i>{{ session('success') }}
            </div>
        @endif

        {{-- ================= HERO ================= --}}
        <div class="hero p-4 mb-4 shadow-sm d-print-none">
            <div class="d-flex justify-content-between align-items-center gap-3">
                <div>
                    @php
                        $statusClass = match ($req->status) {
                            'Draft' => 'bg-secondary',
                            'InReview' => 'bg-warning text-dark',
                            'Approved' => 'bg-success',
                            'Rejected' => 'bg-danger',
                            default => 'bg-secondary',
                        };
                    @endphp
                    <div class="d-flex align-items-center gap-2 flex-wrap">
                        <h2 class="mb-0">
                            Request Opname
                            <span class="opacity-75">#{{ $req->id }}</span>
                        </h2>

                        <span class="badge badge-status {{ $statusClass }}">
                            {{ $req->status }}
                        </span>
                    </div>




                    <div class="small opacity-75 mt-2">
                        Flow: {{ optional($req->flow)->name ?? '—' }}
                        · Created:
                        {{ $req->created_at?->timezone('Asia/Singapore')->format('Y-m-d H:i') }}
                    </div>
                </div>

                {{-- ========= ADMIN / USER ACTION ========= --}}
                <div class="d-flex gap-2">
                    <a href="{{ route('approvals.mine') }}" class="btn btn-light d-print-none">
                        <i class="fa fa-inbox me-1"></i> My Forms
                    </a>

                    @php
                        $me = auth()->user();
                        $isOwner = $me && (int) $me->id === (int) $req->requester_id;
                        $isAdmin = optional($me->role)->code === 'ADMIN';
                        $canEdit = in_array($req->status, ['Draft', 'Rejected', 'InReview']) && ($isOwner || $isAdmin);
                        $upbc = $req->up_to_bc ?? 'no';
                    @endphp
                    {{-- =====================================================
                        🚀 STEP 2 BUTTONS (ADMIN ONLY)
                    ===================================================== --}}
                    @if ($isAdmin && isset($step2status) && $step2status['opname'] )
                        {{-- jika BELUM lengkap --}}
                        @if (!$step2status['is_full'])
                            <button class="btn btn-primary d-print-none"
                                onclick="processStep2Single({{ $step2status['opname']->id }}, '{{ $req->location }}')">
                                🚀 Step 2: Ambil Data
                            </button>
                        @else
                            @if ($req->status === 'Approved')
                                <button class="btn btn-light d-print-none"
                                    onclick="location.href='{{ route('item-after.process', $req->id) }}'">
                                    <i class="fa-solid fa-bars-progress"></i> Item Adjustment
                                </button>
                            @endif
                        @endif

                        {{-- tombol inventory receipt / shipment muncul jika sudah approved --}}
                        @if ($req->status === 'Approved')
                            <button type="button" class="btn btn-light d-print-none"
                                onclick="window.location='{{ route('opname.inventory.receipt.ship', $req->id) }}'">
                                <i class="fa fa-right-left me-1"></i>
                                Inventory Receipt / Shipment
                            </button>
                        @endif
                        {{-- tombol rollback selalu muncul untuk admin --}}
                        <button class="btn btn-outline-danger d-print-none"
                            onclick="manualRollbackStep2({{ $step2status['opname']->id }})">
                            <i class="fa fa-right-left me-1"></i> Rollback Data
                        </button>
                    @endif

                    {{-- EDIT DRAFT --}}
                    @if ($canEdit)
                        <a href="{{ route('approvals.edit', $req->id) }}" class="btn btn-outline-light d-print-none">
                            <i class="fa fa-pen me-1"></i> Edit Draft
                        </a>
                    @endif

                </div>

            </div>
        </div>

        <div class="row g-4">

            {{-- ================= LEFT ================= --}}
            <div class="col-lg-8">

                {{-- ================= ITEM USER INPUTS ================= --}}
                <div class="card card-rounded shadow-sm mb-4">
                    <div class="card-header bg-light fw-semibold d-flex justify-content-between align-items-center">
                        <span><i class="fa fa-table me-2"></i> Opname Items</span>
                        <span class="badge bg-secondary">{{ $itemCount }} items</span>
                    </div>

                    <div class="card-body position-relative p-0">

                        @if ($itemCount === 0)
                            <div class="text-muted text-center py-4">
                                <i class="fa fa-box-open fa-2x mb-2"></i>
                                <div>Belum ada data opname</div>
                            </div>
                        @else
                            {{-- PREVIEW (DI-BLUR) --}}
                            <div class="table-responsive preview-blur">
                                <table class="table table-sm mb-0">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Storage</th>
                                            <th>Code</th>
                                            <th>Description</th>
                                            <th class="text-end">Actual</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($itemPreview as $row)
                                            <tr>
                                                <td>{{ $row->storage_location }}</td>
                                                <td>{{ $row->code }}</td>
                                                <td>{{ $row->material_description }}</td>
                                                <td class="text-end">{{ $row->actual }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                            {{-- OVERLAY VIEW DATA --}}
                            <a href="{{ route('approvals.items.opname', $req->id) }}"
                                class="preview-overlay text-decoration-none">
                                <i class="fa fa-eye fa-lg mb-1"></i>
                                <div class="fw-semibold">View Data</div>
                                <small>{{ $itemCount }} items</small>
                            </a>
                        @endif
                    </div>
                </div>




                {{-- ================= COMMENTS ================= --}}
                <h5>Comments</h5>
                <div class="card mb-3">
                    <div class="card-body" style="max-height:300px;overflow:auto">
                        @forelse($req->comments()->with('user')->latest()->get() as $c)
                            <div class="mb-2 p-2 border rounded">
                                <strong>{{ $c->user->name ?? 'Unknown' }}</strong>
                                <small class="text-muted">{{ $c->created_at->diffForHumans() }}</small>
                                <div>{{ $c->body }}</div>
                            </div>
                        @empty
                            <div class="text-muted">No comments yet.</div>
                        @endforelse
                    </div>
                </div>

                <form method="POST" action="{{ route('approvals.comments.store', $req->id) }}">
                    @csrf
                    <div class="input-group">
                        <input type="text" name="body" class="form-control" placeholder="Write a comment..." required>
                        <button class="btn btn-primary">Send</button>
                    </div>
                </form>

            </div>

            {{-- ================= RIGHT ================= --}}
            <div class="col-lg-4">

                {{-- ================= DETAILS ================= --}}
                <div class="card card-rounded shadow-sm mb-4">
                    <div class="card-header bg-light fw-semibold">
                        <i class="fa fa-circle-info me-2"></i>Details
                    </div>
                    <div class="card-body">
                        <dl class="row mb-0">
                            <dt class="col-5">ID</dt>
                            <dd class="col-7">{{ $req->id }}</dd>

                            <dt class="col-5">Requester</dt>
                            <dd class="col-7">{{ optional($req->requester)->name ?? '—' }}</dd>

                            <dt class="col-5">Company</dt>
                            <dd class="col-7">{{ optional($req->company)->code ?? '—' }}</dd>

                            <dt class="col-5">Location</dt>
                            <dd class="col-7">{{ $req->location ?: '—' }}</dd>

                            <dt class="col-5">Posting Date</dt>
                            <dd class="col-7">{{ $req->posting_date?->format('Y-m-d') ?? '—' }}</dd>

                            <dt class="col-5">Remarks</dt>
                            <dd class="col-7">{{ $req->remarks ?: '—' }}</dd>
                        </dl>
                    </div>
                </div>

                {{-- ================= SUBMIT (AS IS FROM OLD VIEW) ================= --}}
                @if (in_array($status, ['Draft', 'Rejected', 'Cancelled']))
                    <div class="card card-rounded shadow-sm d-print-none mb-4">
                        <div class="card-header bg-light fw-semibold">
                            <i class="fa fa-paper-plane me-2"></i>Submit
                        </div>
                        <div class="card-body">
                            <form method="POST" action="{{ route('approvals.web.submit', $req->id) }}">
                                @csrf
                                <button class="btn btn-primary w-100">
                                    <i class="fa fa-paper-plane me-1"></i>
                                    Submit for approval
                                </button>
                            </form>
                        </div>
                    </div>
                @endif

                {{-- ================= APPROVAL ACTIONS (ADMIN / APPROVER) ================= --}}
                @php
                    $me = auth()->user();

                    $statusUpper = strtoupper(trim((string) $req->status));
                    $isOwner = $me && (int) $me->id === (int) $req->requester_id;
                    $isAdmin = optional($me->role)->code === 'ADMIN';

                    $canApproveReject = $statusUpper === 'INREVIEW' && $isAdmin;
                    $canCancel = $statusUpper === 'INREVIEW' && ($isOwner || $isAdmin);
                @endphp

                @if ($canApproveReject)
                    <div class="card card-rounded shadow-sm d-print-none mb-4">
                        <div class="card-header bg-light fw-semibold">
                            <i class="fa fa-gavel me-2"></i>Approval Actions
                        </div>
                        <div class="card-body">

                            {{-- APPROVE --}}
                            <form class="mb-2" method="POST" action="{{ route('approvals.web.approve', $req->id) }}">
                                @csrf
                                <div class="mb-2">
                                    <input type="text" class="form-control" name="comment"
                                        placeholder="Comment (optional)">
                                </div>
                                <button class="btn btn-success w-100">
                                    <i class="fa fa-thumbs-up me-1"></i> Approve
                                </button>
                            </form>

                            {{-- REJECT --}}
                            <form method="POST" action="{{ route('approvals.web.reject', $req->id) }}">
                                @csrf
                                <div class="mb-2">
                                    <input type="text" class="form-control" name="comment"
                                        placeholder="Comment (optional)">
                                </div>
                                <button class="btn btn-danger w-100">
                                    <i class="fa fa-thumbs-down me-1"></i> Reject
                                </button>
                            </form>

                        </div>
                    </div>
                @endif

                {{-- ================= CANCEL (OWNER / ADMIN) ================= --}}
                @if ($canCancel)
                    <div class="card card-rounded shadow-sm d-print-none mb-4">
                        <div class="card-header bg-light fw-semibold">
                            <i class="fa fa-ban me-2"></i>Cancel Request
                        </div>
                        <div class="card-body">
                            <form method="POST" action="{{ route('approvals.web.cancel', $req->id) }}"
                                onsubmit="return confirm('Cancel this request? This will stop the approval flow.');">
                                @csrf
                                <div class="mb-2">
                                    <input type="text" class="form-control" name="comment"
                                        placeholder="Reason (optional)">
                                </div>
                                <button class="btn btn-outline-danger w-100">
                                    <i class="fa fa-ban me-1"></i> Cancel Request
                                </button>
                            </form>
                        </div>
                    </div>
                @endif


                {{-- ================= SIGN OFF ================= --}}
                <div class="card card-rounded shadow-sm mt-4">
                    <div class="card-header bg-light fw-semibold d-flex justify-content-between align-items-center">
                        <span><i class="fa fa-signature me-2"></i>Sign-off</span>
                        <a href="{{ route('approvals.print', $req->id) }}" target="_blank"
                            class="btn btn-sm btn-outline-secondary d-print-none">
                            <i class="fa fa-print me-1"></i> Print
                        </a>
                    </div>
                    <div class="card-body">
                        @php
                            $steps = optional($req->flow)->steps ?? collect();
                            $byStep = (optional($req->instance)->actions ?? collect())->groupBy('step_no');
                        @endphp

                        @forelse($steps as $st)
                            @php
                                $done = ($byStep[$st->step_no] ?? collect())
                                    ->where('action', 'Approve')
                                    ->sortByDesc('acted_at')
                                    ->first();

                                $approver = $st->approverUser ?: optional($st->approverRole);
                                $sigPath =
                                    $done?->actor?->signature_path ?? ($st->approverUser?->signature_path ?? null);

                                $base = request()->getSchemeAndHttpHost() . request()->getBaseUrl();
                                $imgUrl = null;

                                if ($sigPath) {
                                    $rel = ltrim($sigPath, '/');
                                    $rel = str_starts_with($rel, 'storage/') ? $rel : "storage/{$rel}";
                                    if (file_exists(public_path($rel))) {
                                        $imgUrl = "{$base}/public/{$rel}";
                                    }
                                }

                                if (!$imgUrl) {
                                    $uid = $done?->actor?->id ?? $st->approverUser?->id;
                                    if ($uid) {
                                        $rel = "storage/signatures/{$uid}.png";
                                        if (file_exists(public_path($rel))) {
                                            $imgUrl = "{$base}/public/{$rel}";
                                        }
                                    }
                                }
                            @endphp

                            <div class="mb-3">
                                <div class="small text-muted">Step {{ $st->step_no }}</div>
                                <div class="d-flex align-items-center gap-3">
                                    <div class="sig-box flex-grow-1 text-center">
                                        @if ($imgUrl)
                                            <img src="{{ $imgUrl }}?v={{ filemtime(public_path(str_replace($base . '/public/', '', $imgUrl))) }}"
                                                alt="signature">
                                        @else
                                            <span class="text-muted">— signature —</span>
                                        @endif
                                    </div>
                                    <div class="small">
                                        <div class="fw-semibold">
                                            {{ $done?->actor?->name ?? ($st->approverUser?->name ?? ($st->approverRole?->code ?? '')) }}
                                        </div>
                                        <div class="text-muted">
                                            @if ($done)
                                                Approved at
                                                {{ \Illuminate\Support\Carbon::parse($done->acted_at)->timezone('Asia/Singapore')->format('Y-m-d H:i') }}
                                            @else
                                                Pending
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div class="text-muted">No steps configured.</div>
                        @endforelse
                    </div>
                </div>


            </div>
        </div>
    </div>

    <script>
        let cancelStep2 = false;
        let controllerStep2 = null;

        // ===================================================
        // 🚀 STEP 2 — SINGLE LOCATION (BENAR)
        // ===================================================
        async function processStep2Single(opnameId, locationCode) {

            cancelStep2 = false;

            Swal.fire({
                title: `🚀 Step 2`,
                html: `Lokasi: <b>${locationCode}</b>`,
                allowOutsideClick: false,
                showConfirmButton: false,
                footer: `<button id="cancelStep2Btn" class="btn btn-danger w-100 mt-3">❌ Batalkan</button>`,
                didOpen: () => {
                    Swal.showLoading();
                    Swal.getFooter()
                        ?.querySelector("#cancelStep2Btn")
                        ?.addEventListener("click", () => cancelStep2 = true);
                }
            });

            try {
                controllerStep2 = new AbortController();

                if (cancelStep2) return handleCancelStep2(opnameId);

                const res = await fetch(
                    "{{ route('opname.step2.process', ['id' => '__ID__', 'loc' => '__LOC__']) }}"
                    .replace('__ID__', opnameId)
                    .replace('__LOC__', locationCode), {
                        method: "POST",
                        signal: controllerStep2.signal,
                        headers: {
                            "X-CSRF-TOKEN": document.querySelector("meta[name='csrf-token']").content,
                            "Accept": "application/json"
                        }
                    }
                );

                if (!res.ok) {
                    throw new Error("Request gagal");
                }

                const json = await res.json();
                if (!json || json.status !== "success") {
                    throw new Error("Response tidak valid");
                }

                Swal.fire({
                    icon: "success",
                    title: "🎉 Step 2 selesai",
                    text: `Data lokasi ${locationCode} berhasil diambil`,
                    confirmButtonText: "OK"
                }).then(() => location.reload());

            } catch (err) {
                if (err.name === "AbortError") return;
                Swal.fire("Gagal", err.message, "error");
            }
        }


        // ===================================================
        // ❌ CANCEL USER → ROLLBACK STEP 2
        // ===================================================
        async function handleCancelStep2(opnameId) {

            controllerStep2?.abort();

            Swal.fire({
                title: "⏹ Dibatalkan",
                html: "Rollback Step 2...",
                showConfirmButton: false,
                allowOutsideClick: false,
                didOpen: () => Swal.showLoading()
            });

            await fetch(
                "{{ route('opname.step2.rollback', ['id' => '__ID__']) }}"
                .replace('__ID__', opnameId), {
                    method: "POST",
                    headers: {
                        "X-CSRF-TOKEN": document.querySelector("meta[name='csrf-token']").content
                    }
                }
            );

            Swal.fire("Selesai", "Rollback berhasil", "info")
                .then(() => location.reload());
        }


        // ===================================================
        // 🔄 MANUAL ROLLBACK STEP 2
        // ===================================================
        async function manualRollbackStep2(opnameId) {

            const ok = await Swal.fire({
                icon: "warning",
                title: "Rollback Step 2?",
                text: "Data Step 2 untuk lokasi ini akan dihapus",
                showCancelButton: true,
                confirmButtonText: "Ya, rollback",
                confirmButtonColor: "#dc3545"
            });

            if (!ok.isConfirmed) return;

            await fetch(
                "{{ route('opname.step2.rollback', ['id' => '__ID__']) }}"
                .replace('__ID__', opnameId), {
                    method: "POST",
                    headers: {
                        "X-CSRF-TOKEN": document.querySelector("meta[name='csrf-token']").content
                    }
                }
            );

            Swal.fire("Rollback Selesai", "Data Step 2 dihapus", "success")
                .then(() => location.reload());
        }
    </script>


@endsection
