@extends('layouts.app')
@section('title','Opname Items')

@section('content')
<div class="container my-4">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4 class="mb-0">
            Opname Items
            <span class="opacity-75">#{{ $req->id }}</span>
        </h4>
        <a href="{{ route('approvals.show', $req->id) }}"
           class="btn btn-outline-secondary btn-sm">
            <i class="fa fa-arrow-left me-1"></i> Back
        </a>
    </div>

    <div class="card card-rounded shadow-sm">
        <div class="card-body table-responsive">
            <table class="table table-sm table-bordered">
                <thead class="table-light">
                    <tr>
                        <th>Storage</th>
                        <th>Code</th>
                        <th>Description</th>
                        <th class="text-end">Qty MBC</th>
                        <th class="text-end">Actual</th>
                        <th class="text-end">Selisih</th>
                        <th>UOM</th>
                        <th>Note</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($items as $row)
                        <tr>
                            <td>{{ $row->storage_location }}</td>
                            <td>{{ $row->code }}</td>
                            <td>{{ $row->material_description }}</td>
                            <td class="text-end">{{ $row->qty_mbc }}</td>
                            <td class="text-end">{{ $row->actual }}</td>
                            <td class="text-end">{{ $row->selisih }}</td>
                            <td>{{ $row->base_unit_of_measure }}</td>
                            <td>{{ $row->note }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

            {{ $items->links() }}
        </div>
    </div>
</div>
@endsection
