@extends('layouts.app')
@section('title', 'All Requests')

@push('styles')
<style>
    .card-rounded { border-radius: 1rem; }
    .badge { font-size: .85rem; }
</style>
@endpush

@section('content')
<div class="container py-4">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4 class="mb-0"><i class="fa fa-clipboard-list me-2"></i>All Requests</h4>
        <div class="d-flex gap-2">
            <a href="{{ route('approvals.mine') }}" class="btn btn-outline-secondary btn-sm">My Forms</a>
            <a href="{{ route('approvals.new') }}" class="btn btn-primary btn-sm">New Item Request</a>
        </div>
    </div>

    {{-- Filter --}}
    <div class="row g-2 mb-3">
        <div class="col-lg-4 col-md-6">
            <input type="text" id="searchInput" class="form-control" placeholder="Search number, vendor, requester…">
        </div>
        <div class="col-lg-2 col-md-6">
            <select id="statusSelect" class="form-select">
                <option value="">Status (any)</option>
                <option value="Draft">Draft</option>
                <option value="InReview">InReview</option>
                <option value="Approved">Approved</option>
                <option value="Rejected">Rejected</option>
            </select>
        </div>
        <div class="col-lg-2 col-md-6">
            <input type="date" id="fromDate" class="form-control">
        </div>
        <div class="col-lg-2 col-md-6">
            <input type="date" id="toDate" class="form-control">
        </div>
        <div class="col-lg-2 col-md-6 d-flex gap-1">
            <button id="resetBtn" class="btn btn-outline-danger w-100">Reset</button>
        </div>
    </div>

    <div class="card card-rounded shadow-sm">
        <div class="table-responsive">
            <table class="table align-middle" id="requestTable">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Vendor</th>
                        <th>Requester</th>
                        <th>From User</th>
                        <th>Flow</th>
                        <th>Status</th>
                        <th>Step</th>
                        <th>Lines</th>
                        <th>Posting Date</th>
                        <th>Updated</th>
                        <th>Open</th>
                    </tr>
                </thead>
                <tbody id="requestTableBody">
                    {{-- JS akan render di sini --}}
                </tbody>
            </table>
        </div>
        <nav>
            <ul class="pagination justify-content-end m-3" id="paginationControls">
                {{-- JS generate page numbers --}}
            </ul>
        </nav>
    </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", function() {
    const items = @json($items);
    const tbody = document.getElementById('requestTableBody');
    const input = document.getElementById('searchInput');
    const status = document.getElementById('statusSelect');
    const from = document.getElementById('fromDate');
    const to = document.getElementById('toDate');
    const resetBtn = document.getElementById('resetBtn');
    const paginationControls = document.getElementById('paginationControls');

    let currentPage = 1;
    const perPage = 20;
    let filteredItems = items;

    function renderTable() {
        tbody.innerHTML = '';
        const start = (currentPage - 1) * perPage;
        const end = start + perPage;
        const pageItems = filteredItems.slice(start, end);

        for (const r of pageItems) {
            const fromUsers = r.user_requests.map(u => u.user?.name).filter(Boolean).join(', ') || '-';
            const linesCount = r.flow_template_id == 6 ? r.lines_vendor_count : r.lines_count;
            const statusClass = r.status === 'Approved' ? 'bg-success'
                : (r.status === 'Rejected' ? 'bg-danger'
                : (r.status === 'InReview' ? 'bg-warning text-dark' : 'bg-secondary'));

            const tr = document.createElement('tr');
            tr.innerHTML = `
                <td><span class="badge bg-secondary">#${r.id}</span></td>
                <td>${r.vendor_name ?? '—'}</td>
                <td>${r.requester?.name ?? '—'}${r.requester?.email ? '<div class="small text-muted">'+r.requester.email+'</div>':''}</td>
                <td>${fromUsers}</td>
                <td>${r.flow?.name ?? '—'}${r.flow?.version ? '<span class="text-muted small"> v'+r.flow.version+'</span>':''}</td>
                <td><span class="badge ${statusClass}">${r.status}</span></td>
                <td>${r.current_step_no ?? '—'}</td>
                <td><span class="badge bg-info">${linesCount}</span></td>
                <td>${r.posting_date ?? '—'}</td>
                <td>${r.updated_at ?? '—'}</td>
                <td><a href="/approvals/${r.id}" class="btn btn-outline-primary btn-sm"><i class="fa fa-eye me-1"></i>View</a></td>
            `;
            tbody.appendChild(tr);
        }

        renderPagination();
    }

    function renderPagination() {
        paginationControls.innerHTML = '';
        const totalPages = Math.ceil(filteredItems.length / perPage);
        const maxPageButtons = 10;

        const createPageItem = (label, page, disabled = false, active = false) => {
            const li = document.createElement('li');
            li.className = `page-item ${disabled ? 'disabled' : ''} ${active ? 'active' : ''}`;
            const a = document.createElement('a');
            a.className = 'page-link';
            a.href = '#';
            a.innerText = label;
            a.addEventListener('click', e => {
                e.preventDefault();
                if (!disabled && !active) {
                    currentPage = page;
                    renderTable();
                }
            });
            li.appendChild(a);
            return li;
        };

        // Prev
        paginationControls.appendChild(createPageItem('Prev', currentPage - 1, currentPage === 1));

        // Logika range halaman dengan ellipsis
        let startPage = Math.max(1, currentPage - Math.floor(maxPageButtons/2));
        let endPage = startPage + maxPageButtons - 1;
        if (endPage > totalPages) {
            endPage = totalPages;
            startPage = Math.max(1, endPage - maxPageButtons + 1);
        }

        if (startPage > 1) {
            paginationControls.appendChild(createPageItem(1, 1));
            if (startPage > 2) {
                const li = document.createElement('li');
                li.className = 'page-item disabled';
                li.innerHTML = `<span class="page-link">…</span>`;
                paginationControls.appendChild(li);
            }
        }

        for (let i = startPage; i <= endPage; i++) {
            paginationControls.appendChild(createPageItem(i, i, false, currentPage === i));
        }

        if (endPage < totalPages) {
            if (endPage < totalPages - 1) {
                const li = document.createElement('li');
                li.className = 'page-item disabled';
                li.innerHTML = `<span class="page-link">…</span>`;
                paginationControls.appendChild(li);
            }
            paginationControls.appendChild(createPageItem(totalPages, totalPages));
        }

        // Next
        paginationControls.appendChild(createPageItem('Next', currentPage + 1, currentPage === totalPages || totalPages === 0));
    }

    function applyFilter() {
        const q = input.value.toLowerCase();
        const st = status.value;
        const f = from.value;
        const t = to.value;

        filteredItems = items.filter(r => {
            let matchesSearch = !q || r.vendor_name?.toLowerCase().includes(q)
                || r.requester?.name?.toLowerCase().includes(q)
                || r.requester?.email?.toLowerCase().includes(q)
                || r.flow?.name?.toLowerCase().includes(q)
                || String(r.id) === q;

            let matchesStatus = !st || r.status === st;
            let matchesFrom = !f || (r.posting_date >= f);
            let matchesTo = !t || (r.posting_date <= t);

            return matchesSearch && matchesStatus && matchesFrom && matchesTo;
        });

        currentPage = 1;
        renderTable();
    }

    input.addEventListener('input', applyFilter);
    status.addEventListener('change', applyFilter);
    from.addEventListener('change', applyFilter);
    to.addEventListener('change', applyFilter);
    resetBtn.addEventListener('click', () => {
        input.value = '';
        status.value = '';
        from.value = '';
        to.value = '';
        applyFilter();
    });

    renderTable(); // render awal
});
</script>
@endsection
