@extends('layouts.app')
@section('title', 'Kelola Business Unit')

@push('styles')
<style>
.container-area {display:flex; gap:20px;}
.area {flex:1; background:#f8fafc; padding:15px 15px 20px; border-radius:18px; border:2px dashed #d1d5db; min-height:380px; position:relative;}
.area h5 {
    text-align:center; font-weight:700; margin-bottom:15px;
    background:#e2e8f0; padding:8px; border-radius:10px;
    pointer-events:none; user-select:none;
}
.user-card {
    padding:10px 15px; background:white; border-radius:10px; margin-bottom:10px;
    cursor:grab; border:1px solid #e2e8f0; transition:0.2s;
}
.user-card:hover {transform:scale(1.02);}
.user-card.dragging {opacity:0.4;}
.user-card small {display:block; color:#6b7280; font-size:0.8rem; margin-top:3px;}

#unassigned {margin-top:20px;}
.title-low {font-size:1rem; font-weight:700; margin-bottom:8px;}

.search-sort-box{
    display:flex; gap:10px; margin:20px 0; align-items:center;
}
.search-sort-box input{
    flex:2; padding:8px 12px; border-radius:8px; border:1px solid #d1d5db;
}
.search-sort-box select{
    flex:1; padding:8px 12px; border-radius:8px; border:1px solid #d1d5db;
}
</style>
@endpush


@section('content')
<div class="container py-4">

    <h2 class="fw-bold mb-4">⚙️ Kelola Business Unit</h2>

    {{-- 🔍 SEARCH & SORT --}}
    <div class="search-sort-box">
        <input type="text" id="searchInput" placeholder="🔍 Cari user (nama / email)...">
        <select id="sortSelect">
            <option value="">Sort By</option>
            <option value="name_asc">Name A → Z</option>
            <option value="name_desc">Name Z → A</option>
            <option value="email_asc">Email A → Z</option>
            <option value="email_desc">Email Z → A</option>
        </select>
    </div>

    <div class="container-area">
        <div class="area" id="rbc" data-unit="RBC">
            <h5 class="area-header">RBC</h5>
            @foreach ($rbc as $u)
                <div class="user-card" data-id="{{ $u->id }}" data-name="{{ strtolower($u->name) }}" data-email="{{ strtolower($u->email) }}">
                    {{ $u->name }}<small>{{ $u->email }}</small>
                </div>
            @endforeach
        </div>

        <div class="area" id="hic" data-unit="HIC">
            <h5 class="area-header">HIC</h5>
            @foreach ($hic as $u)
                <div class="user-card" data-id="{{ $u->id }}" data-name="{{ strtolower($u->name) }}" data-email="{{ strtolower($u->email) }}">
                    {{ $u->name }}<small>{{ $u->email }}</small>
                </div>
            @endforeach
        </div>

        <div class="area" id="ci" data-unit="CI">
            <h5 class="area-header">CI</h5>
            @foreach ($ci as $u)
                <div class="user-card" data-id="{{ $u->id }}" data-name="{{ strtolower($u->name) }}" data-email="{{ strtolower($u->email) }}">
                    {{ $u->name }}<small>{{ $u->email }}</small>
                </div>
            @endforeach
        </div>
    </div>

    {{-- UNASSIGNED --}}
    <div class="mt-5">
        <div class="title-low">🧍 User Tanpa Business Unit</div>
        <div class="area" id="unassigned" data-unit="">
            @foreach ($empty as $u)
                <div class="user-card" data-id="{{ $u->id }}" data-name="{{ strtolower($u->name) }}" data-email="{{ strtolower($u->email) }}">
                    {{ $u->name }}<small>{{ $u->email }}</small>
                </div>
            @endforeach
        </div>
    </div>
</div>
@endsection


@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>

<script>
// =============== DRAG & DROP (PERBAIKAN HEADER TETAP DI ATAS) ===============
function makeList(el){
    Sortable.create(el,{
        group: "users",
        animation: 180,
        draggable: ".user-card",
        handle: ".user-card",
        filter: ".area-header",
        preventOnFilter: true,

        onAdd: (evt) => {
            cleanNull(evt.from);
            cleanNull(evt.to);
            updateUnit(evt);
        },
        onSort: (evt) => {
            cleanNull(evt.from);
            cleanNull(evt.to);
        },
        updateUnit: (evt) => {
            cleanNull(evt.from);
            cleanNull(evt.to);
        },
    });
}


// setelah update → pastikan header balik paling atas
function fixHeader(evt){
    const area = evt.to;
    const header = area.querySelector(".area-header");
    area.prepend(header);
}

// update DB
function updateUnit(evt){
    let userID = evt.item.dataset.id;
    if(!userID) return;
    let unit = evt.to.dataset.unit || null;

    fetch("{{ route('admin.business.unit.update') }}", {
        method:"POST",
        headers:{
            "Content-Type":"application/json",
            "X-CSRF-TOKEN":"{{ csrf_token() }}"
        },
        body:JSON.stringify({ user_id:userID, unit:unit })
    })
    .then(r=>r.json())
    .then(r=>console.log("UPDATED:",r))
    .catch(err=>console.error(err));
}

["rbc","hic","ci","unassigned"].forEach(id=>makeList(document.getElementById(id)));


// ===================== SEARCH FILTER =====================
document.getElementById("searchInput").addEventListener("input", function(){
    const q = this.value.toLowerCase();
    document.querySelectorAll(".area").forEach(area=>{
        const cards = area.querySelectorAll(".user-card");
        cards.forEach(card=>{
            const match = card.dataset.name.includes(q) || card.dataset.email.includes(q);
            card.style.display = match ? "" : "none";
        });
        cleanNull(area); // 🧼 bersihkan null setelah filtering
    });
});



// ===================== SORTING =====================
document.getElementById("sortSelect").addEventListener("change", function(){
    const val = this.value;
    document.querySelectorAll(".area").forEach(area=>{
        let cards = [...area.querySelectorAll(".user-card")];
        cards.sort((a,b)=>{
            if(val==="name_asc")  return a.dataset.name.localeCompare(b.dataset.name);
            if(val==="name_desc") return b.dataset.name.localeCompare(a.dataset.name);
            if(val==="email_asc") return a.dataset.email.localeCompare(b.dataset.email);
            if(val==="email_desc")return b.dataset.email.localeCompare(a.dataset.email);
            return 0;
        });
        cards.forEach(c=>area.appendChild(c));
        fixHeader({to:area});
        cleanNull(area); // 🧼 bersihkan null setelah sorting
    });
});
// ===================== CLEAN NULL NODES =====================

function cleanNull(area){
    if(!area) return;
    [...area.childNodes].forEach(node => {
        // text node, whitespace, null, atau "null"
        if (node.nodeType === 3 && node.textContent.trim().match(/^null$/i)) {
            node.remove();
        }
        if (node.nodeType === 3 && node.textContent.trim() === "") {
            node.remove();
        }
    });
}
</script>
@endpush
