<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('item_after', function (Blueprint $table) {
            // periode format YYYY-MM (contoh: 2025-12)
            $table->string('periode', 7)
                ->after('location')
                ->index();
        });
    }

    public function down(): void
    {
        Schema::table('item_after', function (Blueprint $table) {
            $table->dropColumn('periode');
        });
    }
};

