<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('item_before', function (Blueprint $table) {

            // total kumulatif increase terakhir dari BC
            $table->decimal('last_qty_increase', 15, 5)
                ->default(0)
                ->after('opening_balance');

            // total kumulatif decrease terakhir dari BC
            $table->decimal('last_qty_decrease', 15, 5)
                ->default(0)
                ->after('last_qty_increase');

        });
    }

    public function down(): void
    {
        Schema::table('item_before', function (Blueprint $table) {
            $table->dropColumn([
                'last_qty_increase',
                'last_qty_decrease',
            ]);
        });
    }
};

