<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('item_user_inputs', function (Blueprint $table) {

            // qty_mbc di sebelah actual
            $table->decimal('qty_mbc', 15, 4)
                  ->nullable()
                  ->after('actual');

            // selisih di sebelah qty_mbc
            $table->decimal('selisih', 15, 4)
                  ->nullable()
                  ->after('qty_mbc');
        });
    }

    public function down(): void
    {
        Schema::table('item_user_inputs', function (Blueprint $table) {

            $table->dropColumn(['qty_mbc', 'selisih']);
        });
    }
};
