<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('opname_schedule', function (Blueprint $table) {
            // Tambah waktu mulai & selesai opname
            $table->dateTime('start_at')->nullable()->after('date');
            $table->dateTime('end_at')->nullable()->after('start_at');
        });

        // Update enum status (MySQL specific)
        DB::statement("
            ALTER TABLE opname_schedule 
            MODIFY status ENUM('Pending','Start','Pause','End','Cancel') 
            NOT NULL DEFAULT 'Pending'
        ");
    }

    public function down(): void
    {
        // Rollback enum ke versi awal
        DB::statement("
            ALTER TABLE opname_schedule 
            MODIFY status ENUM('Pending','Start','End') 
            NOT NULL DEFAULT 'Pending'
        ");

        Schema::table('opname_schedule', function (Blueprint $table) {
            $table->dropColumn(['start_at', 'end_at']);
        });
    }
};
