<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('item_user_inputs', function (Blueprint $table) {
            $table->id();

            // relasi opsional
            $table->unsignedBigInteger('item_before_id')->nullable();
            $table->unsignedBigInteger('item_after_id')->nullable();

            // user input
            $table->string('user_email')->nullable();
            $table->string('user_name')->nullable();

            // extra remarks
            $table->text('remarks')->nullable();

            $table->timestamps();

            // FK cascade
            $table->foreign('item_before_id')->references('id')->on('item_before')->onDelete('cascade');
            $table->foreign('item_after_id')->references('id')->on('item_after')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('item_user_inputs');
    }
};
