<?php

// 2025_09_02_000010_create_approval_templates.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('approval_flow_templates', function (Blueprint $t) {
      $t->id();
      $t->string('name');
      $t->string('object_type')->default('NewItem');
      $t->unsignedInteger('version')->default(1);
      $t->boolean('is_active')->default(true);
      $t->timestamps();
    });

    Schema::create('approval_step_templates', function (Blueprint $t) {
      $t->id();
      $t->foreignId('flow_template_id')->constrained('approval_flow_templates')->cascadeOnDelete();
      $t->unsignedInteger('step_no');
      $t->foreignId('approver_role_id')->nullable()->constrained('roles')->nullOnDelete();
      $t->foreignId('approver_user_id')->nullable()->constrained('users')->nullOnDelete();
      $t->json('rule_json')->nullable(); // e.g., {"completion":"allOf"}
      $t->timestamps();
      $t->index(['flow_template_id','step_no']);
    });
  }
  public function down(): void {
    Schema::dropIfExists('approval_step_templates');
    Schema::dropIfExists('approval_flow_templates');
  }
};

