<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OpnameSchedule extends Model
{
    protected $table = 'opname_schedule';

    protected $fillable = [
        'date',
        'periode',
        'location', 
        'start_at',
        'end_at',
        'status',
        'created_by',
        'remaining_minutes',
    ];

    protected $casts = [
        'date' => 'date',
        'start_at' => 'datetime',
        'end_at' => 'datetime',
    ];

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
