<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Session;

class BcAuthMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next)
    {
        $authUser = auth()->user();
        $sessionUser = Session::get('user');

        // ❌ kalau 2-2 nya hilang → paksa login ulang
        if (!$authUser && !$sessionUser) {
            auth()->logout();
            Session::flush();
            return redirect()->route('login')->withErrors([
                'session' => 'Sesi habis, silakan login kembali.'
            ]);
        }

        // ❌ kalau auth() ada tapi session hilang (kasus anomali microsoft) → paksa logout
        if ($authUser && !$sessionUser) {
            auth()->logout();
            Session::flush();
            return redirect()->route('login')->withErrors([
                'session' => 'Sesi login tidak valid, silakan login ulang.'
            ]);
        }

        // ❌ kalau session ada tapi auth hilang (aneh) → reset
        if (!$authUser && $sessionUser) {
            Session::flush();
            return redirect()->route('login')->withErrors([
                'session' => 'Sesi tidak sinkron, silakan login kembali.'
            ]);
        }

        // ✔ aman
        return $next($request);
    }


}
