<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ItemBeforeS1;

class OpnameExportController extends Controller
{
    public function exportLocation(Request $request)
    {
        $request->validate([
            'periode'  => 'required|string',
            'location' => 'required|string',
        ]);

        $rows = ItemBeforeS1::where('periode', $request->periode)
            ->where('location', $request->location)
            ->where('step', 'step 1')
            ->orderBy('item_no')
            ->get();

        $mapped = $rows->map(function ($row, $i) {
            return [
                'No' => $i + 1,
                'Storage Location' => $row->location,
                'Code' => $row->item_no,
                'Material Description' => $row->item_description,
                'Actual' => '',
                'Base Unit of Measure' => $row->uom,
                'Note' => '',
            ];
        });

        return response()->json([
            'filename' => "StockOpname_{$request->location}_{$request->periode}.xlsx",
            'data' => $mapped
        ]);
    }

    private function formatActual($value)
    {
        if ($value === null) return 0;

        $formatted = number_format((float) $value, 4, '.', '');
        return rtrim(rtrim($formatted, '0'), '.');
    }
}
