

<?php $__env->startSection('title', 'Manage Data - HIRBND'); ?>
<?php $__env->startSection('page-title', 'Manage Data'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .data-status-card {
        background: linear-gradient(135deg, #0066CC, #0052A3);
        color: white;
        border-radius: 12px;
        padding: 32px;
        margin-bottom: 24px;
        text-align: center;
    }

    .data-status-card h2 {
        font-size: 24px;
        margin-bottom: 8px;
    }

    .data-status-card p {
        font-size: 16px;
        opacity: 0.9;
    }

    .last-update {
        font-size: 20px;
        font-weight: 700;
        margin-top: 16px;
        background: rgba(255, 255, 255, 0.2);
        padding: 12px 24px;
        border-radius: 8px;
        display: inline-block;
    }

    .refresh-section {
        text-align: center;
        padding: 40px;
    }

    .refresh-section h3 {
        color: #333;
        margin-bottom: 16px;
    }

    .refresh-section p {
        color: #6c757d;
        margin-bottom: 32px;
        line-height: 1.6;
    }

    .btn-refresh {
        padding: 16px 48px;
        font-size: 18px;
        background: #0066CC;
        color: white;
        border: none;
        border-radius: 12px;
        cursor: pointer;
        transition: all 0.3s ease;
        display: inline-flex;
        align-items: center;
        gap: 12px;
    }

    .btn-refresh:hover {
        background: #0052A3;
        transform: translateY(-4px);
        box-shadow: 0 6px 20px rgba(0, 102, 204, 0.3);
    }

    .btn-refresh i {
        font-size: 20px;
    }

    .info-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 20px;
        margin-top: 32px;
    }

    .info-item {
        background: #f8f9fa;
        padding: 20px;
        border-radius: 8px;
        text-align: center;
    }

    .info-item i {
        font-size: 32px;
        color: #0066CC;
        margin-bottom: 12px;
    }

    .info-item .info-label {
        font-size: 14px;
        color: #6c757d;
        margin-bottom: 8px;
    }

    .info-item .info-value {
        font-size: 20px;
        font-weight: 700;
        color: #333;
    }

    .warning-box {
        background: #fff3cd;
        border-left: 4px solid #ffc107;
        padding: 16px 20px;
        border-radius: 8px;
        margin-bottom: 24px;
    }

    .warning-box h4 {
        color: #856404;
        margin-bottom: 8px;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .warning-box p {
        color: #856404;
        font-size: 14px;
        margin: 0;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Data Status Card -->
    <div class="data-status-card">
        <h2><i class="fas fa-database"></i> Data Status</h2>
        <p>Monitor and refresh your room monitoring data</p>
        <div class="last-update">
            <i class="fas fa-clock"></i> Last Update: <span id="lastUpdateTime"><?php echo e($lastDataLoad); ?></span>
        </div>
    </div>

    <!-- Warning Box -->
    <div class="warning-box">
        <h4>
            <i class="fas fa-exclamation-triangle"></i>
            Important Information
        </h4>
        <p>
            <strong>⚠️ Caution:</strong> Refreshing data will fetch the latest information from Business Central API. 
            This process may take 2-5 minutes depending on data volume. Please do not close this page during the refresh process.
        </p>
    </div>

    <!-- Main Refresh Section -->
    <div class="card">
        <div class="refresh-section">
            <h3>Refresh Data from Business Central</h3>
            <p>
                Click the button below to fetch the latest room monitoring data from Microsoft Dynamics 365 Business Central.<br>
                This will update all 12 monthly tables and OOO (Out of Order) data.
            </p>
            <button onclick="refreshData()" class="btn-refresh" id="refreshBtn">
                <i class="fas fa-sync-alt"></i>
                Refresh Data Now
            </button>
        </div>

        <!-- Info Grid -->
        <div class="info-grid">
            <div class="info-item">
                <i class="fas fa-calendar-alt"></i>
                <div class="info-label">Monthly Tables</div>
                <div class="info-value">12</div>
            </div>

            <div class="info-item">
                <i class="fas fa-bed"></i>
                <div class="info-label">Room Types</div>
                <div class="info-value">19</div>
            </div>

            <div class="info-item">
                <i class="fas fa-tools"></i>
                <div class="info-label">OOO Tracking</div>
                <div class="info-value">Active</div>
            </div>

            <div class="info-item">
                <i class="fas fa-server"></i>
                <div class="info-label">Data Source</div>
                <div class="info-value">BC API</div>
            </div>
        </div>
    </div>

    <!-- Instructions -->
    <div class="card">
        <div class="card-header">
            <i class="fas fa-question-circle"></i>
            How to Use
        </div>
        <ol style="color: #6c757d; line-height: 2;">
            <li>Click the "<strong>Refresh Data Now</strong>" button to start the data synchronization process</li>
            <li>A loading screen will appear showing the progress of data fetching</li>
            <li>The system will fetch data for all 12 months from Business Central API</li>
            <li>OOO (Out of Order) data will also be synchronized automatically</li>
            <li>Once completed, you will see a success message and the "Last Update" time will be updated</li>
            <li>You can then access all room monitoring features with the latest data</li>
        </ol>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // ✅ Get CSRF token
    const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');

    async function refreshData() {
        const btn = document.getElementById('refreshBtn');
        
        // Validation
        if (!csrfToken) {
            alert('CSRF token not found! Please refresh the page.');
            return;
        }

        if (!confirm('This will fetch latest data from Business Central API. This process may take 2-5 minutes. Continue?')) {
            return;
        }

        // Disable button
        btn.disabled = true;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Loading...';

        try {
            console.log('Starting data refresh...');
            console.log('CSRF Token:', csrfToken);
            console.log('URL:', '<?php echo e(route("hirbnd.manage-data.refresh")); ?>');

            const response = await fetch('<?php echo e(route("hirbnd.manage-data.refresh")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken,
                    'Accept': 'application/json'
                }
            });

            console.log('Response status:', response.status);
            console.log('Response OK:', response.ok);

            if (!response.ok) {
                const errorText = await response.text();
                console.error('Error response:', errorText);
                throw new Error(`HTTP ${response.status}: ${errorText}`);
            }

            const result = await response.json();
            console.log('Result:', result);

            if (result.success) {
                alert('✅ Data successfully refreshed!\n\nYou will be redirected to dashboard.');
                
                // Update last update time
                const now = new Date();
                const formatted = now.toLocaleString('id-ID', {
                    day: '2-digit',
                    month: '2-digit',
                    year: 'numeric',
                    hour: '2-digit',
                    minute: '2-digit',
                    second: '2-digit'
                });
                document.getElementById('lastUpdateTime').textContent = formatted;

                // Redirect
                setTimeout(() => {
                    window.location.href = '<?php echo e(route("hirbnd.dashboard")); ?>';
                }, 1000);
            } else {
                alert('❌ Failed: ' + (result.message || 'Unknown error'));
                btn.disabled = false;
                btn.innerHTML = '<i class="fas fa-sync-alt"></i> Refresh Data Now';
            }

        } catch (error) {
            console.error('Fetch error:', error);
            alert('❌ Error: ' + error.message + '\n\nCheck browser console (F12) for details.');
            btn.disabled = false;
            btn.innerHTML = '<i class="fas fa-sync-alt"></i> Refresh Data Now';
        }
    }

    // Debug: Log when script loaded
    console.log('Manage Data script loaded');
    console.log('CSRF Token available:', !!csrfToken);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.hirbnd', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\room-monitoring-revenue\resources\views/hirbnd/manage-data.blade.php ENDPATH**/ ?>