@extends('layouts.regent')

@section('title', $roomTypeName)

@push('styles')
<style>
    .room-type-header {
        background: linear-gradient(135deg, #00897b, #26a69a);
        color: white;
        border-radius: 12px;
        padding: 32px;
        margin-bottom: 32px;
    }

    .room-type-header h2 {
        font-size: 32px;
        margin-bottom: 8px;
    }

    .breadcrumb {
        display: flex;
        gap: 8px;
        align-items: center;
        margin-bottom: 24px;
        font-size: 14px;
    }

    .breadcrumb a {
        color: #00897b;
        text-decoration: none;
    }

    .breadcrumb a:hover {
        text-decoration: underline;
    }

    .breadcrumb span {
        color: #999;
    }

    .rooms-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
        gap: 20px;
    }

    .room-card {
        background: white;
        border-radius: 12px;
        padding: 24px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        transition: all 0.3s;
        text-decoration: none;
        color: inherit;
        text-align: center;
        border: 2px solid transparent;
    }

    .room-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 20px rgba(0, 137, 123, 0.2);
        border-color: #00897b;
    }

    .room-number {
        font-size: 28px;
        font-weight: 700;
        color: #00897b;
        margin-bottom: 8px;
    }

    .room-icon {
        font-size: 32px;
        color: #26a69a;
        margin-bottom: 12px;
    }

    .room-label {
        font-size: 13px;
        color: #666;
    }
</style>
@endpush

@section('content')
    <!-- Breadcrumb -->
    <div class="breadcrumb">
        <a href="{{ route('regent.rooms') }}"><i class="fas fa-home"></i> Room Categories</a>
        <span>/</span>
        <span>{{ $roomTypeName }}</span>
    </div>

    <!-- Room Type Header -->
    <div class="room-type-header">
        <h2><i class="fas fa-door-open"></i> {{ $roomTypeName }}</h2>
        <p>{{ count($rooms) }} rooms available</p>
    </div>

    <!-- Rooms Grid -->
    <div class="rooms-grid">
        @foreach($rooms as $room)
            <a href="{{ route('regent.rooms.matrix', ['roomType' => $roomType, 'room' => $room]) }}" class="room-card">
                <div class="room-icon">
                    <i class="fas fa-bed"></i>
                </div>
                <div class="room-number">{{ $room }}</div>
                <div class="room-label">View Matrix</div>
            </a>
        @endforeach
    </div>
@endsection