@extends('layouts.regent')

@section('title', 'Room ' . $room . ' Matrix')

@push('styles')
<style>
    .matrix-header {
        background: linear-gradient(135deg, #00897b, #26a69a);
        color: white;
        border-radius: 12px;
        padding: 32px;
        margin-bottom: 32px;
    }

    .matrix-header h1 {
        font-size: 42px;
        margin-bottom: 8px;
    }

    .breadcrumb {
        display: flex;
        gap: 8px;
        align-items: center;
        margin-bottom: 24px;
        font-size: 14px;
        color: white;
    }

    .breadcrumb a {
        color: white;
        text-decoration: none;
        opacity: 0.9;
    }

    .breadcrumb a:hover {
        opacity: 1;
        text-decoration: underline;
    }

    .breadcrumb span {
        opacity: 0.7;
    }

    .matrix-wrapper {
        background: white;
        border-radius: 12px;
        padding: 24px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        overflow-x: auto;
    }

    .matrix-table {
        width: 100%;
        border-collapse: collapse;
        font-size: 13px;
        min-width: 1400px;
    }

    .matrix-table th {
        background: #00897b;
        color: white;
        padding: 12px 8px;
        text-align: center;
        font-weight: 600;
        position: sticky;
        top: 0;
        z-index: 10;
    }

    .matrix-table td {
        padding: 10px 8px;
        text-align: center;
        border: 1px solid #e0e0e0;
    }

    .matrix-table tbody tr:hover {
        background: #f8f9fa;
    }

    .day-cell {
        background: #f0f0f0;
        font-weight: 600;
        text-align: left;
        padding-left: 16px;
    }

    .amount.positive {
        background: #e8f5e9;
        color: #2e7d32;
        font-weight: 600;
    }

    .amount.zero {
        background: #f8f9fa;
        color: #999;
    }

    .summary-row {
        background: #f0f0f0;
        font-weight: 700;
    }

    .summary-row .total {
        background: #00897b;
        color: white;
    }

    .summary-row .average {
        background: #26a69a;
        color: white;
    }
</style>
@endpush

@section('content')
    <div class="matrix-header">
        <!-- Breadcrumb -->
        <div class="breadcrumb">
            <a href="{{ route('regent.rooms') }}"><i class="fas fa-home"></i> Room Categories</a>
            <span>/</span>
            <a href="{{ $submenu && $submenu !== 'direct' ? route('regent.rooms.suite.submenu', ['roomType' => $roomType, 'submenu' => $submenu]) : route('regent.rooms.type', $roomType) }}">
                {{ $roomTypeName }}
            </a>
            @if($submenu && $submenu !== 'direct' && $submenuName)
                <span>/</span>
                <span>{{ $submenuName }}</span>
            @endif
            <span>/</span>
            <span>Room {{ $room }}</span>
        </div>

        <h1><i class="fas fa-door-open"></i> Room {{ $room }}</h1>
        <p>Revenue matrix for all months</p>
    </div>

    <div class="matrix-wrapper">
        @php
            $monthNames = ['january', 'february', 'march', 'april', 'may', 'june', 'july', 'august', 'september', 'october', 'november', 'december'];
            $daysInMonth = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
            
            // Process data per day
            $dailyRevenue = [];
            $monthlyTotals = array_fill(0, 12, 0);
            $monthlyCounts = array_fill(0, 12, 0);
            
            foreach($monthNames as $idx => $monthName) {
                $monthData = $monthlyData[$monthName] ?? collect();
                
                // Group by day
                $grouped = $monthData->groupBy(function($item) {
                    return (int) date('d', strtotime($item->Posting_Date));
                });
                
                foreach($grouped as $day => $records) {
                    $dailyTotal = $records->sum('Amount_1');
                    $dailyRevenue[$day][$idx] = $dailyTotal;
                    $monthlyTotals[$idx] += $dailyTotal;
                    if($dailyTotal > 0) $monthlyCounts[$idx]++;
                }
            }
        @endphp

        <table class="matrix-table">
            <thead>
                <tr>
                    <th style="min-width: 80px;">Day</th>
                    <th>Jan</th>
                    <th>Feb</th>
                    <th>Mar</th>
                    <th>Apr</th>
                    <th>May</th>
                    <th>Jun</th>
                    <th>Jul</th>
                    <th>Aug</th>
                    <th>Sep</th>
                    <th>Oct</th>
                    <th>Nov</th>
                    <th>Dec</th>
                </tr>
            </thead>
            <tbody>
                {{-- Day rows --}}
                @for($day = 1; $day <= 31; $day++)
                    <tr>
                        <td class="day-cell">{{ $day }}</td>
                        @for($monthIdx = 0; $monthIdx < 12; $monthIdx++)
                            @if($day <= $daysInMonth[$monthIdx])
                                @php
                                    $amount = $dailyRevenue[$day][$monthIdx] ?? 0;
                                @endphp
                                @if($amount > 0)
                                    <td class="amount positive">{{ number_format($amount, 0, ',', '.') }}</td>
                                @else
                                    <td class="amount zero">-</td>
                                @endif
                            @else
                                <td class="amount zero">-</td>
                            @endif
                        @endfor
                    </tr>
                @endfor

                {{-- Total Row --}}
                <tr class="summary-row">
                    <td>TOTAL</td>
                    @foreach($monthlyTotals as $total)
                        <td class="total">{{ number_format($total, 0, ',', '.') }}</td>
                    @endforeach
                </tr>

                {{-- Average Row --}}
                <tr class="summary-row">
                    <td>AVERAGE</td>
                    @foreach($monthlyTotals as $idx => $total)
                        @php
                            $avg = $monthlyCounts[$idx] > 0 ? $total / $monthlyCounts[$idx] : 0;
                        @endphp
                        <td class="average">{{ number_format($avg, 0, ',', '.') }}</td>
                    @endforeach
                </tr>
            </tbody>
        </table>
    </div>
@endsection