@extends('layouts.regent')

@section('title', 'Room Categories')

@push('styles')
<style>
    .rooms-header {
        background: linear-gradient(135deg, #00897b, #26a69a);
        color: white;
        border-radius: 12px;
        padding: 32px;
        margin-bottom: 32px;
    }

    .rooms-header h2 {
        font-size: 32px;
        margin-bottom: 8px;
    }

    .room-categories {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 24px;
    }

    .category-card {
        background: white;
        border-radius: 12px;
        padding: 32px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        transition: all 0.3s;
        text-decoration: none;
        color: inherit;
        border: 2px solid transparent;
    }

    .category-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 8px 24px rgba(0, 137, 123, 0.2);
        border-color: #00897b;
    }

    .category-icon {
        width: 80px;
        height: 80px;
        background: linear-gradient(135deg, #00897b, #26a69a);
        border-radius: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 36px;
        margin-bottom: 20px;
    }

    .category-title {
        font-size: 24px;
        font-weight: 700;
        color: #00897b;
        margin-bottom: 12px;
    }

    .category-desc {
        font-size: 14px;
        color: #666;
        margin-bottom: 16px;
    }

    .category-count {
        display: inline-block;
        background: #e8f5e9;
        color: #00897b;
        padding: 6px 16px;
        border-radius: 20px;
        font-size: 13px;
        font-weight: 600;
    }
</style>
@endpush

@section('content')
    <div class="rooms-header">
        <h2><i class="fas fa-door-open"></i> Room Categories</h2>
        <p>Select a room category to view details</p>
    </div>

    <div class="room-categories">
        <!-- Penthouse -->
        <a href="{{ route('regent.rooms.type', 'penthouse') }}" class="category-card">
            <div class="category-icon">
                <i class="fas fa-crown"></i>
            </div>
            <div class="category-title">Penthouse</div>
            <div class="category-desc">Luxurious penthouse suites</div>
            <div class="category-count">
                {{ count($roomTypes['penthouse']['rooms']) }} Rooms
            </div>
        </a>

        <!-- Beach Villa -->
        <a href="{{ route('regent.rooms.type', 'beach_villa') }}" class="category-card">
            <div class="category-icon">
                <i class="fas fa-umbrella-beach"></i>
            </div>
            <div class="category-title">Beach Villa</div>
            <div class="category-desc">Beachfront villa experience</div>
            <div class="category-count">
                {{ count($roomTypes['beach_villa']['rooms']) }} Rooms
            </div>
        </a>

        <!-- Padi Villa -->
        <a href="{{ route('regent.rooms.type', 'padi_villa') }}" class="category-card">
            <div class="category-icon">
                <i class="fas fa-leaf"></i>
            </div>
            <div class="category-title">Padi Villa</div>
            <div class="category-desc">Traditional rice field villas</div>
            <div class="category-count">
                {{ count($roomTypes['padi_villa']['rooms']) }} Rooms
            </div>
        </a>

        <!-- Corner Suite -->
        <a href="{{ route('regent.rooms.type', 'corner_suite') }}" class="category-card">
            <div class="category-icon">
                <i class="fas fa-building"></i>
            </div>
            <div class="category-title">Corner Suite</div>
            <div class="category-desc">Premium corner suites</div>
            <div class="category-count">
                {{ count($roomTypes['corner_suite']['rooms']) }} Rooms
            </div>
        </a>

        <!-- Suite -->
        <a href="{{ route('regent.rooms.suite.submenu', ['roomType' => 'suite', 'submenu' => 'suite_gw_a']) }}" class="category-card">
            <div class="category-icon">
                <i class="fas fa-hotel"></i>
            </div>
            <div class="category-title">Suite</div>
            <div class="category-desc">Multiple suite categories</div>
            @php
                $totalSuiteRooms = 0;
                foreach($roomTypes['suite']['submenu'] as $submenu) {
                    $totalSuiteRooms += count($submenu['rooms']);
                }
            @endphp
            <div class="category-count">
                {{ $totalSuiteRooms }} Rooms
            </div>
        </a>
    </div>
@endsection