@extends('layouts.hirbnd')

@section('title', 'Room ' . $room . ' - ' . $roomType)
@section('page-title', 'Room Matrix: ' . $room)

@push('styles')
<style>
    .breadcrumb-custom {
        display: flex;
        align-items: center;
        gap: 8px;
        font-size: 14px;
        margin-bottom: 24px;
        padding: 16px 24px;
        background: white;
        border-radius: 8px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
    }

    .breadcrumb-link {
        color: #0066CC;
        text-decoration: none;
        transition: color 0.3s ease;
    }

    .breadcrumb-link:hover {
        color: #0052A3;
    }

    .breadcrumb-separator {
        color: #adb5bd;
    }

    .breadcrumb-current {
        color: #333;
        font-weight: 600;
    }

    .room-header-card {
        background: linear-gradient(135deg, #0066CC, #0052A3);
        color: white;
        border-radius: 12px;
        padding: 32px;
        margin-bottom: 32px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .room-header-left h1 {
        font-size: 48px;
        margin-bottom: 8px;
    }

    .room-header-left p {
        font-size: 18px;
        opacity: 0.9;
    }

    .room-header-right {
        text-align: right;
    }

    .year-badge {
        background: rgba(255, 255, 255, 0.2);
        padding: 12px 24px;
        border-radius: 8px;
        font-size: 24px;
        font-weight: 700;
        margin-bottom: 12px;
    }

    .room-type-label {
        font-size: 14px;
        opacity: 0.9;
    }

    .matrix-table-wrapper {
        overflow-x: auto;
        background: white;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }

    .matrix-table {
        width: 100%;
        border-collapse: collapse;
        font-size: 13px;
    }

    .matrix-table th {
        background: #0066CC;
        color: white;
        padding: 12px 8px;
        text-align: center;
        font-weight: 600;
        position: sticky;
        top: 0;
        z-index: 10;
    }

    .matrix-table th.month-header {
        min-width: 100px;
    }

    .matrix-table td {
        padding: 10px 8px;
        text-align: center;
        border: 1px solid #e0e0e0;
        transition: all 0.3s ease;
    }

    .matrix-table tbody tr:hover {
        background: #f8f9fa;
    }

    .matrix-table td.day-cell {
        background: #f0f0f0;
        font-weight: 600;
    }

    .matrix-table td.amount {
        font-weight: 600;
        color: #333;
    }

    .matrix-table td.amount.positive {
        background: #e7f8f0;
        color: #28a745;
    }

    .matrix-table td.amount.zero {
        background: #f8f9fa;
        color: #6c757d;
    }

    .matrix-table td.total {
        background: #e7f3ff;
        font-weight: 700;
        color: #0066CC;
    }

    .matrix-table td.average {
        background: #fff3e0;
        font-weight: 700;
        color: #fd7e14;
    }

    .summary-row {
        background: #f0f0f0 !important;
        font-weight: 700;
    }

    .btn-export {
        background: #28a745;
        color: white;
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-weight: 600;
        cursor: pointer;
        margin-bottom: 16px;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-export:hover {
        background: #218838;
    }
</style>
@endpush

@section('content')
    <!-- Breadcrumb -->
    <div class="breadcrumb-custom">
        <a href="{{ route('hirbnd.dashboard') }}" class="breadcrumb-link">
            <i class="fas fa-home"></i> Dashboard
        </a>
        <span class="breadcrumb-separator">›</span>
        <a href="{{ request()->routeIs('hirbnd.suite*') ? route('hirbnd.suite') : route('hirbnd.standard') }}" class="breadcrumb-link">
            {{ request()->routeIs('hirbnd.suite*') ? 'Suite Rooms' : 'Standard Rooms' }}
        </a>
        <span class="breadcrumb-separator">›</span>
        <a href="{{ request()->routeIs('hirbnd.suite*') ? route('hirbnd.suite.room-type', $roomType) : route('hirbnd.standard.room-type', $roomType) }}" class="breadcrumb-link">
            {{ $roomType }}
        </a>
        <span class="breadcrumb-separator">›</span>
        <span class="breadcrumb-current">Room {{ $room }}</span>
    </div>

    <!-- Room Header -->
    <div class="room-header-card">
        <div class="room-header-left">
            <h1><i class="fas fa-door-open"></i> Room {{ $room }}</h1>
            <p>{{ $roomType }} - Revenue Matrix</p>
        </div>
        <div class="room-header-right">
            <div class="year-badge">
                <i class="fas fa-calendar-alt"></i> 2025
            </div>
            <div class="room-type-label">12 Months Data</div>
        </div>
    </div>

    <!-- Export Button -->
    <button onclick="exportToExcel()" class="btn-export">
        <i class="fas fa-file-excel"></i> Export to Excel
    </button>

    <!-- Matrix Table -->
    <div class="matrix-table-wrapper">
        <table class="matrix-table">
            <thead>
                <tr>
                    <th class="month-header">Day/Month</th>
                    @foreach(['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'] as $month)
                        <th class="month-header">{{ $month }}</th>
                    @endforeach
                </tr>
            </thead>
            <tbody>
                @php
                    $monthNames = ['january', 'february', 'march', 'april', 'may', 'june', 'july', 'august', 'september', 'october', 'november', 'december'];
                    $daysInMonth = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
                    
                    // Process data per day
                    $dailyRevenue = [];
                    $monthlyTotals = array_fill(0, 12, 0);
                    $monthlyCounts = array_fill(0, 12, 0);
                    
                    foreach($monthNames as $idx => $monthName) {
                        $monthData = $monthlyData[$monthName] ?? collect();
                        
                        // Group by day
                        $grouped = $monthData->groupBy(function($item) {
                            return (int) date('d', strtotime($item->Posting_Date));
                        });
                        
                        foreach($grouped as $day => $records) {
                            $dailyTotal = $records->sum('Amount_1');
                            $dailyRevenue[$day][$idx] = $dailyTotal;
                            $monthlyTotals[$idx] += $dailyTotal;
                            if($dailyTotal > 0) $monthlyCounts[$idx]++;
                        }
                    }
                @endphp
                
                {{-- Day rows --}}
                @for($day = 1; $day <= 31; $day++)
                    <tr>
                        <td class="day-cell">{{ $day }}</td>
                        @for($monthIdx = 0; $monthIdx < 12; $monthIdx++)
                            @if($day <= $daysInMonth[$monthIdx])
                                @php
                                    $amount = $dailyRevenue[$day][$monthIdx] ?? 0;
                                @endphp
                                @if($amount > 0)
                                    <td class="amount positive">{{ number_format($amount, 0, ',', '.') }}</td>
                                @else
                                    <td class="amount zero">-</td>
                                @endif
                            @else
                                <td class="amount zero">-</td>
                            @endif
                        @endfor
                    </tr>
                @endfor
                
                {{-- Total Row --}}
                <tr class="summary-row">
                    <td>TOTAL</td>
                    @foreach($monthlyTotals as $total)
                        <td class="total">{{ number_format($total, 0, ',', '.') }}</td>
                    @endforeach
                </tr>
                
                {{-- Average Row --}}
                <tr class="summary-row">
                    <td>AVERAGE</td>
                    @foreach($monthlyTotals as $idx => $total)
                        @php
                            $avg = $monthlyCounts[$idx] > 0 ? $total / $monthlyCounts[$idx] : 0;
                        @endphp
                        <td class="average">{{ number_format($avg, 0, ',', '.') }}</td>
                    @endforeach
                </tr>
            </tbody>
        </table>
    </div>
@endsection

@push('scripts')
<script>
    function exportToExcel() {
        alert('Excel export feature coming soon!');
    }
</script>
@endpush