@extends('layouts.hirbnd')

@section('title', "Room {$room} - OOO Detail - HIRBND")
@section('page-title', "Room {$room} - OOO Detail")

@push('styles')
<style>
    /* Header BIRU */
    .detail-header {
        background: linear-gradient(135deg, #0ea5e9, #0284c7);
        color: white;
        border-radius: 12px;
        padding: 32px;
        margin-bottom: 24px;
        box-shadow: 0 4px 12px rgba(14, 165, 233, 0.3);
    }

    .detail-header h2 {
        font-size: 32px;
        margin-bottom: 8px;
        font-weight: 700;
    }

    .detail-header p {
        font-size: 16px;
        opacity: 0.95;
    }

    .back-button {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 12px 24px;
        background: white;
        color: #0ea5e9;
        border-radius: 8px;
        text-decoration: none;
        font-weight: 600;
        margin-bottom: 24px;
        transition: all 0.3s ease;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }

    .back-button:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        color: #0284c7;
    }

    /* Info Box */
    .info-box {
        background: #dbeafe;
        border-left: 4px solid #0ea5e9;
        padding: 16px 20px;
        border-radius: 8px;
        margin-bottom: 24px;
    }

    .info-box strong {
        color: #0c4a6e;
        display: block;
        margin-bottom: 8px;
        font-size: 14px;
    }

    .info-box p {
        color: #0c4a6e;
        font-size: 13px;
        margin: 0;
        line-height: 1.6;
    }

    /* Matrix Container */
    .matrix-container {
        background: white;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        overflow: hidden;
        margin-bottom: 24px;
    }

    .matrix-wrapper {
        overflow-x: auto;
    }

    /* Matrix Table */
    .matrix-table {
        width: 100%;
        border-collapse: collapse;
        font-size: 12px;
        min-width: 1400px;
    }

    .matrix-table th {
        background: #0ea5e9;
        color: white;
        padding: 10px 4px;
        text-align: center;
        font-weight: 600;
        border: 1px solid #0284c7;
        position: sticky;
        top: 0;
        z-index: 10;
    }

    .matrix-table th.month-header {
        background: #0284c7;
        font-size: 13px;
        font-weight: 700;
        min-width: 80px;
    }

    .matrix-table th.day-header {
        font-size: 11px;
        min-width: 30px;
    }

    .matrix-table td {
        padding: 8px 4px;
        text-align: center;
        border: 1px solid #e5e7eb;
        background: white;
        transition: all 0.2s ease;
    }

    .matrix-table td.ooo {
        background: #ffccbc;
        color: #bf360c;
        font-weight: 700;
        font-size: 14px;
    }

    .matrix-table td.available {
        color: #cbd5e1;
        font-weight: 500;
    }

    .matrix-table td.invalid {
        background: #f3f4f6;
        color: #d1d5db;
    }

    .matrix-table tbody tr:hover td {
        background: #f8fafc;
    }

    .matrix-table tbody tr:hover td.ooo {
        background: #ffb299;
    }

    /* Records Table */
    .records-container {
        background: white;
        border-radius: 12px;
        padding: 24px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }

    .records-container h3 {
        color: #0ea5e9;
        margin-bottom: 16px;
        font-size: 20px;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .records-table {
        width: 100%;
        border-collapse: collapse;
    }

    .records-table thead tr {
        background: #f3f4f6;
    }

    .records-table th {
        padding: 12px;
        text-align: left;
        border-bottom: 2px solid #e5e7eb;
        font-weight: 600;
        color: #0f172a;
    }

    .records-table td {
        padding: 12px;
        border-bottom: 1px solid #e5e7eb;
    }

    .records-table tbody tr:hover {
        background: #f8fafc;
    }

    .badge-ongoing {
        display: inline-block;
        padding: 4px 12px;
        background: #fee2e2;
        color: #dc2626;
        border-radius: 12px;
        font-size: 12px;
        font-weight: 600;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .matrix-table {
            font-size: 10px;
            min-width: 1200px;
        }
        
        .matrix-table th,
        .matrix-table td {
            padding: 6px 2px;
        }
    }
</style>
@endpush

@section('content')
    <!-- Back Button -->
    <a href="{{ route('hirbnd.reports.ooo') }}" class="back-button">
        <i class="fas fa-arrow-left"></i>
        Back to OOO Report
    </a>

    <!-- Detail Header -->
    <div class="detail-header">
        <h2><i class="fas fa-door-closed"></i> Room {{ $room }} - OOO Detail Matrix</h2>
        <p>Full year view (January - December 2025) showing all OOO dates for this room</p>
    </div>

    <!-- Info Box -->
    <div class="info-box">
        <strong><i class="fas fa-info-circle"></i> How to Read:</strong>
        <p>
            <strong style="color: #bf360c;">Orange cells with ●</strong> indicate dates when this room is Out of Order. 
            <strong style="color: #cbd5e1;">Gray dash (-)</strong> indicates the room is available. 
            <strong style="color: #d1d5db;">Light gray</strong> indicates invalid dates for that month (e.g., Feb 30).
        </p>
    </div>

    @php
        // Build yearly matrix: 12 months x 31 days
        $yearlyMatrix = [];
        $months = [
            'january' => 1, 'february' => 2, 'march' => 3, 'april' => 4,
            'may' => 5, 'june' => 6, 'july' => 7, 'august' => 8,
            'september' => 9, 'october' => 10, 'november' => 11, 'december' => 12
        ];
        
        foreach ($months as $monthName => $monthNumber) {
            $daysInMonth = cal_days_in_month(CAL_GREGORIAN, $monthNumber, 2025);
            $yearlyMatrix[$monthName] = [];
            
            for ($day = 1; $day <= 31; $day++) {
                if ($day > $daysInMonth) {
                    $yearlyMatrix[$monthName][$day] = null; // Invalid date
                    continue;
                }
                
                $hasOOO = false;
                $currentDate = \Carbon\Carbon::create(2025, $monthNumber, $day);
                
                foreach ($oooData as $ooo) {
                    try {
                        $beginDate = \Carbon\Carbon::parse($ooo->Begin_Date);
                        
                        if ($ooo->End_Date && $ooo->End_Date !== '0001-01-01') {
                            $endDate = \Carbon\Carbon::parse($ooo->End_Date);
                        } else {
                            $endDate = \Carbon\Carbon::now()->endOfYear();
                        }
                        
                        if ($currentDate->gte($beginDate) && $currentDate->lte($endDate)) {
                            $hasOOO = true;
                            break;
                        }
                        
                    } catch (\Exception $e) {
                        continue;
                    }
                }
                
                $yearlyMatrix[$monthName][$day] = $hasOOO;
            }
        }
    @endphp

    <!-- Yearly Matrix - SINGLE TABLE -->
    <div class="matrix-container">
        <div class="matrix-wrapper">
            <table class="matrix-table">
                <thead>
                    <tr>
                        <th rowspan="2" class="month-header">Month</th>
                        @for($day = 1; $day <= 31; $day++)
                            <th class="day-header">{{ $day }}</th>
                        @endfor
                    </tr>
                </thead>
                <tbody>
                    @foreach(['january', 'february', 'march', 'april', 'may', 'june', 'july', 'august', 'september', 'october', 'november', 'december'] as $monthName)
                        <tr>
                            <th class="month-header">{{ ucfirst(substr($monthName, 0, 3)) }}</th>
                            @for($day = 1; $day <= 31; $day++)
                                @php
                                    $cellData = $yearlyMatrix[$monthName][$day] ?? null;
                                @endphp
                                @if($cellData === null)
                                    <td class="invalid">-</td>
                                @elseif($cellData)
                                    <td class="ooo" title="{{ ucfirst($monthName) }} {{ $day }}, 2025 - OOO">●</td>
                                @else
                                    <td class="available">-</td>
                                @endif
                            @endfor
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <!-- OOO Records Detail -->
    <div class="records-container">
        <h3>
            <i class="fas fa-list"></i>
            OOO Records for Room {{ $room }}
        </h3>
        <table class="records-table">
            <thead>
                <tr>
                    <th style="width: 15%;">Begin Date</th>
                    <th style="width: 15%;">End Date</th>
                    <th style="width: 35%;">Repair Remark</th>
                    <th style="width: 20%;">Reason</th>
                    <th style="width: 15%;">Status</th>
                </tr>
            </thead>
            <tbody>
                @foreach($oooData as $ooo)
                    <tr>
                        <td>
                            {{ $ooo->Begin_Date ? \Carbon\Carbon::parse($ooo->Begin_Date)->format('d M Y') : '-' }}
                        </td>
                        <td>
    @if($ooo->End_Date && $ooo->End_Date !== '0001-01-01')
        {{ \Carbon\Carbon::parse($ooo->End_Date)->format('d M Y') }}
    @else
        <span class="badge-ongoing">Ongoing</span>
    @endif
</td>
                        <td>{{ $ooo->Repair_Remark ?? '-' }}</td>
                        <td>{{ $ooo->Reason_Desc ?? $ooo->Reason_Code ?? '-' }}</td>
                        <td>
                            @if($ooo->Completed_On === '0001-01-01')
                                <span class="badge-ongoing">
                                    <i class="fas fa-exclamation-circle"></i> Active
                                </span>
                            @else
                                <span style="color: #10b981; font-weight: 600;">
                                    <i class="fas fa-check-circle"></i> Completed
                                </span>
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@endsection
