@extends('layouts.hirbnd')

@section('title', 'House Use Room Detail - Room ' . $room)

@push('styles')
<style>
    .report-header {
        background: linear-gradient(135deg, #0066CC, #0052A3);
        color: white;
        border-radius: 12px;
        padding: 32px;
        margin-bottom: 32px;
        box-shadow: 0 4px 12px rgba(0, 102, 204, 0.3);
    }

    .report-header h2 {
        font-size: 32px;
        margin-bottom: 8px;
    }

    .report-header p {
        font-size: 16px;
        opacity: 0.95;
    }

    .back-button {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 12px 24px;
        background: white;
        color: #0066CC;
        border-radius: 8px;
        text-decoration: none;
        font-weight: 600;
        margin-bottom: 24px;
        transition: all 0.3s;
    }

    .back-button:hover {
        transform: translateX(-4px);
        box-shadow: 0 4px 12px rgba(0, 102, 204, 0.2);
    }

    .stats-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 20px;
        margin-bottom: 32px;
    }

    .stat-box {
        background: white;
        padding: 24px;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        text-align: center;
    }

    .stat-icon {
        font-size: 32px;
        color: #0066CC;
        margin-bottom: 12px;
    }

    .stat-label {
        font-size: 14px;
        color: #666;
        margin-bottom: 8px;
    }

    .stat-value {
        font-size: 32px;
        font-weight: 700;
        color: #333;
    }

    .matrix-table-wrapper {
        overflow-x: auto;
        background: white;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        padding: 20px;
    }

    .matrix-table {
        width: 100%;
        border-collapse: collapse;
        font-size: 12px;
    }

    .matrix-table th {
        background: #0066CC;
        color: white;
        padding: 10px 4px;
        text-align: center;
        font-weight: 600;
        border: 1px solid #0052A3;
        position: sticky;
        top: 0;
        z-index: 10;
    }

    .matrix-table th.month-header {
        background: #0052A3;
        font-size: 13px;
        padding: 12px 8px;
    }

    .matrix-table td {
        padding: 8px 4px;
        text-align: center;
        border: 1px solid #e0e0e0;
    }

    .matrix-table td.house-use {
        background: #d4edda;
        color: #155724;
        font-weight: 600;
    }

    .matrix-table td.no-data {
        background: #f8f9fa;
        color: #ccc;
    }

    .matrix-table td.invalid-day {
        background: #f0f0f0;
        color: #999;
    }

    .legend {
        display: flex;
        gap: 24px;
        margin-bottom: 20px;
        padding: 16px;
        background: white;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }

    .legend-item {
        display: flex;
        align-items: center;
        gap: 8px;
        font-size: 13px;
    }

    .legend-box {
        width: 24px;
        height: 24px;
        border-radius: 4px;
        border: 1px solid #ddd;
    }

    .legend-box.house-use {
        background: #d4edda;
    }

    .legend-box.no-data {
        background: #f8f9fa;
    }

    .legend-box.invalid {
        background: #f0f0f0;
    }
</style>
@endpush

@section('content')
    <!-- Back Button -->
    <a href="{{ route('hirbnd.reports.house-use') }}" class="back-button">
        <i class="fas fa-arrow-left"></i>
        Back to House Use Report
    </a>

    <!-- Report Header -->
    <div class="report-header">
        <h2><i class="fas fa-door-open"></i> Room {{ $room }} - House Use Detail</h2>
        <p>12 Months x 31 Days Matrix View</p>
    </div>

    <!-- Stats Row -->
    <div class="stats-row">
        <div class="stat-box">
            <div class="stat-icon">
                <i class="fas fa-calendar-check"></i>
            </div>
            <div class="stat-label">Total House Use Days</div>
            <div class="stat-value">{{ $totalDays }}</div>
        </div>

        <div class="stat-box">
            <div class="stat-icon">
                <i class="fas fa-door-open"></i>
            </div>
            <div class="stat-label">Room Number</div>
            <div class="stat-value">{{ $room }}</div>
        </div>

        <div class="stat-box">
            <div class="stat-icon">
                <i class="fas fa-percentage"></i>
            </div>
            <div class="stat-label">Usage Rate</div>
            <div class="stat-value">{{ number_format(($totalDays / 365) * 100, 1) }}%</div>
        </div>

        <div class="stat-box">
            <div class="stat-icon">
                <i class="fas fa-chart-bar"></i>
            </div>
            <div class="stat-label">Average per Month</div>
            <div class="stat-value">{{ number_format($totalDays / 12, 1) }}</div>
        </div>
    </div>

    <!-- Legend -->
    <div class="legend">
        <div class="legend-item">
            <div class="legend-box house-use"></div>
            <span>House Use</span>
        </div>
        <div class="legend-item">
            <div class="legend-box no-data"></div>
            <span>No Data</span>
        </div>
        <div class="legend-item">
            <div class="legend-box invalid"></div>
            <span>Invalid Date</span>
        </div>
    </div>

    <!-- Matrix Table -->
    <div class="matrix-table-wrapper">
        <table class="matrix-table">
            <thead>
                <tr>
                    <th class="month-header" style="min-width: 100px;">Month</th>
                    @for($day = 1; $day <= 31; $day++)
                        <th>{{ $day }}</th>
                    @endfor
                </tr>
            </thead>
            <tbody>
                @foreach(['January' => 'january', 'February' => 'february', 'March' => 'march', 'April' => 'april', 'May' => 'may', 'June' => 'june', 'July' => 'july', 'August' => 'august', 'September' => 'september', 'October' => 'october', 'November' => 'november', 'December' => 'december'] as $label => $monthName)
                    <tr>
                        <th class="month-header">{{ $label }}</th>
                        @for($day = 1; $day <= 31; $day++)
                            @php
                                $dayStatus = $yearlyMatrix[$monthName][$day] ?? null;
                            @endphp
                            
                            @if($dayStatus === null)
                                <td class="invalid-day">-</td>
                            @elseif($dayStatus === true)
                                <td class="house-use"><i class="fas fa-check"></i></td>
                            @else
                                <td class="no-data">·</td>
                            @endif
                        @endfor
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@endsection