@extends('layouts.hirbc')

@section('title', 'Room ' . $room . ' Matrix')
@section('page-title', 'Room ' . $room)

@push('styles')
<style>
    .page-header {
        background: linear-gradient(135deg, #D3D3FF, #B8B8FF);
        color: #333;
        border-radius: 12px;
        padding: 32px;
        margin-bottom: 32px;
        box-shadow: 0 4px 12px rgba(211, 211, 255, 0.3);
    }

    .page-header h1 {
        font-size: 32px;
        margin-bottom: 8px;
        font-weight: 700;
    }

    .page-header p {
        font-size: 16px;
        opacity: 0.8;
    }

    .back-button {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 12px 24px;
        background: linear-gradient(135deg, #D3D3FF, #B8B8FF);
        color: #333;
        text-decoration: none;
        border-radius: 10px;
        font-weight: 600;
        margin-bottom: 24px;
        transition: all 0.3s;
    }

    .back-button:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(211, 211, 255, 0.5);
    }

    .monthly-tabs {
        display: flex;
        gap: 8px;
        margin-bottom: 24px;
        flex-wrap: wrap;
    }

    .month-tab {
        padding: 12px 24px;
        background: white;
        border: 2px solid #D3D3FF;
        border-radius: 8px;
        cursor: pointer;
        font-weight: 600;
        transition: all 0.3s;
        color: #333;
    }

    .month-tab:hover {
        background: #D3D3FF;
    }

    .month-tab.active {
        background: linear-gradient(135deg, #D3D3FF, #B8B8FF);
        border-color: #9494E8;
    }

    .month-content {
        display: none;
    }

    .month-content.active {
        display: block;
    }

    .matrix-card {
        background: white;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        overflow: hidden;
        margin-bottom: 24px;
    }

    .matrix-header {
        background: linear-gradient(135deg, #D3D3FF, #B8B8FF);
        padding: 20px 24px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .matrix-header h3 {
        font-size: 20px;
        font-weight: 700;
        color: #333;
    }

    .matrix-stats {
        display: flex;
        gap: 24px;
    }

    .matrix-stat {
        text-align: center;
    }

    .matrix-stat-value {
        font-size: 24px;
        font-weight: 700;
        color: #333;
    }

    .matrix-stat-label {
        font-size: 12px;
        color: #555;
    }

    .matrix-table-wrapper {
        overflow-x: auto;
        padding: 24px;
    }

    .matrix-table {
        width: 100%;
        border-collapse: collapse;
        min-width: 800px;
    }

    .matrix-table th {
        background: #D3D3FF;
        color: #333;
        padding: 12px;
        text-align: left;
        font-weight: 600;
        border: 1px solid #B8B8FF;
    }

    .matrix-table td {
        padding: 12px;
        border: 1px solid #e0e0e0;
    }

    .matrix-table tbody tr:hover {
        background: #f8f9fa;
    }

    .no-data {
        text-align: center;
        padding: 60px;
        color: #999;
    }

    .no-data i {
        font-size: 48px;
        margin-bottom: 16px;
    }

    .summary-cards {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 16px;
        margin-bottom: 24px;
    }

    .summary-card {
        background: white;
        padding: 20px;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        text-align: center;
    }

    .summary-card-icon {
        font-size: 32px;
        color: #9494E8;
        margin-bottom: 12px;
    }

    .summary-card-value {
        font-size: 28px;
        font-weight: 700;
        color: #333;
        margin-bottom: 4px;
    }

    .summary-card-label {
        font-size: 14px;
        color: #666;
    }
</style>
@endpush

@section('content')
    <!-- Back Button -->
    <a href="{{ route('hirbc.rooms.category', $category) }}" class="back-button">
        <i class="fas fa-arrow-left"></i>
        <span>Back to {{ $categoryName }}</span>
    </a>

    <!-- Page Header -->
    <div class="page-header">
        <h1><i class="fas fa-door-open"></i> Room {{ $room }} - Data Matrix</h1>
        <p>{{ $categoryName }} - Monthly revenue and occupancy data</p>
    </div>

    <!-- Monthly Tabs -->
    <div class="monthly-tabs">
        @foreach(['january', 'february', 'march', 'april', 'may', 'june', 'july', 'august', 'september', 'october', 'november', 'december'] as $index => $month)
            <button class="month-tab {{ $index === 0 ? 'active' : '' }}" onclick="showMonth('{{ $month }}')">
                {{ ucfirst($month) }}
            </button>
        @endforeach
    </div>

    <!-- Monthly Content -->
    @foreach(['january', 'february', 'march', 'april', 'may', 'june', 'july', 'august', 'september', 'october', 'november', 'december'] as $index => $month)
        <div class="month-content {{ $index === 0 ? 'active' : '' }}" id="month-{{ $month }}">
            @php
                $data = $monthlyData[$month] ?? collect([]);
                $totalRevenue = $data->sum('Amount_1');
                $recordCount = $data->count();
            @endphp

            <!-- Summary Cards -->
            <div class="summary-cards">
                <div class="summary-card">
                    <div class="summary-card-icon">
                        <i class="fas fa-database"></i>
                    </div>
                    <div class="summary-card-value">{{ $recordCount }}</div>
                    <div class="summary-card-label">Total Records</div>
                </div>

                <div class="summary-card">
                    <div class="summary-card-icon">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                    <div class="summary-card-value">Rp {{ number_format($totalRevenue, 0, ',', '.') }}</div>
                    <div class="summary-card-label">Total Revenue</div>
                </div>

                <div class="summary-card">
                    <div class="summary-card-icon">
                        <i class="fas fa-calendar-alt"></i>
                    </div>
                    <div class="summary-card-value">{{ ucfirst($month) }}</div>
                    <div class="summary-card-label">Current Month</div>
                </div>
            </div>

            <!-- Matrix Table -->
            <div class="matrix-card">
                <div class="matrix-header">
                    <h3><i class="fas fa-table"></i> {{ ucfirst($month) }} Data</h3>
                    <div class="matrix-stats">
                        <div class="matrix-stat">
                            <div class="matrix-stat-value">{{ $recordCount }}</div>
                            <div class="matrix-stat-label">Records</div>
                        </div>
                    </div>
                </div>

                <div class="matrix-table-wrapper">
                    @if($recordCount > 0)
                        <table class="matrix-table">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Date</th>
                                    <th>Room</th>
                                    <th>Market Code</th>
                                    <th>TRX Code</th>
                                    <th>Amount</th>
                                    <th>Description</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($data as $index => $record)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ \Carbon\Carbon::parse($record->Posting_Date)->format('d M Y') }}</td>
                                        <td><strong>{{ $record->Room }}</strong></td>
                                        <td>{{ $record->Market_Code ?? '-' }}</td>
                                        <td>{{ $record->TRX_Code ?? '-' }}</td>
                                        <td><strong>Rp {{ number_format($record->Amount_1, 0, ',', '.') }}</strong></td>
                                        <td>{{ $record->Description ?? '-' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @else
                        <div class="no-data">
                            <i class="fas fa-inbox"></i>
                            <p>No data available for {{ ucfirst($month) }}</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    @endforeach
@endsection

@push('scripts')
<script>
    function showMonth(month) {
        // Hide all month contents
        document.querySelectorAll('.month-content').forEach(el => {
            el.classList.remove('active');
        });

        // Remove active class from all tabs
        document.querySelectorAll('.month-tab').forEach(el => {
            el.classList.remove('active');
        });

        // Show selected month content
        document.getElementById('month-' + month).classList.add('active');

        // Add active class to clicked tab
        event.target.classList.add('active');
    }
</script>
@endpush