@extends('layouts.hirbc')

@section('title', ucfirst($categoryName))
@section('page-title', ucfirst($categoryName))

@push('styles')
<style>
    .page-header {
        background: linear-gradient(135deg, #D3D3FF, #B8B8FF);
        color: #333;
        border-radius: 12px;
        padding: 32px;
        margin-bottom: 32px;
        box-shadow: 0 4px 12px rgba(211, 211, 255, 0.3);
    }

    .page-header h1 {
        font-size: 32px;
        margin-bottom: 8px;
        font-weight: 700;
    }

    .page-header p {
        font-size: 16px;
        opacity: 0.8;
    }

    .category-info {
        background: white;
        padding: 24px;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        margin-bottom: 32px;
    }

    .category-info h3 {
        font-size: 18px;
        margin-bottom: 12px;
        color: #333;
    }

    .category-stats {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
        gap: 16px;
    }

    .category-stat {
        text-align: center;
        padding: 16px;
        background: linear-gradient(135deg, #D3D3FF, #B8B8FF);
        border-radius: 10px;
    }

    .category-stat-value {
        font-size: 32px;
        font-weight: 700;
        color: #333;
        margin-bottom: 4px;
    }

    .category-stat-label {
        font-size: 14px;
        color: #555;
    }

    .rooms-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(120px, 1fr));
        gap: 16px;
    }

    .room-card {
        background: white;
        padding: 20px;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        text-align: center;
        transition: all 0.3s;
        cursor: pointer;
        text-decoration: none;
        color: inherit;
    }

    .room-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 4px 16px rgba(211, 211, 255, 0.4);
        background: linear-gradient(135deg, #D3D3FF, #B8B8FF);
    }

    .room-icon {
        font-size: 32px;
        color: #9494E8;
        margin-bottom: 12px;
    }

    .room-number {
        font-size: 24px;
        font-weight: 700;
        color: #333;
        margin-bottom: 4px;
    }

    .room-label {
        font-size: 12px;
        color: #666;
    }

    .back-button {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 12px 24px;
        background: linear-gradient(135deg, #D3D3FF, #B8B8FF);
        color: #333;
        text-decoration: none;
        border-radius: 10px;
        font-weight: 600;
        margin-bottom: 24px;
        transition: all 0.3s;
    }

    .back-button:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(211, 211, 255, 0.5);
    }
</style>
@endpush

@section('content')
    <!-- Back Button -->
    <a href="{{ route('hirbc.dashboard') }}" class="back-button">
        <i class="fas fa-arrow-left"></i>
        <span>Back to Dashboard</span>
    </a>

    <!-- Page Header -->
    <div class="page-header">
        <h1><i class="fas fa-{{ $category === 'standard' ? 'bed' : 'crown' }}"></i> {{ $categoryName }}</h1>
        <p>View all rooms in this category</p>
    </div>

    <!-- Category Info -->
    <div class="category-info">
        <h3><i class="fas fa-info-circle"></i> Category Statistics</h3>
        <div class="category-stats">
            <div class="category-stat">
                <div class="category-stat-value">{{ count($rooms) }}</div>
                <div class="category-stat-label">Total Rooms</div>
            </div>
            <div class="category-stat">
                <div class="category-stat-value">{{ $category === 'standard' ? '129' : '10' }}</div>
                <div class="category-stat-label">Configured</div>
            </div>
        </div>
    </div>

    <!-- Rooms Grid -->
    <div class="rooms-grid">
        @foreach($rooms as $room)
            <a href="{{ route('hirbc.rooms.matrix', ['category' => $category, 'room' => $room]) }}" class="room-card">
                <div class="room-icon">
                    <i class="fas fa-door-open"></i>
                </div>
                <div class="room-number">{{ $room }}</div>
                <div class="room-label">View Details</div>
            </a>
        @endforeach
    </div>
@endsection