@extends('layouts.hirbc')

@section('title', 'Complimentary Report - HIRBC')

@push('styles')
<style>
    /* ===== STICKY HEADER WITH FILTER & STATS ===== */
    .report-sticky-header {
        position: sticky;
        top: 70px;
        z-index: 100;
        background: white;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        border-radius: 12px;
        margin-bottom: 24px;
    }

    .header-content {
        background: linear-gradient(135deg, #D3D3FF, #B8B8FF);
        color: #333;
        border-radius: 12px 12px 0 0;
        padding: 24px 32px;
    }

    .header-top {
        display: flex;
        justify-content: space-between;
        align-items: start;
        margin-bottom: 20px;
    }

    .header-title h2 {
        font-size: 28px;
        margin-bottom: 4px;
        font-weight: 700;
    }

    .header-title p {
        font-size: 14px;
        opacity: 0.85;
    }

    .header-filter {
        display: flex;
        gap: 12px;
        align-items: center;
        background: rgba(255, 255, 255, 0.25);
        padding: 12px 16px;
        border-radius: 8px;
        backdrop-filter: blur(10px);
    }

    .header-filter label {
        font-size: 13px;
        font-weight: 600;
        margin-right: 8px;
        white-space: nowrap;
    }

    .header-filter select {
        padding: 8px 16px;
        border: 2px solid rgba(255, 255, 255, 0.4);
        border-radius: 6px;
        font-size: 13px;
        background: white;
        color: #333;
        min-width: 150px;
        font-weight: 600;
    }

    .header-filter select:focus {
        outline: none;
        border-color: white;
    }

    .btn-header {
        padding: 8px 20px;
        border: none;
        border-radius: 6px;
        font-weight: 600;
        cursor: pointer;
        font-size: 13px;
        transition: all 0.3s;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .btn-export {
        background: #28a745;
        color: white;
    }

    .btn-export:hover {
        background: #218838;
        transform: translateY(-2px);
    }

    /* ===== STICKY STATS BAR ===== */
    .stats-bar {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 1px;
        background: #e0e0e0;
        border-radius: 0 0 12px 12px;
        overflow: hidden;
    }

    .stat-item {
        background: white;
        padding: 16px 20px;
        text-align: center;
    }

    .stat-item:first-child {
        border-radius: 0 0 0 12px;
    }

    .stat-item:last-child {
        border-radius: 0 0 12px 0;
    }

    .stat-label {
        font-size: 11px;
        color: #6c757d;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-bottom: 6px;
        font-weight: 600;
    }

    .stat-value {
        font-size: 24px;
        font-weight: 700;
        color: #9494E8;
    }

    /* ===== MATRIX TABLE WITH STICKY HEADER ===== */
    .matrix-container {
        background: white;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        overflow: hidden;
    }

    .matrix-scroll-wrapper {
        overflow: auto;
        max-height: calc(100vh - 400px);
        position: relative;
    }

    .matrix-table {
        width: 100%;
        border-collapse: collapse;
        font-size: 13px;
        min-width: 1000px;
    }

    .matrix-table thead {
        position: sticky;
        top: 0;
        z-index: 10;
    }

    .matrix-table th {
        background: #D3D3FF;
        color: #333;
        padding: 12px 8px;
        text-align: center;
        font-weight: 600;
        border: 1px solid #B8B8FF;
        white-space: nowrap;
    }

    .matrix-table th:not(:first-child) {
        width: 80px;
        min-width: 80px;
        max-width: 80px;
    }

    .matrix-table th:first-child {
        position: sticky;
        left: 0;
        z-index: 11;
        min-width: 140px;
        max-width: 140px;
        width: 140px;
        text-align: left;
        padding-left: 20px;
    }

    .matrix-table td {
        padding: 12px 8px;
        text-align: center;
        border: 1px solid #e0e0e0;
    }

    .matrix-table td:not(.room-cell) {
        width: 80px;
        min-width: 80px;
        max-width: 80px;
    }

    .matrix-table tbody tr:hover {
        background: #f8f9fa;
    }

    .matrix-table td.room-cell {
        position: sticky;
        left: 0;
        background: #f8f9fa;
        font-weight: 600;
        text-align: left;
        padding-left: 20px;
        z-index: 9;
        border-right: 2px solid #D3D3FF;
        width: 140px;
        min-width: 140px;
        max-width: 140px;
    }

    .matrix-table tbody tr:hover td.room-cell {
        background: #F0F0FF;
        color: #7C7CFF;
    }

    .matrix-table td.complimentary {
        background: #d1ecf1;
        color: #0c5460;
        font-weight: 600;
    }

    .matrix-table td.complimentary i {
        color: #17a2b8;
        font-size: 16px;
    }

    .matrix-table td.no-data {
        background: #f8f9fa;
        color: #dee2e6;
        font-weight: 600;
    }

    /* ===== EMPTY STATE ===== */
    .empty-state {
        text-align: center;
        padding: 80px 20px;
        color: #6c757d;
    }

    .empty-state i {
        font-size: 64px;
        margin-bottom: 20px;
        color: #9494E8;
    }

    .empty-state h3 {
        font-size: 20px;
        margin-bottom: 8px;
        color: #495057;
    }

    .empty-state p {
        font-size: 14px;
    }
</style>
@endpush

@section('content')
    @php
        // Process data
        if($month === 'all') {
            $rooms = [];
            $monthlyCount = [];
            
            foreach($complimentaryData as $monthName => $data) {
                foreach($data as $record) {
                    $rooms[$record->Room] = true;
                    if(!isset($monthlyCount[$record->Room][$monthName])) {
                        $monthlyCount[$record->Room][$monthName] = 0;
                    }
                    $monthlyCount[$record->Room][$monthName]++;
                }
            }
            
            $rooms = array_keys($rooms);
            sort($rooms);
            
            $totalDays = 0;
            foreach($monthlyCount as $roomData) {
                $totalDays += array_sum($roomData);
            }
            
        } else {
            $rooms = [];
            $dailyData = [];
            
            foreach($complimentaryData as $record) {
                $rooms[$record->Room] = true;
                $day = (int) date('d', strtotime($record->Posting_Date));
                $dailyData[$record->Room][$day] = true;
            }
            
            $rooms = array_keys($rooms);
            sort($rooms);
            
            $totalDays = count($complimentaryData);
        }
    @endphp

    <!-- STICKY HEADER: Title + Filter + Stats -->
    <div class="report-sticky-header">
        <!-- Header Content with Filter -->
        <div class="header-content">
            <div class="header-top">
                <div class="header-title">
                    <h2><i class="fas fa-gift"></i> Complimentary Report</h2>
                    <p>Track and monitor complimentary room usage by room and date</p>
                </div>

                <form method="GET" action="{{ route('hirbc.reports.complimentary') }}" class="header-filter">
                    <label for="monthFilter"><i class="fas fa-calendar-alt"></i> Period:</label>
                    <select id="monthFilter" name="month" onchange="this.form.submit()">
                        <option value="all" {{ $month === 'all' ? 'selected' : '' }}>All Months</option>
                        <option value="january" {{ $month === 'january' ? 'selected' : '' }}>January</option>
                        <option value="february" {{ $month === 'february' ? 'selected' : '' }}>February</option>
                        <option value="march" {{ $month === 'march' ? 'selected' : '' }}>March</option>
                        <option value="april" {{ $month === 'april' ? 'selected' : '' }}>April</option>
                        <option value="may" {{ $month === 'may' ? 'selected' : '' }}>May</option>
                        <option value="june" {{ $month === 'june' ? 'selected' : '' }}>June</option>
                        <option value="july" {{ $month === 'july' ? 'selected' : '' }}>July</option>
                        <option value="august" {{ $month === 'august' ? 'selected' : '' }}>August</option>
                        <option value="september" {{ $month === 'september' ? 'selected' : '' }}>September</option>
                        <option value="october" {{ $month === 'october' ? 'selected' : '' }}>October</option>
                        <option value="november" {{ $month === 'november' ? 'selected' : '' }}>November</option>
                        <option value="december" {{ $month === 'december' ? 'selected' : '' }}>December</option>
                    </select>

                    <button type="button" onclick="exportToExcel()" class="btn-header btn-export">
                        <i class="fas fa-file-excel"></i> Export
                    </button>
                </form>
            </div>
        </div>

        <!-- Stats Bar -->
        <div class="stats-bar">
            <div class="stat-item">
                <div class="stat-label"><i class="fas fa-calendar-check"></i> Total Days</div>
                <div class="stat-value">{{ number_format($totalDays) }}</div>
            </div>

            <div class="stat-item">
                <div class="stat-label"><i class="fas fa-door-open"></i> Rooms</div>
                <div class="stat-value">{{ number_format(count($rooms)) }}</div>
            </div>

            <div class="stat-item">
                <div class="stat-label"><i class="fas fa-percentage"></i> Usage Rate</div>
                <div class="stat-value">{{ count($rooms) > 0 ? number_format(($totalDays / (count($rooms) * 31)) * 100, 1) : 0 }}%</div>
            </div>

            <div class="stat-item">
                <div class="stat-label"><i class="fas fa-chart-line"></i> Period</div>
                <div class="stat-value" style="font-size: 16px;">{{ $month === 'all' ? 'All' : ucfirst($month) }}</div>
            </div>
        </div>
    </div>

    <!-- MATRIX TABLE -->
    <div class="matrix-container">
        @if(count($rooms) === 0)
            <div class="empty-state">
                <i class="fas fa-inbox"></i>
                <h3>No Complimentary Data</h3>
                <p>No complimentary data found for this period.</p>
            </div>
        @else
            <div class="matrix-scroll-wrapper">
                <table class="matrix-table">
                    <thead>
                        <tr>
                            <th>Room</th>
                            @if($month === 'all')
                                @foreach(['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'] as $monthName)
                                    <th>{{ $monthName }}</th>
                                @endforeach
                            @else
                                @for($day = 1; $day <= 31; $day++)
                                    <th>{{ $day }}</th>
                                @endfor
                            @endif
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($rooms as $room)
                            <tr>
                                <td class="room-cell">Room {{ $room }}</td>
                                @if($month === 'all')
                                    @foreach(['january', 'february', 'march', 'april', 'may', 'june', 'july', 'august', 'september', 'october', 'november', 'december'] as $monthName)
                                        @php
                                            $count = $monthlyCount[$room][$monthName] ?? 0;
                                        @endphp
                                        @if($count > 0)
                                            <td class="complimentary">{{ $count }}</td>
                                        @else
                                            <td class="no-data">-</td>
                                        @endif
                                    @endforeach
                                @else
                                    @for($day = 1; $day <= 31; $day++)
                                        @if(isset($dailyData[$room][$day]))
                                            <td class="complimentary"><i class="fas fa-check"></i></td>
                                        @else
                                            <td class="no-data">-</td>
                                        @endif
                                    @endfor
                                @endif
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endif
    </div>
@endsection

@push('scripts')
<script>
    function exportToExcel() {
        alert('Excel export feature coming soon!');
    }
</script>
@endpush