<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('ooo_regent', function (Blueprint $table) {
            // Add End_Date column after Completed_On
            $table->date('End_Date')->nullable()->after('Completed_On');
            
            // Add additional missing columns to match HIRBND structure
            $table->string('Label', 50)->nullable()->after('End_Date');
            $table->string('Reason_Code', 50)->nullable()->after('Label');
            $table->string('Return_Status', 50)->nullable()->after('Repair_Remark');
            $table->string('Room_Status', 50)->nullable()->after('Room_No');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('ooo_regent', function (Blueprint $table) {
            $table->dropColumn([
                'End_Date',
                'Label',
                'Reason_Code',
                'Return_Status',
                'Room_Status'
            ]);
        });
    }
};