<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        $months = [
            'january', 'february', 'march', 'april', 'may', 'june',
            'july', 'august', 'september', 'october', 'november', 'december'
        ];

        foreach ($months as $month) {
            $tableName = "{$month}_hirbnd";
            
            // Check if table exists
            if (Schema::hasTable($tableName)) {
                // ALTER column type menggunakan raw SQL
                DB::statement("ALTER TABLE `{$tableName}` MODIFY COLUMN `Amount_1` DECIMAL(15,2) NULL");
                
                echo "✅ Table {$tableName} - Amount_1 column altered to DECIMAL(15,2)\n";
            }
        }
    }

    public function down(): void
    {
        $months = [
            'january', 'february', 'march', 'april', 'may', 'june',
            'july', 'august', 'september', 'october', 'november', 'december'
        ];

        foreach ($months as $month) {
            $tableName = "{$month}_hirbnd";
            
            if (Schema::hasTable($tableName)) {
                DB::statement("ALTER TABLE `{$tableName}` MODIFY COLUMN `Amount_1` INT NULL");
            }
        }
    }
};