<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        $months = [
            'january', 'february', 'march', 'april', 'may', 'june',
            'july', 'august', 'september', 'october', 'november', 'december'
        ];

        foreach ($months as $month) {
            $tableName = "{$month}_hirbnd";
            
            // Drop if exists
            if (Schema::hasTable($tableName)) {
                Schema::dropIfExists($tableName);
            }

            // ✅ FIX: Pass $month ke dalam closure dengan 'use'
            Schema::create($tableName, function (Blueprint $table) use ($month) {
                $table->id();
                $table->string('odata_etag', 255)->nullable();
                
                // ✅ FIX: Amount_1 harus DECIMAL untuk nilai besar!
                $table->decimal('Amount_1', 15, 2)->nullable();
                
                $table->string('Business_Unit', 50)->nullable();
                $table->string('Guest_Full_Name', 255)->nullable();
                $table->string('Interval', 10)->nullable();
                $table->string('Market_Code', 100)->nullable();
                $table->string('No_Asset', 50)->nullable();
                $table->date('Posting_Date')->nullable();
                $table->string('Room', 50)->nullable();
                $table->string('RoomType', 50)->nullable();
                $table->integer('Row_No')->nullable();
                $table->string('TRX_Code', 50)->nullable();
                $table->string('TRX_Desc', 255)->nullable();
                $table->timestamps();

                // Indexes untuk performance
                $table->index('Room');
                $table->index('RoomType');
                $table->index('Posting_Date');
                $table->index('Market_Code');
                $table->index('TRX_Code');
                $table->index(['RoomType', 'Room']); // Composite index untuk query WHERE RoomType

                // ✅ FIX: Sekarang $month bisa diakses!
                $table->unique(['Room', 'Posting_Date', 'TRX_Code', 'Row_No'], "unique_{$month}");
            });
        }
    }

    public function down(): void
    {
        $months = [
            'january', 'february', 'march', 'april', 'may', 'june',
            'july', 'august', 'september', 'october', 'november', 'december'
        ];

        foreach ($months as $month) {
            Schema::dropIfExists("{$month}_hirbnd");
        }
    }
};