<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('ooo_hirbnd', function (Blueprint $table) {
            $table->id();
            $table->string('odata_etag')->nullable();
            
            // Kolom sesuai CSV Business Central
            $table->integer('AuxiliaryIndex1')->nullable();
            $table->date('Begin_Date')->nullable();
            $table->string('Business_Unit', 50)->nullable();
            $table->date('Completed_On')->nullable(); // PERHATIKAN: Completed_On (ada 'd')
            $table->date('End_Date')->nullable();
            $table->string('Label', 50)->nullable();
            $table->string('Reason_Code', 50)->nullable();
            $table->string('Reason_Desc', 255)->nullable();
            $table->text('Repair_Remark')->nullable();
            $table->string('Return_Status', 50)->nullable();
            $table->string('Room_Class', 50)->nullable();
            $table->string('Room_No', 50)->nullable(); // Ini Room Number
            $table->string('Room_Status', 50)->nullable();
            
            $table->timestamps();

            // Indexes untuk performa
            $table->index('Room_No');
            $table->index('Completed_On');
            $table->index('Room_Status');
            $table->index(['Business_Unit', 'Completed_On']);
            $table->index('Reason_Code');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ooo_hirbnd');
    }
};