<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Regent Room Types Configuration
    |--------------------------------------------------------------------------
    */

    'room_types' => [
        // Main menu items
        'penthouse' => [
            'name' => 'Penthouse',
            'is_main_menu' => true,
            'rooms' => ['3501', '5501'],
        ],
        'beach_villa' => [
            'name' => 'Beach Villa',
            'is_main_menu' => true,
            'rooms' => ['7101', '7102', '7103'],
        ],
        'padi_villa' => [
            'name' => 'Padi Villa',
            'is_main_menu' => true,
            'rooms' => ['6101', '6102', '6103', '6104'],
        ],
        
        // ✅ UPDATED: Corner Suite with Submenu (like Suite)
        'corner_suite' => [
            'name' => 'Corner Suite',
            'has_submenu' => true,
            'submenu' => [
                'corner_gw_c' => [
                    'name' => 'Corner Suite GW C',
                    'rooms' => ['3106', '3206', '3306'],
                ],
                'corner_gw_d' => [
                    'name' => 'Corner Suite GW D',
                    'rooms' => ['5105', '5205', '5305'],
                ],
            ],
        ],
        
        // Suite menu with sub-menus
        'suite' => [
            'name' => 'Suite',
            'has_submenu' => true,
            'submenu' => [
                'suite_gw_a' => [
                    'name' => 'Suite GW A',
                    'rooms' => [
                        '1101', '1102', '1103', '1105', '1106', '1107', '1108', '1109', '1110', '1111', '1112',
                        '1201', '1202', '1203', '1205', '1206', '1207', '1208', '1209', '1210', '1211', '1212', '1214', '1215', '1216',
                        '1301', '1302', '1303', '1305', '1306', '1307', '1308', '1309', '1310', '1311', '1312', '1314', '1315', '1316',
                        '1501', '1502', '1503', '1505', '1506', '1507', '1508', '1509', '1510', '1511', '1512', '1514', '1515', '1516'
                    ],
                ],
                'suite_gw_b' => [
                    'name' => 'Suite GW B',
                    'rooms' => [
                        '2101', '2102', '2103', '2105', '2106', '2107', '2108',
                        '2201', '2202', '2203', '2205', '2206', '2207', '2208',
                        '2301', '2302', '2303', '2305', '2306', '2307', '2308'
                    ],
                ],
                'suite_gw_c' => [
                    'name' => 'Suite GW C',
                    'rooms' => [
                        '3101', '3102', '3103', '3105', '3107', '3108', '3109', '3110', '3111', '3112',
                        '3201', '3202', '3203', '3205', '3207', '3208', '3209', '3210', '3211', '3212',
                        '3301', '3302', '3303', '3305', '3307', '3308', '3309', '3310', '3311', '3312'
                    ],
                ],
                'suite_gw_d' => [
                    'name' => 'Suite GW D',
                    'rooms' => [
                        '5101', '5102', '5103', '5106', '5107', '5108', '5109', '5110',
                        '5201', '5202', '5203', '5206', '5207', '5208', '5209', '5210',
                        '5301', '5302', '5303', '5306', '5307', '5308', '5309', '5310'
                    ],
                ],
            ],
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Business Central API Configuration for Regent
    |--------------------------------------------------------------------------
    */

    'api' => [
        'base_url' => 'https://api.businesscentral.dynamics.com/v2.0/5f138de3-8774-4114-8fc4-1a93dfc31a3a/Production/ODataV4',
        'company' => "Company('PT.CI LIVE')",
        'business_unit' => 'RBC',
        'endpoints' => [
            'room_data' => '/Room1',
            'ooo_data' => '/OOO',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Revenue TRX Codes (Same as HIRBND)
    |--------------------------------------------------------------------------
    */

    'revenue_trx_codes' => [
        '1000', '1001', '1002', '1003', '1004', '1005', '1006', '1007', '1008', '1009',
        '1010', '1011', '1012', '1013', '1014', '1015', '1016', '1017', '1018', '1019',
        '1020', '1030', '1040', '1050', '1060', '1070', '1075', '1080', '1081', '1082',
        '1083', '1084', '1085', '1090', '1091', '1095'
    ],

    /*
    |--------------------------------------------------------------------------
    | Total Rooms
    |--------------------------------------------------------------------------
    */

    'total_rooms' => 169, // Total all rooms in Regent
];