<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Base URL & Timeout
    |--------------------------------------------------------------------------
    */
    'base_url' => env('BC_BASE_URL', 'https://api.businesscentral.dynamics.com/v2.0'),
    'timeout' => env('BC_API_TIMEOUT', 0), // 0 = unlimited
    
    /*
    |--------------------------------------------------------------------------
    | OAuth Configuration
    |--------------------------------------------------------------------------
    */
    'oauth' => [
        'token_url' => env('AZURE_TOKEN_URL'),
        'client_id' => env('AZURE_CLIENT_ID'),
        'client_secret' => env('AZURE_CLIENT_SECRET'),
        'scope' => env('AZURE_SCOPE', 'https://api.businesscentral.dynamics.com/.default'),
    ],

    /*
    |--------------------------------------------------------------------------
    | HIRBC API Configuration
    |--------------------------------------------------------------------------
    */
    
    'hirbc' => [
        'business_unit' => 'HIRBC',
        'endpoints' => [
            'room' => "5f138de3-8774-4114-8fc4-1a93dfc31a3a/Production/ODataV4/Company('PT.CI LIVE')/Room1?\$filter=Business_Unit eq 'HIRBC'",
            'ooo' => "5f138de3-8774-4114-8fc4-1a93dfc31a3a/Production/ODataV4/Company('PT.CI LIVE')/OOO?\$filter=Business_Unit eq 'HIRBC'"
        ]
    ],

    /*
    |--------------------------------------------------------------------------
    | Batch Size Configuration
    |--------------------------------------------------------------------------
    */
    'batch_size' => [
        'room_data' => 500,
        'ooo_data' => 100,
    ],

    /*
    |--------------------------------------------------------------------------
    | HIRBND Configuration
    |--------------------------------------------------------------------------
    */
    'hirbnd' => [
        'company' => env('BC_COMPANY', 'TBI%202023%20NEW'),
        
        'endpoints' => [
            'room' => 'https://api.businesscentral.dynamics.com/v2.0/5f138de3-8774-4114-8fc4-1a93dfc31a3a/Production/ODataV4/Company(\'TBI%202023%20NEW\')/Room',
            'ooo' => 'https://api.businesscentral.dynamics.com/v2.0/5f138de3-8774-4114-8fc4-1a93dfc31a3a/Production/ODataV4/Company(\'TBI%202023%20NEW\')/OOO',
        ],

        'tables' => [
            'monthly' => [
                'january' => 'january_hirbnd',
                'february' => 'february_hirbnd',
                'march' => 'march_hirbnd',
                'april' => 'april_hirbnd',
                'may' => 'may_hirbnd',
                'june' => 'june_hirbnd',
                'july' => 'july_hirbnd',
                'august' => 'august_hirbnd',
                'september' => 'september_hirbnd',
                'october' => 'october_hirbnd',
                'november' => 'november_hirbnd',
                'december' => 'december_hirbnd',
            ],
            'ooo' => 'ooo_hirbnd',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Room Types Configuration
    |--------------------------------------------------------------------------
    */
    'room_types' => [
        'standard' => [
            'KPLN' => '1 King Bed Standard Pool Access',
            'TPLN' => '2 Twin Beds Standard Pool Access',
            'TOTN' => '2 Twin Beds Standard',
            'KOTN' => '1 King Bed Standard',
            'KVUN' => '1 King Bed Standard Ocean Front',
            'TFTN' => '2 Twin Beds Standard Pool View',
            'TVUN' => '2 Twin Beds Standard Ocean Front',
            'OARN' => 'Family Connecting Pool View',
            'KWCN' => '1 King Bed Accessible',
            'KFTN' => '1 King Bed Standard Pool View',
            'OFCN' => 'Family Connecting Room',
            'TLON' => '2 Twin Beds Standard Ocean View',
            'KLON' => '1 King Bed Standard Ocean View',
        ],
        'suite' => [
            'XSTN' => '1 King Bed Premium',
            'XKSN' => 'Family Adventure Suite Sea View',
            'XVUN' => '1 King Bed Premium Sea View',
            'KKSN' => 'Kids Adventure Suite',
            'XAON' => 'Family Adventure Suite Garden View',
            'XFTN' => '1 King Bed 1 Bedroom Suite Sea View',
        ],
    ],

    /*
|--------------------------------------------------------------------------
| Revenue Report TRX Codes
|--------------------------------------------------------------------------
*/
'revenue_trx_codes' => [
    '1000', '1001', '1002', '1010', '1011', '1020', '1021', '1030', '1031',
    '1040', '1041', '1050', '1051', '1060', '1061', '1070', '1071', '1072',
    '1075', '1076', '1080', '1081', '1082', '1083', '1084', '1085', '1086',
    '1087', '1088', '1089', '1090', '1091', '1092', '1093', '1094', '1095',
],

    /*
    |--------------------------------------------------------------------------
    | Market Codes Configuration
    |--------------------------------------------------------------------------
    */
    'market_codes' => [
        'house_use' => 'House Use - H',
        'complimentary' => 'Complimentary - N',
    ],

    /*
    |--------------------------------------------------------------------------
    | Companies Configuration
    |--------------------------------------------------------------------------
    */
    'companies' => [
        'hirbnd' => [
            'name' => 'Holiday Inn Resort Bali Nusa Dua',
            'code' => 'HIRBND',
            'status' => 'active',
            'api_company' => 'TBI%202023%20NEW',
        ],
        'regent' => [
            'name' => 'The Regent Bali',
            'code' => 'REGENT',
            'status' => 'maintenance',
        ],
        'hirbc' => [
            'name' => 'Holiday Inn Resort Bali Canggu',
            'code' => 'HIRBC',
            'status' => 'maintenance',
        ],
    ],
];