<?php

namespace App\Models\Hirbnd;

use Illuminate\Database\Eloquent\Model;

class MonthlyRoom extends Model
{
    protected $table;

    protected $fillable = [
        'odata_etag',
        'Amount_1',
        'Business_Unit',
        'Guest_Full_Name',
        'Interval',
        'Market_Code',
        'No_Asset',
        'Posting_Date',
        'Room',
        'RoomType',
        'Row_No',
        'TRX_Code',
        'TRX_Desc',
    ];

    protected $casts = [
        'Amount_1' => 'decimal:2',
        'Posting_Date' => 'date',
        'Row_No' => 'integer',
    ];

    public function setTable($tableName)
    {
        $this->table = $tableName;
        return $this;
    }

    public static function forMonth(string $month)
    {
        $instance = new static;
        $tableName = config("businesscentral.hirbnd.tables.monthly.{$month}");
        
        if (!$tableName) {
            throw new \Exception("Invalid month: {$month}");
        }
        
        $instance->setTable($tableName);
        return $instance;
    }

    public function scopeByRoom($query, string $room)
    {
        return $query->where('Room', $room);
    }

    public function scopeByRoomType($query, string $roomType)
    {
        return $query->where('RoomType', $roomType);
    }

    public function scopeByMarketCode($query, string $marketCode)
    {
        return $query->where('Market_Code', $marketCode);
    }

    public function scopeByTrxCode($query, array $trxCodes)
    {
        return $query->whereIn('TRX_Code', $trxCodes);
    }

    public function scopeWithAmount($query)
    {
        return $query->where('Amount_1', '>', 0);
    }

    public function scopeExcludeMarketCodes($query, array $marketCodes)
    {
        return $query->whereNotIn('Market_Code', $marketCodes);
    }
}