<?php

namespace App\Models\Hirbc;

use Illuminate\Database\Eloquent\Model;

class OooRoom extends Model
{
    protected $table = 'ooo_hirbc';
    
    protected $fillable = [
        'Business_Unit',
        'AuxiliaryIndex1',
        'Begin_Date',
        'Completed_On',
        'Room_No',
        'Repair_Remark'
    ];

    protected $casts = [
        'Begin_Date' => 'date',
        'Completed_On' => 'date',
        'AuxiliaryIndex1' => 'integer'
    ];

    /**
     * Scope untuk OOO yang masih aktif (Completed_On = 0001-01-01)
     */
    public function scopeActive($query)
    {
        return $query->where('Completed_On', '0001-01-01');
    }

    /**
     * Scope untuk OOO yang sudah selesai
     */
    public function scopeCompleted($query)
    {
        return $query->where('Completed_On', '!=', '0001-01-01');
    }

    /**
     * Scope untuk filter by room
     */
    public function scopeForRoom($query, $roomNo)
    {
        return $query->where('Room_No', $roomNo);
    }

    /**
     * Get days OOO (from Begin_Date to now)
     */
    public function getDaysOooAttribute()
    {
        if (!$this->Begin_Date || $this->Begin_Date->format('Y-m-d') === '0001-01-01') {
            return 0;
        }

        return $this->Begin_Date->diffInDays(now());
    }

    /**
     * Check if OOO is active
     */
    public function getIsActiveAttribute()
    {
        return $this->Completed_On && $this->Completed_On->format('Y-m-d') === '0001-01-01';
    }
}