<?php

namespace App\Http\Controllers\Regent;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Models\Regent\OooRegent;

class DashboardController extends Controller
{
    public function index()
    {
        // Get data counts for all months
        $months = [
            'january', 'february', 'march', 'april', 'may', 'june',
            'july', 'august', 'september', 'october', 'november', 'december'
        ];

        $monthlyData = [];
        $totalRecords = 0;

        foreach ($months as $month) {
            $tableName = "{$month}_regent";
            $count = DB::table($tableName)->count();
            $monthlyData[$month] = $count;
            $totalRecords += $count;
        }

        // Get OOO count
        $oooCount = OooRegent::where('Completed_On', '0001-01-01')->count();

        // Get statistics
        $stats = [
            'total_records' => $totalRecords,
            'ooo_count' => $oooCount,
            'total_rooms' => config('regent.total_rooms'),
            'ooo_percentage' => config('regent.total_rooms') > 0 
                ? round(($oooCount / config('regent.total_rooms')) * 100, 1) 
                : 0,
        ];

        return view('regent.dashboard', compact('monthlyData', 'stats'));
    }
}