@extends('layouts.app')
@section('title','Sandbox – Employees')
@section('page-title','Detail Karyawan (Sandbox)')

@section('content')
@php
    $first  = data_get($emp, 'personal.first_name', '');
    $last   = data_get($emp, 'personal.last_name', '');
    $name   = trim($first.' '.$last) ?: '—';
    $email  = data_get($emp, 'personal.email', '—');
    $uid    = data_get($emp, 'user_id', '—');

    $avatar = data_get($emp, 'personal.avatar'); // URL avatar
    // Ambil nama file dari URL (optional)
    $avatarPath = $avatar ? parse_url($avatar, PHP_URL_PATH) : null;
    $avatarName = $avatarPath ? basename($avatarPath) : null;

    $employment = data_get($emp, 'employment', []);
    $isActive   = (data_get($employment, 'status') === 'Active');

    // Inisial fallback
    $initials = strtoupper(mb_substr($first ?: 'N', 0, 1) . mb_substr($last ?: '', 0, 1));
@endphp

<div class="max-w-6xl mx-auto space-y-6">

    {{-- Header --}}
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 px-5 py-4 flex items-center justify-between">
        <div>
            <h2 class="text-lg font-semibold text-gray-900">Detail Karyawan – Sandbox</h2>
            <p class="text-sm text-gray-500">Informasi personal & employment dari API Mekari Talenta.</p>
        </div>
        <div class="flex items-center gap-2">
            <a href="{{ route('talenta.sandbox.employees.index') }}"
               class="inline-flex items-center gap-1 px-3 py-2 text-sm rounded-xl border border-gray-200 hover:bg-gray-50">
                ← Kembali
            </a>
            <a href="{{ route('talenta.sandbox.employees.edit',$uid) }}"
               class="inline-flex items-center gap-1 px-3 py-2 text-sm rounded-xl border border-amber-300 text-amber-700 bg-amber-50 hover:bg-amber-100">
                ✏️ Edit
            </a>
            <form action="{{ route('talenta.sandbox.employees.destroy',$uid) }}" method="POST"
                  onsubmit="return confirm('Yakin hapus karyawan ini?')">
                @csrf @method('DELETE')
                <button type="submit"
                        class="inline-flex items-center gap-1 px-3 py-2 text-sm rounded-xl border border-red-300 text-red-700 bg-red-50 hover:bg-red-100">
                    🗑️ Hapus
                </button>
            </form>
        </div>
    </div>

    {{-- Profile Card --}}
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-5">
        <div class="flex flex-col md:flex-row gap-5 md:gap-8 items-start">
            {{-- Avatar + Preview --}}
            <div class="shrink-0">
                @if($avatar)
                    {{-- Foto kecil (klik untuk preview modal) --}}
                    <div class="relative group cursor-pointer" onclick="openAvatarModal('{{ $avatar }}')">
                        <img src="{{ $avatar }}" alt="Foto {{ $name }}"
                             class="h-32 w-32 rounded-full object-cover ring-4 ring-gray-100 shadow-sm group-hover:opacity-90 transition">
                        <span class="pointer-events-none absolute bottom-1 left-1 right-1 mx-auto text-[10px] bg-black/60 text-white rounded px-1 py-0.5 text-center opacity-0 group-hover:opacity-100 transition">
                            Klik untuk perbesar
                        </span>
                    </div>
                    @if($avatarName)
                        <div class="mt-2 text-xs text-gray-500">
                            Nama file: <span class="font-medium">{{ $avatarName }}</span>
                        </div>
                    @endif
                @else
                    {{-- Fallback inisial --}}
                    <div class="h-32 w-32 rounded-full bg-gradient-to-br from-gray-200 to-gray-100 flex items-center justify-center ring-4 ring-gray-100 shadow-sm">
                        <span class="text-3xl font-semibold text-gray-600">{{ $initials }}</span>
                    </div>
                    <div class="mt-2 text-xs text-gray-500">Foto belum tersedia</div>
                @endif
            </div>

            {{-- Identity --}}
            <div class="flex-1 w-full">
                <div class="flex flex-wrap items-center gap-2">
                    <h3 class="text-xl font-semibold text-gray-900">{{ $name }}</h3>
                    @if($isActive)
                        <span class="px-2 py-1 text-xs rounded-full bg-green-100 text-green-700">Active</span>
                    @else
                        <span class="px-2 py-1 text-xs rounded-full bg-gray-100 text-gray-600">
                            {{ data_get($employment,'status','-') }}
                        </span>
                    @endif
                </div>
                <div class="mt-2 grid grid-cols-1 md:grid-cols-2 gap-3 text-sm">
                    <div><span class="text-gray-500">User ID:</span> <span class="font-medium">{{ $uid }}</span></div>
                    <div><span class="text-gray-500">Employee ID:</span> <span class="font-medium">{{ data_get($employment,'employee_id','—') }}</span></div>
                    <div><span class="text-gray-500">Email:</span> <span class="font-medium">{{ $email }}</span></div>
                    <div><span class="text-gray-500">Barcode:</span> <span class="font-medium">{{ data_get($emp,'personal.barcode','—') }}</span></div>
                </div>

                {{-- Personal Meta --}}
                <div class="mt-4 grid grid-cols-1 md:grid-cols-2 gap-3 text-sm">
                    <div><span class="text-gray-500">Gender:</span> <span class="font-medium">{{ data_get($emp,'personal.gender','—') }}</span></div>
                    <div><span class="text-gray-500">Birth:</span>
                        <span class="font-medium">
                            {{ data_get($emp,'personal.birth_place','—') }}, {{ data_get($emp,'personal.birth_date','—') }}
                        </span>
                    </div>
                    <div><span class="text-gray-500">Religion:</span> <span class="font-medium">{{ data_get($emp,'personal.religion','—') }}</span></div>
                    <div><span class="text-gray-500">Marital:</span> <span class="font-medium">{{ data_get($emp,'personal.marital_status','—') }}</span></div>
                </div>
            </div>
        </div>
    </div>

    {{-- Employment Card --}}
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-5">
        <h3 class="font-semibold text-gray-900 mb-4">Employment</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
            <div><span class="text-gray-500">Branch:</span> <span class="font-medium">{{ data_get($employment,'branch','—') }}</span></div>
            <div><span class="text-gray-500">Organization:</span> <span class="font-medium">{{ data_get($employment,'organization_name','—') }}</span></div>
            <div><span class="text-gray-500">Job Position:</span> <span class="font-medium">{{ data_get($employment,'job_position','—') }}</span></div>
            <div><span class="text-gray-500">Job Level:</span> <span class="font-medium">{{ data_get($employment,'job_level','—') }}</span></div>
            <div><span class="text-gray-500">Employment Status:</span> <span class="font-medium">{{ data_get($employment,'employment_status','—') }}</span></div>
            <div><span class="text-gray-500">Join Date:</span> <span class="font-medium">{{ data_get($employment,'join_date','—') }}</span></div>
            <div><span class="text-gray-500">End Date:</span> <span class="font-medium">{{ data_get($employment,'end_date','—') }}</span></div>
            <div><span class="text-gray-500">Resign Date:</span> <span class="font-medium">{{ data_get($employment,'resign_date','—') }}</span></div>
            <div class="md:col-span-2"><span class="text-gray-500">Length of Service:</span> <span class="font-medium">{{ data_get($employment,'length_of_service','—') }}</span></div>
        </div>
    </div>

    {{-- Access Role (opsional) --}}
    @if(data_get($emp,'access_role'))
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-5">
            <h3 class="font-semibold text-gray-900 mb-4">Access Role</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                <div><span class="text-gray-500">Role:</span> <span class="font-medium">{{ data_get($emp,'access_role.role_name','—') }}</span></div>
                <div><span class="text-gray-500">Type:</span> <span class="font-medium">{{ data_get($emp,'access_role.role_type','—') }}</span></div>
            </div>
        </div>
    @endif

    {{-- Debug RAW JSON --}}
    <details class="bg-gray-50 rounded-lg p-4 text-xs text-gray-600">
        <summary class="cursor-pointer font-medium">RAW JSON Response</summary>
        <pre class="mt-2 whitespace-pre-wrap">{{ json_encode($resp ?? [], JSON_PRETTY_PRINT) }}</pre>
    </details>

</div>

{{-- Modal Preview Avatar (tidak download, hanya tampil) --}}
<div id="avatarModal" class="fixed inset-0 bg-black/70 hidden items-center justify-center z-50">
    <div class="relative bg-white rounded-2xl shadow-2xl p-2 md:p-3 max-w-3xl w-[92vw]">
        <button type="button" onclick="closeAvatarModal()"
                class="absolute -top-3 -right-3 md:top-2 md:right-2 h-8 w-8 md:h-9 md:w-9 grid place-items-center rounded-full bg-white text-gray-700 shadow hover:text-red-500">
            ✕
        </button>
        <img id="avatarPreview" src="" alt="Avatar preview"
             class="rounded-xl max-h-[80vh] w-auto mx-auto">
        @if($avatarName)
            <div class="text-center text-xs text-gray-500 mt-2">Pratinjau: <span class="font-medium">{{ $avatarName }}</span></div>
        @endif
    </div>
</div>

{{-- Script modal --}}
<script>
    function openAvatarModal(url) {
        const modal = document.getElementById('avatarModal');
        const img   = document.getElementById('avatarPreview');
        img.src = url;
        modal.classList.remove('hidden');
        modal.classList.add('flex');
    }
    function closeAvatarModal() {
        const modal = document.getElementById('avatarModal');
        const img   = document.getElementById('avatarPreview');
        img.src = '';
        modal.classList.add('hidden');
        modal.classList.remove('flex');
    }

    // Tutup modal kalau klik area gelap di luar gambar
    document.getElementById('avatarModal')?.addEventListener('click', function(e) {
        if (e.target === this) closeAvatarModal();
    });

    // ESC untuk menutup
    window.addEventListener('keydown', function(e){
        if (e.key === 'Escape') closeAvatarModal();
    });
</script>

{{-- SweetAlert flash for SHOW page --}}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', () => {
  @if (session('success'))
    Swal.fire({
      icon: 'success',
      title: 'Berhasil',
      text: @json(session('success')),
      timer: 2000,
      timerProgressBar: true,
      showConfirmButton: false
    });
  @endif

  @if (session('error'))
    Swal.fire({
      icon: 'error',
      title: 'Gagal',
      html: @json(session('error'))
    });
  @endif

  @if ($errors->any())
    Swal.fire({
      icon: 'error',
      title: 'Terjadi Kesalahan',
      html: `{!! '<ul style="text-align:left;margin:0;padding-left:16px">' .
            collect($errors->all())->map(fn($e)=>"<li>".e($e)."</li>")->implode('') .
            '</ul>' !!}`
    });
  @endif
});
</script>
@endsection
