@extends('layouts.app')
@section('title','Sandbox – Employees')
@section('page-title','Data Karyawan (Sandbox)')

@section('content')
<div class="max-w-7xl mx-auto">

    {{-- Header + Search/Actions --}}
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-4 md:p-5 mb-5">
        <div class="flex flex-col md:flex-row md:items-center gap-3 md:gap-4 justify-between">
            <div>
                <h2 class="text-lg font-semibold text-gray-900">Daftar Karyawan (Sandbox)</h2>
                <p class="text-sm text-gray-500">Data diambil dari API Mekari Talenta Sandbox.</p>
            </div>
            <div class="flex items-center gap-2">
                <a href="{{ route('talenta.sandbox.employees.create') }}"
                   class="inline-flex items-center gap-2 px-3 md:px-4 py-2 rounded-xl text-white bg-primary hover:opacity-90">
                    <i class="fas fa-plus"></i>
                    <span>Tambah</span>
                </a>
                <details class="relative">
                    <summary class="list-none inline-flex items-center gap-2 px-3 md:px-4 py-2 rounded-xl border border-gray-200 hover:bg-gray-50 cursor-pointer">
                        <i class="fas fa-sliders-h"></i> <span>Debug</span>
                    </summary>
                    <div class="absolute right-0 mt-2 w-[min(90vw,36rem)] z-10">
                        <div class="bg-white rounded-xl shadow border border-gray-100 p-3">
                            <div class="text-xs text-gray-600 max-h-[50vh] overflow-auto">
                                <pre class="whitespace-pre-wrap">{{ json_encode($resp ?? [], JSON_PRETTY_PRINT) }}</pre>
                            </div>
                        </div>
                    </div>
                </details>
            </div>
        </div>

        {{-- Search bar + limit --}}
        <form method="GET" action="{{ route('talenta.sandbox.employees.index') }}" class="mt-4 grid grid-cols-1 md:grid-cols-3 gap-3">
            <div class="md:col-span-2">
                <div class="relative">
                    <input type="text" name="q" value="{{ request('q') }}" placeholder="Cari nama, email, employee ID..."
                           class="w-full pl-10 pr-3 py-2 rounded-xl border border-gray-300 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary">
                    <span class="absolute left-3 top-1/2 -translate-y-1/2 text-gray-400">
                        <i class="fas fa-search"></i>
                    </span>
                </div>
            </div>
            <div class="flex items-center gap-2">
                <label class="text-sm text-gray-600">Tampilkan</label>
                @php $limit = (int) request('limit', $limit ?? 10); @endphp
                <select name="limit"
                        class="rounded-xl border border-gray-300 px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary">
                    @foreach([10,20,50,100,200] as $opt)
                        <option value="{{ $opt }}" {{ $limit === $opt ? 'selected' : '' }}>{{ $opt }}</option>
                    @endforeach
                </select>
                <button class="px-3 py-2 rounded-xl border border-gray-200 hover:bg-gray-50">
                    Terapkan
                </button>
            </div>
        </form>
    </div>

    {{-- Table --}}
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full text-sm">
                <thead>
                    <tr class="bg-gray-50 text-gray-700">
                        <th class="px-4 py-3 text-left font-semibold w-12">No</th>
                        <th class="px-4 py-3 text-left font-semibold">Nama</th>
                        <th class="px-4 py-3 text-left font-semibold">Branch</th>
                        <th class="px-4 py-3 text-left font-semibold">Employee ID</th>
                        <th class="px-4 py-3 text-left font-semibold">Organization</th>
                        <th class="px-4 py-3 text-left font-semibold">Position</th>
                        <th class="px-4 py-3 text-left font-semibold">Level</th>
                        <th class="px-4 py-3 text-left font-semibold">Status</th>
                        <th class="px-4 py-3 text-center font-semibold w-24">Aksi</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @php
                        $filtered = $items ?? [];
                        $q = trim((string)request('q', ''));
                        if ($q !== '') {
                            $filtered = array_values(array_filter($filtered, function($e) use ($q) {
                                $hay = strtolower(json_encode([
                                    data_get($e,'employment.employee_id'),
                                    data_get($e,'personal.first_name').' '.data_get($e,'personal.last_name'),
                                    data_get($e,'personal.email'),
                                    data_get($e,'employment.organization_name'),
                                    data_get($e,'employment.job_position'),
                                    data_get($e,'employment.job_level'),
                                    data_get($e,'employment.branch'),
                                ]));
                                return str_contains($hay, strtolower($q));
                            }));
                        }

                        $currentPage = (int) ($paging['current_page'] ?? request('page', 1));
                        $startNumber = ($currentPage - 1) * $limit;
                    @endphp

                    @forelse($filtered as $idx => $emp)
                        @php
                            $uid    = data_get($emp,'user_id','-');
                            $eid    = data_get($emp,'employment.employee_id','-');
                            $first  = data_get($emp,'personal.first_name','');
                            $last   = data_get($emp,'personal.last_name','');
                            $name   = trim(($first.' '.$last)) ?: '—';
                            $email  = data_get($emp,'personal.email','—');
                            $org    = data_get($emp,'employment.organization_name','—');
                            $pos    = data_get($emp,'employment.job_position','—');
                            $lvl    = data_get($emp,'employment.job_level','—');
                            $stat   = data_get($emp,'employment.status','—');
                            $branch = data_get($emp,'employment.branch','—');
                            $no     = $startNumber + $idx + 1;

                            $avatar  = data_get($emp,'personal.avatar');
                            $initial = strtoupper(mb_substr($first ?: 'N',0,1));
                        @endphp
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-3 text-gray-600">{{ $no }}</td>

                            <td class="px-4 py-3">
                                <div class="flex items-center gap-3">
                                    @if($avatar)
                                        <button type="button"
                                                class="h-10 w-10 rounded-full overflow-hidden ring-2 ring-gray-100 shadow-sm hover:opacity-90"
                                                title="Perbesar foto"
                                                onclick="openAvatarModal('{{ $avatar }}','{{ e($name) }}')">
                                            <img src="{{ $avatar }}" alt="Foto {{ $name }}" class="h-full w-full object-cover">
                                        </button>
                                    @else
                                        <div class="h-10 w-10 rounded-full bg-gray-100 grid place-items-center text-sm font-semibold text-gray-600">
                                            {{ $initial }}
                                        </div>
                                    @endif

                                    <div class="min-w-0">
                                        <a href="{{ route('talenta.sandbox.employees.show',$uid) }}"
                                           class="font-semibold text-blue-600 hover:underline truncate inline-block max-w-[260px]">
                                            {{ $name }}
                                        </a>
                                        <div class="text-xs text-gray-500 truncate max-w-[260px]">{{ $email }}</div>
                                    </div>
                                </div>
                            </td>

                            <td class="px-4 py-3">{{ $branch }}</td>
                            <td class="px-4 py-3">{{ $eid }}</td>
                            <td class="px-4 py-3">{{ $org }}</td>
                            <td class="px-4 py-3">{{ $pos }}</td>
                            <td class="px-4 py-3">{{ $lvl }}</td>

                            <td class="px-4 py-3">
                                @if($stat === 'Active')
                                    <span class="inline-flex items-center gap-1 px-2 py-1 text-xs rounded-full bg-green-100 text-green-700">
                                        <i class="fas fa-circle text-[8px]"></i> Active
                                    </span>
                                @else
                                    <span class="inline-flex items-center gap-1 px-2 py-1 text-xs rounded-full bg-gray-100 text-gray-700">
                                        <i class="far fa-circle text-[8px]"></i> {{ $stat }}
                                    </span>
                                @endif
                            </td>

                            <td class="px-4 py-3">
                                <div class="flex items-center justify-center gap-2">
                                    <a href="{{ route('talenta.sandbox.employees.edit',$uid) }}"
                                       class="inline-flex items-center justify-center h-8 w-8 rounded-lg hover:bg-amber-50 text-amber-600"
                                       title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form action="{{ route('talenta.sandbox.employees.destroy',$uid) }}" method="POST"
                                          onsubmit="return confirm('Yakin hapus karyawan ini?')">
                                        @csrf @method('DELETE')
                                        <button type="submit"
                                                class="inline-flex items-center justify-center h-8 w-8 rounded-lg hover:bg-red-50 text-red-600"
                                                title="Hapus">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="px-6 py-10">
                                <div class="flex flex-col items-center justify-center text-center text-gray-500">
                                    <div class="h-12 w-12 rounded-full bg-gray-100 grid place-items-center mb-3">
                                        <i class="far fa-user text-xl"></i>
                                    </div>
                                    <div class="font-medium">Belum ada data karyawan</div>
                                    <p class="text-sm mt-1">Coba tambahkan karyawan baru atau ubah filter.</p>
                                    <a href="{{ route('talenta.sandbox.employees.create') }}"
                                       class="mt-3 inline-flex items-center gap-2 px-3 py-2 rounded-xl text-white bg-primary hover:opacity-90">
                                        <i class="fas fa-plus"></i> Tambah Karyawan
                                    </a>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Footer pagination --}}
        @php
            $current = (int) ($paging['current_page'] ?? request('page', 1));
            $total   = (int) ($paging['total_pages'] ?? 1);
        @endphp
        <div class="px-4 md:px-5 py-3 border-t border-gray-100 flex flex-col md:flex-row md:items-center justify-between gap-3 text-sm text-gray-600">
            <div>Halaman {{ $current }} dari {{ $total }}</div>
            <div class="flex items-center gap-2">
                <a href="{{ request()->fullUrlWithQuery(['page'=>1,'limit'=>$limit,'q'=>request('q')]) }}"
                   class="px-3 py-1 rounded border hover:bg-gray-50 {{ $current<=1 ? 'pointer-events-none opacity-40' : '' }}">
                    « First
                </a>
                <a href="{{ request()->fullUrlWithQuery(['page'=>max(1,$current-1),'limit'=>$limit,'q'=>request('q')]) }}"
                   class="px-3 py-1 rounded border hover:bg-gray-50 {{ $current<=1 ? 'pointer-events-none opacity-40' : '' }}">
                    ← Prev
                </a>
                <a href="{{ request()->fullUrlWithQuery(['page'=>min($total,$current+1),'limit'=>$limit,'q'=>request('q')]) }}"
                   class="px-3 py-1 rounded border hover:bg-gray-50 {{ $current>=$total ? 'pointer-events-none opacity-40' : '' }}">
                    Next →
                </a>
                <a href="{{ request()->fullUrlWithQuery(['page'=>$total,'limit'=>$limit,'q'=>request('q')]) }}"
                   class="px-3 py-1 rounded border hover:bg-gray-50 {{ $current>=$total ? 'pointer-events-none opacity-40' : '' }}">
                    Last »
                </a>
            </div>
        </div>
    </div>
</div>

{{-- Modal Preview Avatar --}}
<div id="avatarModal" class="fixed inset-0 bg-black/70 hidden items-center justify-center z-50">
    <div class="relative bg-white rounded-2xl shadow-2xl p-2 md:p-3 max-w-3xl w-[92vw]">
        <button type="button" onclick="closeAvatarModal()"
                class="absolute -top-3 -right-3 md:top-2 md:right-2 h-8 w-8 md:h-9 md:w-9 grid place-items-center rounded-full bg-white text-gray-700 shadow hover:text-red-500">
            ✕
        </button>
        <img id="avatarPreview" src="" alt="Avatar preview" class="rounded-xl max-h-[80vh] w-auto mx-auto">
        <div id="avatarCaption" class="text-center text-xs text-gray-500 mt-2"></div>
    </div>
</div>

{{-- SweetAlert2 --}}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    // Modal avatar
    function openAvatarModal(url, name) {
        const modal = document.getElementById('avatarModal');
        const img   = document.getElementById('avatarPreview');
        const cap   = document.getElementById('avatarCaption');
        img.src = url;
        cap.textContent = name || '';
        modal.classList.remove('hidden');
        modal.classList.add('flex');
    }
    function closeAvatarModal() {
        const modal = document.getElementById('avatarModal');
        const img   = document.getElementById('avatarPreview');
        img.src = '';
        modal.classList.add('hidden');
        modal.classList.remove('flex');
    }
    document.getElementById('avatarModal')?.addEventListener('click', function(e) {
        if (e.target === this) closeAvatarModal();
    });
    window.addEventListener('keydown', function(e){
        if (e.key === 'Escape') closeAvatarModal();
    });

    // === SweetAlert flash ===
    // Controller mengirim session('swal') => ['icon'=>'success|error|info','title'=>'...','text'=>'...'].
    @if(session('swal'))
        (function() {
            const cfg = @json(session('swal'));
            Swal.fire({
                icon: cfg.icon ?? 'success',
                title: cfg.title ?? 'Info',
                text: cfg.text ?? '',
                confirmButtonText: 'OK',
                allowOutsideClick: false,
                allowEscapeKey: true
            });
        })();
    @elseif(session('success'))
        Swal.fire({
            icon: 'success',
            title: 'Berhasil',
            text: @json(session('success')),
            confirmButtonText: 'OK',
            allowOutsideClick: false,
            allowEscapeKey: true
        });
    @elseif($errors->any() || session('error'))
        Swal.fire({
            icon: 'error',
            title: 'Gagal',
            html: `{!! session('error') ? e(session('error')) : 'Periksa pesan kesalahan pada halaman.' !!}`,
            confirmButtonText: 'OK',
            allowOutsideClick: false,
            allowEscapeKey: true
        });
    @endif
</script>
@endsection
