{{-- resources/views/talenta/sandbox/employees/edit.blade.php --}}
@extends('layouts.app')
@section('title','Sandbox – Employees')
@section('page-title','Ubah Karyawan (Sandbox)')

@section('content')
@php
    use Illuminate\Support\Str;

    /** ========== Short helpers ========== **/
    $p   = (array) data_get($emp, 'personal', []);
    $e   = (array) data_get($emp, 'employment', []);
    $uid = data_get($emp, 'user_id');

    // old() with fallback
    $ov = function (string $key, $fallback = '') {
        $v = old($key);
        return isset($v) ? $v : $fallback;
    };

    // normalize to Y-m-d (trim time)
    $ymd = function ($date) {
        $d = (string) $date;
        return Str::of($d)->substr(0, 10);
    };

    // option selected helper (match by name or id string)
    $isSel = function ($current, $opt) {
        $cn   = (string) $current;
        $name = (string) ($opt['name'] ?? '');
        $id   = (string) ($opt['id'] ?? '');
        return strcasecmp($cn, $name) === 0 || $cn === $id;
    };

    $formActionUser = $user ?? $uid;

    /** ========== PREFILL (Personal) ========== **/
    $employee_id   = trim($ov('employee_id',   (string) data_get($e, 'employee_id', '')));
    $first_name    = $ov('first_name',    (string) data_get($p, 'first_name', ''));
    $last_name     = $ov('last_name',     (string) data_get($p, 'last_name', ''));
    $email         = $ov('email',         (string) data_get($p, 'email', ''));
    // birthdate → fallback ke personal.birth_date jika date_of_birth kosong
    $date_of_birth = $ov('date_of_birth', $ymd(data_get($p, 'date_of_birth', data_get($p, 'birth_date', ''))));

    // gender: Talenta bisa kasih "1/2" atau "Male/Female"
    $genderRaw     = data_get($p, 'gender');
    $genderFromApi = is_numeric($genderRaw)
        ? ((int)$genderRaw === 1 ? 'Male' : ((int)$genderRaw === 2 ? 'Female' : ''))
        : ((string)($genderRaw ?? ''));
    $gender        = $ov('gender', data_get($p, 'gender_text', $genderFromApi));

    // marital & religion: gunakan label bila ada
    $marital_status = $ov('marital_status', (string) (data_get($p, 'marital_status_text') ?? data_get($p, 'marital_status') ?? ''));
    $religion       = $ov('religion',       (string) (data_get($p, 'religion_text')       ?? data_get($p, 'religion')       ?? ''));

    /** ========== PREFILL (Employment) ========== **/
    $branch              = $ov('branch',              (string) data_get($e, 'branch', ''));
    $organization_name   = $ov('organization_name',   (string) data_get($e, 'organization_name', ''));
    $job_position        = $ov('job_position',        (string) data_get($e, 'job_position', ''));
    $job_level           = $ov('job_level',           (string) data_get($e, 'job_level', ''));
    $employment_status   = (string) $ov('employment_status', (string) (data_get($e, 'employment_status_id') ?? data_get($e, 'employment_status') ?? ''));
    $join_date           = $ov('join_date',           $ymd(data_get($e, 'join_date', '')));
    // end date → fallback ke employment.end_date
    $end_employment_date = $ov('end_employment_status_date', $ymd(data_get($e, 'end_employment_status_date', data_get($e, 'end_date', ''))));
    $schedule            = $ov('schedule',            (string) data_get($e, 'schedule', ''));

    /** ========== PREFILL (Comp & Tax) ========== **/
    $basic_salary        = $ov('basic_salary',        (int) data_get($e, 'basic_salary', 0));
    // PTKP: bisa ada di employment atau payroll_info
    $ptkp_status         = (string) $ov('ptkp_status', (string) (data_get($e, 'ptkp_status_text') ?? data_get($e, 'ptkp_status') ?? data_get($emp, 'payroll_info.ptkp_status', 'TK/0')));
    $npp_bpjs_ket        = $ov('npp_bpjs_ketenagakerjaan', (string) (data_get($e, 'npp_bpjs_ketenagakerjaan', '')));

    // Payroll flags (prefill default aman)
    $tax_configuration    = (int) $ov('tax_configuration',    (int) (data_get($e, 'tax_configuration', 1)));
    $type_salary          = (int) $ov('type_salary',          (int) (data_get($e, 'type_salary', 1)));
    $salary_configuration = (int) $ov('salary_configuration', (int) (data_get($e, 'salary_configuration', 1)));
    $jht_configuration    = (int) $ov('jht_configuration',    (int) (data_get($e, 'jht_configuration', 0)));
    $employee_tax_status  = (int) $ov('employee_tax_status',  (int) (data_get($e, 'employee_tax_status', 1)));
    $jp_configuration     = (int) $ov('jp_configuration',     (int) (data_get($e, 'jp_configuration', 0)));
    $overtime_status      = (int) $ov('overtime_status',      (int) (data_get($e, 'overtime_status', 2)));
    $bpjs_kesehatan_conf  = (int) $ov('bpjs_kesehatan_config',(int) (data_get($e, 'bpjs_kesehatan_config', 1)));

@endphp

<div class="max-w-6xl mx-auto">
    {{-- Header --}}
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 px-5 py-4 mb-5 flex items-center justify-between">
        <div>
            <h2 class="text-lg font-semibold text-gray-900">Ubah Karyawan – Sandbox</h2>
            <p class="text-sm text-gray-500">Form auto-terisi dari data saat ini. <span class="text-red-600">*</span> wajib diisi.</p>
        </div>
        <a href="{{ route('talenta.sandbox.employees.index') }}"
           class="inline-flex items-center gap-2 text-sm px-3 py-2 rounded-xl border border-gray-200 hover:bg-gray-50">
           ← Kembali
        </a>
    </div>

    {{-- Errors list --}}
    @if($errors->any())
        <div class="mb-5 rounded-xl border border-red-200 bg-red-50 text-red-700 px-4 py-3">
            <div class="font-semibold mb-1">Form belum lengkap</div>
            <ul class="list-disc ml-5 text-sm">
                @foreach($errors->all() as $e)
                    <li>{{ $e }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    {{-- (Optional) Debug current payload --}}
    <details class="mb-5">
        <summary class="cursor-pointer text-sm text-gray-600 hover:text-gray-800">Lihat raw data employee (debug)</summary>
        <div class="mt-2 bg-white rounded-xl border border-gray-100 p-3">
            <pre class="text-xs text-gray-600 whitespace-pre-wrap">{{ json_encode($emp ?? [], JSON_PRETTY_PRINT) }}</pre>
        </div>
    </details>

    <form action="{{ route('talenta.sandbox.employees.update', $formActionUser) }}" method="POST" class="space-y-6">
        @csrf
        @method('PUT')

        {{-- ================= PERSONAL ================= --}}
        <section class="bg-white rounded-2xl shadow-sm border border-gray-100">
            <div class="px-5 py-4 border-b border-gray-100">
                <h3 class="font-semibold text-gray-900">Informasi Personal</h3>
                <p class="text-sm text-gray-500">Data dasar karyawan.</p>
            </div>

            <div class="p-5 grid grid-cols-1 md:grid-cols-2 gap-5">
                {{-- Employee ID (READ-ONLY) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Employee ID <span class="text-red-600">*</span>
                        <span class="ml-2 text-xs px-2 py-0.5 rounded-full bg-gray-100 text-gray-600 align-middle">read-only</span>
                    </label>
                    <input type="text" name="employee_id" value="{{ $employee_id }}"
                           class="w-full rounded-xl border @error('employee_id') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2 bg-gray-50 text-gray-700 cursor-not-allowed"
                           required placeholder="EMP0001" readonly title="Employee ID tidak bisa diubah di Sandbox Edit">
                    @error('employee_id')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                    <p class="text-xs text-gray-500 mt-1">Nilai ini dikunci saat edit. Perubahan akan diabaikan oleh backend.</p>
                </div>

                {{-- First Name --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        First Name <span class="text-red-600">*</span>
                    </label>
                    <input type="text" name="first_name" value="{{ $first_name }}"
                           class="w-full rounded-xl border @error('first_name') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                           required>
                    @error('first_name')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- Last Name --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Last Name</label>
                    <input type="text" name="last_name" value="{{ $last_name }}"
                           class="w-full rounded-xl border border-gray-300 px-3 py-2">
                </div>

                {{-- Email --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Email <span class="text-red-600">*</span>
                    </label>
                    <input type="email" name="email" value="{{ $email }}"
                           class="w-full rounded-xl border @error('email') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                           required placeholder="nama@perusahaan.com">
                    @error('email')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- Birthdate --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Birthdate <span class="text-red-600">*</span>
                    </label>
                    <input type="date" name="date_of_birth" value="{{ $date_of_birth }}"
                           class="w-full rounded-xl border @error('date_of_birth') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                           required>
                    @error('date_of_birth')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- Gender --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Gender <span class="text-red-600">*</span>
                    </label>
                    <select name="gender"
                            class="w-full rounded-xl border @error('gender') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($genders ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" @selected($gender === $opt['name'])>{{ $opt['name'] }}</option>
                        @endforeach
                    </select>
                    @error('gender')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- Marital --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Marital Status <span class="text-red-600">*</span>
                    </label>
                    <select name="marital_status"
                            class="w-full rounded-xl border @error('marital_status') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($maritals ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" @selected(strcasecmp($marital_status,$opt['name'])===0 || (string)$marital_status === (string)($opt['id'] ?? ''))>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('marital_status')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- Religion --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Religion <span class="text-red-600">*</span>
                    </label>
                    <select name="religion"
                            class="w-full rounded-xl border @error('religion') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($religs ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" @selected(strcasecmp($religion,$opt['name'])===0 || (string)$religion === (string)($opt['id'] ?? ''))>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('religion')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>
            </div>
        </section>

        {{-- ================= EMPLOYMENT ================= --}}
        <section class="bg-white rounded-2xl shadow-sm border border-gray-100">
            <div class="px-5 py-4 border-b border-gray-100">
                <h3 class="font-semibold text-gray-900">Informasi Employment</h3>
                <p class="text-sm text-gray-500">Pemetaan organisasi & status kerja.</p>
            </div>

            <div class="p-5 grid grid-cols-1 md:grid-cols-2 gap-5">
                {{-- Branch --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Branch <span class="text-red-600">*</span>
                    </label>
                    <select name="branch"
                            class="w-full rounded-xl border @error('branch') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($branches ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" @selected($isSel($branch,$opt))>
                                {{ $opt['name'] }} @if(($opt['id'] ?? '')!=='') (ID: {{ $opt['id'] }}) @endif
                            </option>
                        @endforeach
                    </select>
                    @error('branch')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                    <p class="text-xs text-gray-500 mt-1">Contoh: “Pusat”.</p>
                </div>

                {{-- Organization --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Organization <span class="text-red-600">*</span>
                    </label>
                    <select name="organization_name"
                            class="w-full rounded-XL border @error('organization_name') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($orgs ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" @selected($isSel($organization_name,$opt))>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('organization_name')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- Job Position --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Job Position <span class="text-red-600">*</span>
                    </label>
                    <select name="job_position"
                            class="w-full rounded-xl border @error('job_position') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($jobs ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" @selected($isSel($job_position,$opt))>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('job_position')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- Job Level --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Job Level <span class="text-red-600">*</span>
                    </label>
                    @if(!empty($levels))
                        <select name="job_level"
                                class="w-full rounded-xl border @error('job_level') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                                required>
                            <option value="">-- Pilih --</option>
                            @foreach($levels as $opt)
                                <option value="{{ $opt['name'] }}" @selected($isSel($job_level,$opt))>
                                    {{ $opt['name'] }}
                                </option>
                            @endforeach
                        </select>
                    @else
                        <input type="text" name="job_level" value="{{ $job_level }}"
                               class="w-full rounded-xl border @error('job_level') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                               required placeholder='mis. "Manager" (master job level kosong)'>
                        <p class="text-xs text-gray-500 mt-1">Master Job Level kosong.</p>
                    @endif
                    @error('job_level')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- Employment Status --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Employment Status <span class="text-red-600">*</span>
                    </label>
                    <select name="employment_status" id="employment_status"
                            class="w-full rounded-xl border @error('employment_status') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($emps ?? []) as $opt)
                            <option value="{{ $opt['id'] }}" @selected((string)$employment_status === (string)$opt['id'])>
                                {{ $opt['name'] }} (ID: {{ $opt['id'] }})
                            </option>
                        @endforeach
                    </select>
                    @error('employment_status')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                    <p class="text-xs text-gray-500 mt-1">
                        <span class="font-medium">Contract (ID=2)</span> & <span class="font-medium">Probation (ID=3)</span> wajib isi <em>End Employment Status Date</em>.
                    </p>
                </div>

                {{-- End Employment Status Date --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">End Employment Status Date</label>
                    <input type="date" name="end_employment_status_date" id="end_employment_status_date"
                           value="{{ $end_employment_date }}"
                           class="w-full rounded-xl border @error('end_employment_status_date') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2">
                    @error('end_employment_status_date')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- Join Date --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Join Date <span class="text-red-600">*</span>
                    </label>
                    <input type="date" name="join_date" value="{{ $join_date }}"
                           class="w-full rounded-xl border @error('join_date') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                           required>
                    @error('join_date')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- Schedule --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Schedule <span class="text-red-600">*</span>
                    </label>
                    <select name="schedule"
                            class="w-full rounded-xl border @error('schedule') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($schedules ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" @selected(strcasecmp($schedule,$opt['name'])===0)>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('schedule')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>
            </div>
        </section>

        {{-- ================= KOMPENSASI & PAJAK ================= --}}
        <section class="bg-white rounded-2xl shadow-sm border border-gray-100">
            <div class="px-5 py-4 border-b border-gray-100">
                <h3 class="font-semibold text-gray-900">Kompensasi & Pajak</h3>
                <p class="text-sm text-gray-500">
                    Basic salary <em>opsional saat edit</em>. Kosongkan jika tidak ingin mengubah.
                </p>
            </div>

            <div class="p-5 grid grid-cols-1 md:grid-cols-2 gap-5">
                {{-- Basic Salary (OPSIONAL) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Basic Salary</label>
                    <input type="number" min="0" step="1" name="basic_salary" value="{{ old('basic_salary', $basic_salary) }}"
                           class="w-full rounded-xl border @error('basic_salary') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                           placeholder="cth: 5000000 (kosongkan jika tidak diubah)">
                    @error('basic_salary')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                    <p class="text-xs text-gray-500 mt-1">Boleh 0. Jika backend menolak 0, sistem akan mengakali dan mengembalikan ke 0.</p>
                </div>

                {{-- PTKP (wajib) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        PTKP Status <span class="text-red-600">*</span>
                    </label>
                    <select name="ptkp_status"
                            class="w-full rounded-xl border @error('ptkp_status') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($ptkps ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" @selected(strcasecmp($ptkp_status,$opt['name'])===0 || (string)$ptkp_status === (string)($opt['id'] ?? ''))>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('ptkp_status')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- Payroll flags (opsional, default aman) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Tax Configuration</label>
                    <select name="tax_configuration" class="w-full rounded-xl border border-gray-300 px-3 py-2">
                        @foreach([1=>'Gross',2=>'Net',3=>'Gross Up'] as $k=>$lbl)
                            <option value="{{ $k }}" @selected($tax_configuration===$k)>{{ $lbl }}</option>
                        @endforeach
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Type Salary</label>
                    <select name="type_salary" class="w-full rounded-xl border border-gray-300 px-3 py-2">
                        @foreach([1=>'Monthly',2=>'Daily'] as $k=>$lbl)
                            <option value="{{ $k }}" @selected($type_salary===$k)>{{ $lbl }}</option>
                        @endforeach
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Salary Configuration</label>
                    <select name="salary_configuration" class="w-full rounded-xl border border-gray-300 px-3 py-2">
                        @foreach([1=>'Gross',2=>'Net'] as $k=>$lbl)
                            <option value="{{ $k }}" @selected($salary_configuration===$k)>{{ $lbl }}</option>
                        @endforeach
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">JHT Configuration</label>
                    <select name="jht_configuration" class="w-full rounded-xl border border-gray-300 px-3 py-2">
                        @foreach([0=>'None',1=>'By Employee',2=>'By Company',3=>'Both'] as $k=>$lbl)
                            <option value="{{ $k }}" @selected($jht_configuration===$k)>{{ $lbl }}</option>
                        @endforeach
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Employee Tax Status</label>
                    <input type="number" name="employee_tax_status" min="0" max="12"
                           value="{{ $employee_tax_status }}"
                           class="w-full rounded-xl border border-gray-300 px-3 py-2">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">JP Configuration</label>
                    <select name="jp_configuration" class="w-full rounded-xl border border-gray-300 px-3 py-2">
                        @foreach([0=>'None',1=>'By Employee',2=>'By Company',3=>'Both'] as $k=>$lbl)
                            <option value="{{ $k }}" @selected($jp_configuration===$k)>{{ $lbl }}</option>
                        @endforeach
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Overtime</label>
                    <select name="overtime_status" class="w-full rounded-xl border border-gray-300 px-3 py-2">
                        @foreach([1=>'Yes',2=>'No'] as $k=>$lbl)
                            <option value="{{ $k }}" @selected($overtime_status===$k)>{{ $lbl }}</option>
                        @endforeach
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">BPJS Kesehatan Class</label>
                    <select name="bpjs_kesehatan_config" class="w-full rounded-xl border border-gray-300 px-3 py-2">
                        @foreach([1=>'Class 1',2=>'Class 2',3=>'Class 3'] as $k=>$lbl)
                            <option value="{{ $k }}" @selected($bpjs_kesehatan_conf===$k)>{{ $lbl }}</option>
                        @endforeach
                    </select>
                </div>

                {{-- NPP BPJS TK --}}
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700 mb-1">NPP BPJS Ketenagakerjaan</label>
                    <input type="text" name="npp_bpjs_ketenagakerjaan" value="{{ $npp_bpjs_ket }}"
                           class="w-full rounded-xl border border-gray-300 px-3 py-2"
                           placeholder='isi "default" jika tidak tahu'>
                </div>
            </div>
        </section>

        {{-- ================= ACTIONS ================= --}}
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-4 md:sticky md:bottom-4">
            <div class="flex flex-col md:flex-row items-stretch md:items-center justify-between gap-3">
                <p class="text-sm text-gray-500">Simpan perubahan yang sudah dilakukan.</p>
                <div class="flex items-center gap-3">
                    <a href="{{ route('talenta.sandbox.employees.show', $formActionUser) }}"
                       class="inline-flex items-center justify-center px-4 py-2 rounded-xl border border-gray-200 hover:bg-gray-50">Batal</a>
                    <button type="submit" class="inline-flex items-center justify-center px-4 py-2 rounded-xl text-white bg-primary hover:opacity-90">
                        Simpan Perubahan
                    </button>
                </div>
            </div>
        </div>
    </form>
</div>

{{-- SweetAlert2 & dynamic rule (single source) --}}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', () => {
  @if(session('success'))
    Swal.fire({
      icon:'success',
      title:'Berhasil',
      text:@json(session('success')),
      timer:2000,
      timerProgressBar:true,
      showConfirmButton:false
    });
  @endif

  @if(session('error'))
    Swal.fire({
      icon:'error',
      title:'Gagal',
      html:@json(session('error'))
    });
  @endif

  @if($errors->any())
    Swal.fire({
      icon:'error',
      title:'Form belum lengkap',
      html:`{!! '<ul style="text-align:left;margin:0;padding-left:16px">' .
            collect($errors->all())->map(fn($e)=>"<li>".e($e)."</li>")->implode('') .
            '</ul>' !!}`
    });
  @endif

  // End date wajib kalau status = 2 (Contract) atau 3 (Probation)
  const selStatus = document.getElementById('employment_status');
  const endDate   = document.getElementById('end_employment_status_date');
  function enforceEndDateReq() {
      if (!selStatus || !endDate) return;
      const v = selStatus.value;
      endDate.toggleAttribute('required', v === '2' || v === '3');
  }
  selStatus?.addEventListener('change', enforceEndDateReq);
  enforceEndDateReq();
});
</script>
@endsection