{{-- resources/views/talenta/employees/create.blade.php --}}
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Create Employee (Talenta Sandbox)</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <meta name="csrf-token" content="{{ csrf_token() }}">
</head>
<body class="bg-gray-50 min-h-screen">
  <div class="max-w-xl mx-auto mt-10 bg-white p-6 rounded-xl shadow">
    <h1 class="text-2xl font-semibold mb-4">Create Employee (Sandbox)</h1>

    <form id="frm" class="space-y-4">
      <div>
        <label class="block mb-1 font-medium">Employee ID *</label>
        <input name="employee_id" required class="w-full rounded-lg border px-3 py-2" placeholder="E0001">
      </div>
      <div>
        <label class="block mb-1 font-medium">Employee Name *</label>
        <input name="employee_name" required class="w-full rounded-lg border px-3 py-2" placeholder="John Doe">
      </div>

      <div class="flex items-center gap-2">
        <button type="submit"
                class="px-4 py-2 rounded-lg bg-emerald-600 text-white hover:bg-emerald-700">
          Simpan
        </button>
        <a href="{{ url('/talenta-demo') }}"
           class="px-4 py-2 rounded-lg border hover:bg-gray-50">Lihat List</a>
      </div>
    </form>

    <pre id="out" class="mt-6 bg-gray-100 p-3 rounded text-sm overflow-x-auto"></pre>
  </div>

  <script>
    const out = document.getElementById('out');
    document.getElementById('frm').addEventListener('submit', async (e) => {
      e.preventDefault();
      out.textContent = 'Submitting...';
      const form = e.currentTarget;
      const payload = {
        employee_id: form.employee_id.value.trim(),
        employee_name: form.employee_name.value.trim(),
      };

      const res = await fetch('{{ route("talenta.employees.store") }}', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          'X-CSRF-TOKEN': document.querySelector("meta[name='csrf-token']").getAttribute('content')
        },
        body: JSON.stringify(payload),
      });

      const text = await res.text(); // tampilkan mentah supaya mudah debug 4xx
      try {
        const json = JSON.parse(text);
        out.textContent = JSON.stringify(json, null, 2);
      } catch {
        out.textContent = text;
      }
    });
  </script>
</body>
</html>
