{{-- resources/views/positions/show.blade.php --}}
@extends('layouts.app')

@section('title', 'Detail Posisi')
@section('page-title', 'Detail Posisi')

@push('styles')
  {{-- tidak ada style tambahan supaya tidak bentrok dengan sidebar/layout --}}
@endpush

@section('content')
  {{-- Breadcrumb + judul --}}
  <div class="mb-6 flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
    <div>
      <div class="text-sm text-gray-500">
        <a href="{{ route('dashboard') }}" class="text-primary hover:underline">Dashboard</a>
        <span class="mx-1">/</span>
        <a href="{{ route('positions.index') }}" class="text-primary hover:underline">Posisi</a>
        <span class="mx-1">/</span>
        <span class="text-gray-600">Detail</span>
      </div>
      <h1 class="text-2xl font-bold text-gray-900 mt-1">Detail Posisi</h1>
    </div>

    <div class="flex gap-2">
      <a href="{{ route('positions.index') }}" class="inline-flex items-center gap-2 px-4 py-2 rounded-lg bg-gray-600 text-white hover:bg-gray-700">
        <i class="fas fa-arrow-left"></i> Kembali
      </a>
    </div>
  </div>

  {{-- Header kartu --}}
  <div class="bg-white border border-gray-200 rounded-xl shadow-sm overflow-hidden">
    <div class="flex flex-col lg:flex-row items-start lg:items-center justify-between gap-4 px-5 py-4 bg-gradient-to-r from-gray-50 to-indigo-50 border-b border-gray-200">
      <div>
        <h2 class="text-xl font-extrabold text-gray-900">{{ $position->position_name }}</h2>
        <div class="mt-1 text-sm text-gray-600 flex flex-wrap items-center gap-2">
          <span class="px-2 py-0.5 rounded-md text-indigo-900 bg-indigo-100 uppercase text-xs font-semibold tracking-wider">
            {{ method_exists($position,'getEmploymentTypeLabelAttribute') ? $position->employment_type_label : strtoupper($position->employment_type) }}
          </span>
          @if($position->department)
            <span>• {{ $position->department }}</span>
          @endif
          @if($position->location)
            <span>• <i class="fas fa-map-marker-alt"></i> {{ $position->location }}</span>
          @endif
        </div>
      </div>

      <div class="flex flex-wrap gap-2">
        <a href="{{ route('positions.edit', $position->id) }}"
           class="inline-flex items-center gap-2 px-4 py-2 rounded-lg bg-gradient-to-r from-primary to-secondary text-white hover:brightness-95">
          <i class="fas fa-edit"></i> Edit
        </a>

        @if($position->is_active)
          <button id="btnClose" data-id="{{ $position->id }}"
                  class="inline-flex items-center gap-2 px-4 py-2 rounded-lg bg-amber-500 text-white hover:brightness-95">
            <i class="fas fa-ban"></i> Tutup Posisi
          </button>
        @else
          <button id="btnOpen" data-id="{{ $position->id }}"
                  class="inline-flex items-center gap-2 px-4 py-2 rounded-lg bg-emerald-600 text-white hover:brightness-95">
            <i class="fas fa-check"></i> Buka Posisi
          </button>
        @endif

        <button id="btnDelete"
                data-id="{{ $position->id }}"
                data-name="{{ addslashes($position->position_name) }}"
                data-total="{{ $totalCandidates }}"
                data-active="{{ $activeCandidates }}"
                data-url="{{ route('positions.destroy', $position->id) }}"
                class="inline-flex items-center gap-2 px-4 py-2 rounded-lg bg-red-600 text-white hover:bg-red-700">
          <i class="fas fa-trash-alt"></i> Hapus
        </button>
      </div>
    </div>

    {{-- Isi --}}
    <div class="p-5">
      <div class="grid grid-cols-1 lg:grid-cols-2 gap-5">
        {{-- Informasi --}}
        <div class="border border-gray-200 rounded-xl overflow-hidden">
          <div class="px-4 py-3 bg-gray-50 border-b border-gray-200 font-semibold text-gray-700">
            <i class="fas fa-info-circle mr-2"></i>Informasi Posisi
          </div>
          <div class="divide-y divide-gray-100">
            <div class="flex items-center justify-between px-4 py-3">
              <span class="text-gray-500">Status</span>
              <span>
                @if($position->is_active)
                  <span class="inline-flex items-center gap-1 px-3 py-1 rounded-full bg-emerald-100 text-emerald-700 text-sm">
                    <i class="fas fa-check-circle"></i> Aktif
                  </span>
                @else
                  <span class="inline-flex items-center gap-1 px-3 py-1 rounded-full bg-amber-100 text-amber-700 text-sm">
                    <i class="fas fa-times-circle"></i> Tutup
                  </span>
                @endif
              </span>
            </div>

            <div class="flex items-center justify-between px-4 py-3">
              <span class="text-gray-500">Departemen</span>
              <span class="font-semibold text-gray-800">{{ $position->department ?? '-' }}</span>
            </div>

            <div class="flex items-center justify-between px-4 py-3">
              <span class="text-gray-500">Lokasi</span>
              <span class="font-semibold text-gray-800">{{ $position->location ?? '-' }}</span>
            </div>

            <div class="flex items-center justify-between px-4 py-3">
              <span class="text-gray-500">Rentang Gaji</span>
              <span class="font-semibold text-gray-800">
                @php
                  $min = $position->salary_range_min ? number_format($position->salary_range_min,0,',','.') : null;
                  $max = $position->salary_range_max ? number_format($position->salary_range_max,0,',','.') : null;
                @endphp
                @if($min && $max)
                  Rp {{ $min }} - Rp {{ $max }}
                @elseif($min)
                  ≥ Rp {{ $min }}
                @elseif($max)
                  ≤ Rp {{ $max }}
                @else
                  Dinegosiasikan
                @endif
              </span>
            </div>

            <div class="flex items-center justify-between px-4 py-3">
              <span class="text-gray-500">Tanggal Posting</span>
              <span class="font-semibold text-gray-800">{{ $position->posted_date ? $position->posted_date->format('d M Y') : '-' }}</span>
            </div>

            <div class="flex items-center justify-between px-4 py-3">
              <span class="text-gray-500">Tanggal Penutupan</span>
              <span class="font-semibold text-gray-800">
                {{ $position->closing_date ? $position->closing_date->format('d M Y') : '-' }}
                @if($position->closing_date && $position->closing_date->isPast())
                  <span class="text-xs text-gray-500 ml-1">(Lewat)</span>
                @endif
              </span>
            </div>
          </div>
        </div>

        {{-- Statistik --}}
        <div class="border border-gray-200 rounded-xl overflow-hidden">
          <div class="px-4 py-3 bg-gray-50 border-b border-gray-200 font-semibold text-gray-700">
            <i class="fas fa-chart-bar mr-2"></i>Statistik Aplikasi
          </div>
          <div class="divide-y divide-gray-100">
            <div class="flex items-center justify-between px-4 py-3">
              <span class="text-gray-500">Total Kandidat</span>
              <span class="font-bold text-gray-900">{{ $totalCandidates }}</span>
            </div>
            <div class="flex items-center justify-between px-4 py-3">
              <span class="text-gray-500">Kandidat Aktif</span>
              <span class="font-bold text-gray-900">{{ $activeCandidates }}</span>
            </div>

            @if(!$position->is_active && $activeCandidates > 0)
              <div class="px-4 py-3">
                <div class="rounded-lg border border-rose-200 bg-rose-50 text-rose-800 text-sm p-3">
                  <i class="fas fa-exclamation-triangle mr-2"></i>
                  Posisi nonaktif namun masih ada {{ $activeCandidates }} kandidat yang diproses.
                </div>
              </div>
            @endif
          </div>
        </div>
      </div>

      {{-- Deskripsi / Persyaratan --}}
      @if($position->description)
        <div class="mt-5 border border-gray-200 rounded-xl overflow-hidden">
          <div class="px-4 py-3 bg-gray-50 border-b border-gray-200 font-semibold text-gray-700">
            <i class="fas fa-align-left mr-2"></i>Deskripsi Posisi
          </div>
          <div class="px-4 py-4 whitespace-pre-wrap text-gray-800">
            {{ $position->description }}
          </div>
        </div>
      @endif

      @if($position->requirements)
        <div class="mt-5 border border-gray-200 rounded-xl overflow-hidden">
          <div class="px-4 py-3 bg-gray-50 border-b border-gray-200 font-semibold text-gray-700">
            <i class="fas fa-list-check mr-2"></i>Persyaratan
          </div>
          <div class="px-4 py-4 whitespace-pre-wrap text-gray-800">
            {{ $position->requirements }}
          </div>
        </div>
      @endif

      {{-- Kandidat --}}
      <div class="mt-5 border border-gray-200 rounded-xl overflow-hidden">
        <div class="px-4 py-3 bg-gray-50 border-b border-gray-200 font-semibold text-gray-700">
          <i class="fas fa-users mr-2"></i>Kandidat Terkait
        </div>

        @if($position->candidates->count())
          <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
              <thead class="bg-gray-50">
                <tr>
                  <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nama</th>
                  <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Email</th>
                  <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                  <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tanggal</th>
                </tr>
              </thead>
              <tbody class="bg-white divide-y divide-gray-100">
                @foreach($position->candidates as $c)
                  <tr>
                    <td class="px-4 py-3 text-gray-800">{{ $c->full_name ?? '-' }}</td>
                    <td class="px-4 py-3 text-gray-700">{{ $c->email ?? '-' }}</td>
                    <td class="px-4 py-3 text-gray-700">{{ ucfirst($c->status ?? '-') }}</td>
                    <td class="px-4 py-3 text-gray-700">{{ $c->created_at ? $c->created_at->format('d M Y H:i') : '-' }}</td>
                  </tr>
                @endforeach
              </tbody>
            </table>
          </div>
        @else
          <div class="px-4 py-6 text-gray-500">Belum ada kandidat yang terkait.</div>
        @endif
      </div>
    </div>
  </div>

  {{-- Overlay loading --}}
  <div id="loadingOverlay" class="fixed inset-0 bg-black/30 hidden items-center justify-center z-50">
    <div class="w-10 h-10 border-4 border-white/60 border-t-white rounded-full animate-spin"></div>
  </div>
@endsection

@push('scripts')
<script>
  const csrf = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
  const overlay = document.getElementById('loadingOverlay');
  const showLoading = () => overlay?.classList.remove('hidden');
  const hideLoading = () => overlay?.classList.add('hidden');

  // === Aktifkan ===
  document.getElementById('btnOpen')?.addEventListener('click', function(){
    const id = this.dataset.id;
    Swal.fire({
      icon:'question',
      title:'Aktifkan Posisi?',
      html:`<div class="text-left">
              <div class="rounded-md bg-emerald-50 border border-emerald-200 text-emerald-800 p-3 text-sm">
                <i class="fa-regular fa-square-check mr-1"></i> Posisi akan aktif untuk menerima aplikasi baru
              </div>
            </div>`,
      showCancelButton:true,
      confirmButtonText:'Ya, Aktifkan',
      cancelButtonText:'Batal'
    }).then(res=>{
      if(!res.isConfirmed) return;
      showLoading();
      fetch(`/positions/${id}/open`,{
        method:'POST', headers:{'Content-Type':'application/json','X-CSRF-TOKEN':csrf,'Accept':'application/json'}
      }).then(r=>r.json()).then(data=>{
        hideLoading();
        if(data.success){
          Swal.fire({icon:'success', title:'Berhasil', text:data.message||'Posisi diaktifkan', timer:1400, showConfirmButton:false})
            .then(()=>location.reload());
        }else{
          Swal.fire({icon:'error', title:'Gagal', text:data.message||'Tidak dapat mengaktifkan posisi'});
        }
      }).catch(()=>{ hideLoading(); Swal.fire({icon:'error', title:'Error', text:'Terjadi kesalahan jaringan.'}); });
    });
  });

  // === Nonaktifkan ===
  document.getElementById('btnClose')?.addEventListener('click', function(){
    const id = this.dataset.id;
    Swal.fire({
      icon:'warning',
      title:'Nonaktifkan Posisi?',
      html:`<div class="text-left space-y-2">
              <div class="rounded-md bg-amber-50 border border-amber-200 text-amber-800 p-3 text-sm">
                <div><i class="fa-solid fa-chart-column mr-1"></i> <strong>{{ $totalCandidates }}</strong> total kandidat terdaftar</div>
                <div><i class="fa-solid fa-triangle-exclamation mr-1"></i> <strong>{{ $activeCandidates }}</strong> kandidat sedang dalam proses</div>
                <div><i class="fa-regular fa-square mr-1"></i> Menonaktifkan posisi akan menghentikan aplikasi baru</div>
                <div><i class="fa-regular fa-square-check mr-1"></i> Kandidat yang sudah mendaftar tetap dapat diproses</div>
              </div>
              <textarea id="reasonClose" class="w-full border rounded-lg p-2 focus:outline-none focus:ring" placeholder="Alasan penonaktifan (opsional)..."></textarea>
            </div>`,
      showCancelButton:true,
      confirmButtonText:'Ya, Nonaktifkan',
      cancelButtonText:'Batal'
    }).then(res=>{
      if(!res.isConfirmed) return;
      const reason = document.getElementById('reasonClose')?.value || '';
      showLoading();
      fetch(`/positions/${id}/close`,{
        method:'POST',
        headers:{'Content-Type':'application/json','X-CSRF-TOKEN':csrf,'Accept':'application/json'},
        body: JSON.stringify({reason})
      }).then(r=>r.json()).then(data=>{
        hideLoading();
        if(data.success){
          Swal.fire({icon:'success', title:'Berhasil', text:data.message||'Posisi dinonaktifkan', timer:1400, showConfirmButton:false})
            .then(()=>location.reload());
        }else{
          Swal.fire({icon:'error', title:'Gagal', text:data.message||'Tidak dapat menonaktifkan posisi'});
        }
      }).catch(()=>{ hideLoading(); Swal.fire({icon:'error', title:'Error', text:'Terjadi kesalahan jaringan.'}); });
    });
  });

  // === Hapus ===
  document.getElementById('btnDelete')?.addEventListener('click', function(){
    const id     = this.dataset.id;
    const name   = this.dataset.name;
    const total  = parseInt(this.dataset.total||'0',10);
    const active = parseInt(this.dataset.active||'0',10);
    const url    = this.dataset.url;

    if (total > 0) {
      Swal.fire({
        icon: active > 0 ? 'error' : 'warning',
        title:'Tidak Dapat Menghapus Langsung',
        html:`<div class="text-left space-y-2">
                <p>Posisi <strong>"${name}"</strong> memiliki data kandidat terkait.</p>
                <ul class="list-disc ml-5 text-sm">
                  <li><strong>Total kandidat:</strong> ${total}</li>
                  <li><strong>Kandidat aktif:</strong> ${active}</li>
                </ul>
                <p class="mt-2">Silakan nonaktifkan posisi atau transfer kandidat terlebih dahulu.</p>
              </div>`,
        showCancelButton:true,
        confirmButtonText:'Tutup Posisi',
        cancelButtonText:'Batal'
      }).then(r=>{ if(r.isConfirmed) document.getElementById('btnClose')?.click(); });
      return;
    }

    Swal.fire({
      icon:'question',
      title:'Hapus Posisi?',
      html:`Apakah Anda yakin ingin menghapus posisi: <strong>"${name}"</strong>`,
      showCancelButton:true,
      confirmButtonColor:'#dc2626',
      confirmButtonText:'Ya, Hapus',
      cancelButtonText:'Batal'
    }).then(res=>{
      if(!res.isConfirmed) return;
      showLoading();
      fetch(url,{
        method:'DELETE',
        headers:{'Content-Type':'application/json','X-CSRF-TOKEN':csrf,'Accept':'application/json'}
      }).then(r=>r.json()).then(data=>{
        hideLoading();
        if(data.success){
          Swal.fire({icon:'success', title:'Berhasil', text:data.message||'Posisi dihapus', timer:1400, showConfirmButton:false})
            .then(()=>location.href='{{ route('positions.index') }}');
        }else{
          Swal.fire({icon:'error', title:'Gagal', text:data.message||'Tidak dapat menghapus posisi'});
        }
      }).catch(()=>{ hideLoading(); Swal.fire({icon:'error', title:'Error', text:'Terjadi kesalahan jaringan.'}); });
    });
  });
</script>
@endpush
