<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <title>@yield('title', 'HR System')</title>

  {{-- Icons --}}
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">

  {{-- CSS global kamu (kalau ada) --}}
  {{-- <link href="{{ asset('css/candidate-detail.css') }}" rel="stylesheet"> --}}

  {{-- CSS baru untuk layout + sidebar --}}
  <link href="{{ asset('css/dashboard.css') }}" rel="stylesheet">

  @stack('head')
</head>
<body>
  <div class="dash">
    @include('sidebar.sidebar')

    <main class="dash-main">
      <header class="topbar">
        <button id="sidebarToggle" class="icon-btn" title="Toggle sidebar">
          <i class="fas fa-bars"></i>
        </button>

        <div class="breadcrumbs">
          <a href="{{ route('dashboard') }}">Dashboard</a>
          <span>/</span>
          @yield('breadcrumb', 'Karyawan Diterima')
        </div>

        <div class="topbar-actions">
          @yield('header-actions')
        </div>
      </header>

      <section class="page">
        <h1 class="page-title">@yield('title', 'Karyawan Diterima')</h1>
        @yield('content')
      </section>
    </main>
  </div>

  <script>
    // Toggle + persist state
    document.addEventListener('DOMContentLoaded', () => {
      const sidebar = document.getElementById('sidebar');
      const btn = document.getElementById('sidebarToggle');
      const KEY = 'hr_sidebar_collapsed';

      function applyState() {
        const collapsed = localStorage.getItem(KEY) === '1';
        sidebar.classList.toggle('collapsed', collapsed);
        document.body.classList.toggle('sidebar-collapsed', collapsed);
      }
      applyState();

      btn?.addEventListener('click', () => {
        const collapsed = !(localStorage.getItem(KEY) === '1');
        localStorage.setItem(KEY, collapsed ? '1' : '0');
        applyState();
      });
    });
  </script>

  @stack('scripts')
</body>
</html>
