{{-- resources/views/employees/show.blade.php --}}
@extends('layouts.app')

@section('title', 'Detail Karyawan')
@section('page-title', 'Detail Karyawan')

@section('content')

{{-- Header actions --}}
<div class="mb-6 flex items-center justify-between">
  <div class="space-y-1">
    <nav class="text-sm text-gray-500">
      <a href="{{ route('employees.index') }}" class="hover:text-gray-700">Karyawan Diterima</a>
      <span class="mx-1">/</span>
      <span class="text-gray-700">{{ $employee->full_name ?? 'Karyawan' }}</span>
    </nav>
    <h2 class="text-2xl font-bold text-gray-900">{{ $employee->full_name ?? '—' }}</h2>
  </div>

  <div class="flex gap-2">
    <a href="{{ route('employees.index') }}"
       class="inline-flex items-center gap-2 px-4 py-2 rounded-lg border border-gray-300 text-gray-700 hover:bg-gray-50">
      <i class="fas fa-arrow-left"></i><span>Kembali</span>
    </a>
    <a href="{{ route('employees.edit', $employee->id) }}"
       class="inline-flex items-center gap-2 px-4 py-2 rounded-lg bg-primary text-white hover:bg-indigo-700">
      <i class="fas fa-pen"></i><span>Edit</span>
    </a>
  </div>
</div>

{{-- HEADER PROFILE --}}
<div class="bg-white border border-gray-200 rounded-xl p-5 shadow-sm mb-6">
  <div class="flex gap-4 items-center">
    <div class="w-16 h-16 rounded-2xl grid place-items-center text-indigo-800 bg-indigo-50 shrink-0">
      <i class="fas fa-user-tie text-2xl"></i>
    </div>

    <div class="flex-1 min-w-0">
      <div class="flex flex-wrap items-center gap-2">
        <h3 class="m-0 text-xl font-bold text-gray-900 truncate">
          {{ $employee->full_name ?? '—' }}
        </h3>

        @if(!empty($employee->employee_code))
          <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-50 text-blue-800 border border-blue-200">
            {{ $employee->employee_code }}
          </span>
        @endif

        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium border
                     {{ ($employee->is_active ?? 1) ? 'bg-emerald-50 text-emerald-700 border-emerald-200'
                                                    : 'bg-rose-50 text-rose-700 border-rose-200' }}">
          {{ ($employee->is_active ?? 1) ? 'Aktif' : 'Nonaktif' }}
        </span>
      </div>

      <div class="text-sm text-gray-500 mt-1">
        {{ $employee->position_name ?? '—' }}
        @if(!empty($employee->department)) • Dept: {{ $employee->department }} @endif
        @if(!empty($employee->branch)) • {{ $employee->branch }} @endif
        @if(!empty($employee->job_level)) • Level: {{ $employee->job_level }} @endif
      </div>
    </div>

    <div class="text-right text-xs text-gray-500">
      <div>Dibuat: {{ optional($employee->created_at)->format('d M Y H:i') ?? '—' }}</div>
      <div>Diubah: {{ optional($employee->updated_at)->format('d M Y H:i') ?? '—' }}</div>
    </div>
  </div>
</div>

{{-- GRID 2 KOLOM --}}
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
  {{-- KIRI (span 2) --}}
  <div class="lg:col-span-2 space-y-6">

    {{-- Organisasi & Penempatan --}}
    <section class="bg-white border border-gray-200 rounded-xl p-5 shadow-sm">
      <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
        <i class="fas fa-sitemap text-gray-500"></i> Organisasi & Penempatan
      </h3>

      <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
        <div class="flex justify-between gap-4">
          <span class="text-sm text-gray-500 w-40">Position</span>
          <span class="text-sm text-gray-900 flex-1 text-right">{{ $employee->position_name ?? '—' }}</span>
        </div>
        <div class="flex justify-between gap-4">
          <span class="text-sm text-gray-500 w-40">Department</span>
          <span class="text-sm text-gray-900 flex-1 text-right">{{ $employee->department ?? '—' }}</span>
        </div>
        <div class="flex justify-between gap-4">
          <span class="text-sm text-gray-500 w-40">Branch</span>
          <span class="text-sm text-gray-900 flex-1 text-right">{{ $employee->branch ?? '—' }}</span>
        </div>
        <div class="flex justify-between gap-4">
          <span class="text-sm text-gray-500 w-40">Job Level</span>
          <span class="text-sm text-gray-900 flex-1 text-right">{{ $employee->job_level ?? '—' }}</span>
        </div>
        <div class="flex justify-between gap-4">
          <span class="text-sm text-gray-500 w-40">Atasan</span>
          <span class="text-sm text-gray-900 flex-1 text-right">{{ $employee->supervisor_name ?? '—' }}</span>
        </div>
        <div class="flex justify-between gap-4">
          <span class="text-sm text-gray-500 w-40">Jadwal Kerja</span>
          <span class="text-sm text-gray-900 flex-1 text-right">{{ $employee->work_schedule ?? '—' }}</span>
        </div>
        <div class="flex justify-between gap-4 sm:col-span-2">
          <span class="text-sm text-gray-500 w-40">Lokasi Detail</span>
          <span class="text-sm text-gray-900 flex-1 text-right">{{ $employee->work_location_detail ?? '—' }}</span>
        </div>
      </div>
    </section>

    {{-- Status Kepegawaian --}}
    <section class="bg-white border border-gray-200 rounded-xl p-5 shadow-sm">
      <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
        <i class="fas fa-id-card-clip text-gray-500"></i> Status Kepegawaian
      </h3>

      <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
        <div class="flex justify-between gap-4">
          <span class="text-sm text-gray-500 w-40">Employment Type</span>
          <span class="text-sm text-gray-900 flex-1 text-right">{{ ucfirst($employee->employment_type ?? 'full-time') }}</span>
        </div>
        <div class="flex justify-between gap-4">
          <span class="text-sm text-gray-500 w-40">Contract Type</span>
          <span class="text-sm text-gray-900 flex-1 text-right">{{ $employee->contract_type ?? '—' }}</span>
        </div>
        <div class="flex justify-between gap-4">
          <span class="text-sm text-gray-500 w-40">Mulai Kerja</span>
          <span class="text-sm text-gray-900 flex-1 text-right">{{ optional($employee->start_date)->format('d M Y') ?? '—' }}</span>
        </div>
        <div class="flex justify-between gap-4">
          <span class="text-sm text-gray-500 w-40">Akhir Kontrak</span>
          <span class="text-sm text-gray-900 flex-1 text-right">{{ optional($employee->end_date)->format('d M Y') ?? '—' }}</span>
        </div>
        <div class="flex justify-between gap-4 sm:col-span-2">
          <span class="text-sm text-gray-500 w-40">Status</span>
          <span class="text-sm text-gray-900 flex-1 text-right">{{ ($employee->is_active ?? 1) ? 'Aktif' : 'Nonaktif' }}</span>
        </div>
      </div>
    </section>

    {{-- Kompensasi --}}
    <section class="bg-white border border-gray-200 rounded-xl p-5 shadow-sm">
      <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
        <i class="fas fa-money-bill-wave text-gray-500"></i> Kompensasi
      </h3>

      <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
        <div class="flex justify-between gap-4">
          <span class="text-sm text-gray-500 w-40">Mata Uang</span>
          <span class="text-sm text-gray-900 flex-1 text-right">{{ $employee->salary_currency ?? 'IDR' }}</span>
        </div>
        <div class="flex justify-between gap-4">
          <span class="text-sm text-gray-500 w-40">Gaji Pokok</span>
          <span class="text-sm text-gray-900 flex-1 text-right">
            {{ is_null($employee->base_salary) ? '—' : 'Rp '.number_format($employee->base_salary,0,',','.') }}
          </span>
        </div>
        <div class="flex justify-between gap-4">
          <span class="text-sm text-gray-500 w-40">Tunjangan</span>
          <span class="text-sm text-gray-900 flex-1 text-right">
            {{ is_null($employee->allowance) ? '—' : 'Rp '.number_format($employee->allowance,0,',','.') }}
          </span>
        </div>
        <div class="flex justify-between gap-4">
          <span class="text-sm text-gray-500 w-40">Uang Makan/Transport</span>
          <span class="text-sm text-gray-900 flex-1 text-right">
            {{ is_null($employee->meal_transport) ? '—' : 'Rp '.number_format($employee->meal_transport,0,',','.') }}
          </span>
        </div>
        <div class="flex justify-between gap-4 sm:col-span-2">
          <span class="text-sm text-gray-500 w-40">Benefit Lain</span>
          <span class="text-sm text-gray-900 flex-1 text-right">
            {{ is_null($employee->other_benefits) ? '—' : 'Rp '.number_format($employee->other_benefits,0,',','.') }}
          </span>
        </div>
      </div>
    </section>

    {{-- Payroll --}}
    <section class="bg-white border border-gray-200 rounded-xl p-5 shadow-sm">
      <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
        <i class="fas fa-building-columns text-gray-500"></i> Rekening Payroll
      </h3>

      <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
        <div class="flex justify-between gap-4">
          <span class="text-sm text-gray-500 w-40">Nama Bank</span>
          <span class="text-sm text-gray-900 flex-1 text-right">{{ $employee->bank_name ?? '—' }}</span>
        </div>
        <div class="flex justify-between gap-4">
          <span class="text-sm text-gray-500 w-40">No. Rekening</span>
          <span class="text-sm text-gray-900 flex-1 text-right">{{ $employee->bank_account_no ?? '—' }}</span>
        </div>
        <div class="flex justify-between gap-4 sm:col-span-2">
          <span class="text-sm text-gray-500 w-40">Atas Nama</span>
          <span class="text-sm text-gray-900 flex-1 text-right">{{ $employee->bank_account_holder ?? '—' }}</span>
        </div>
      </div>
    </section>
  </div>

  {{-- KANAN --}}
  <div class="space-y-6">

    {{-- Pajak & Kepesertaan --}}
    <section class="bg-white border border-gray-200 rounded-xl p-5 shadow-sm">
      <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
        <i class="fas fa-receipt text-gray-500"></i> Pajak & Kepesertaan
      </h3>

      <div class="space-y-3">
        <div class="flex justify-between gap-4">
          <span class="text-sm text-gray-500">NPWP</span>
          <span class="text-sm text-gray-900 text-right">{{ $employee->npwp ?? '—' }}</span>
        </div>
        <div class="flex justify-between gap-4">
          <span class="text-sm text-gray-500">BPJS Ketenagakerjaan</span>
          <span class="text-sm text-gray-900 text-right">{{ $employee->bpjs_ketenagakerjaan ?? '—' }}</span>
        </div>
        <div class="flex justify-between gap-4">
          <span class="text-sm text-gray-500">BPJS Kesehatan</span>
          <span class="text-sm text-gray-900 text-right">{{ $employee->bpjs_kesehatan ?? '—' }}</span>
        </div>
        <div class="flex justify-between gap-4">
          <span class="text-sm text-gray-500">Status Pajak (PTKP)</span>
          <span class="text-sm text-gray-900 text-right">{{ $employee->tax_status ?? '—' }}</span>
        </div>
      </div>
    </section>

    {{-- Informasi Kandidat Asal --}}
    <section class="bg-white border border-gray-200 rounded-xl p-5 shadow-sm">
      <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
        <i class="fas fa-user text-gray-500"></i> Data Kandidat
      </h3>

      @php $cand = $employee->candidate ?? null; @endphp
      @if($cand)
        <div class="space-y-3">
          <div class="flex justify-between gap-4">
            <span class="text-sm text-gray-500">Kode Kandidat</span>
            <span class="text-sm text-gray-900 text-right">{{ $cand->candidate_code }}</span>
          </div>
          <div class="flex justify-between gap-4">
            <span class="text-sm text-gray-500">Nama</span>
            <span class="text-sm text-gray-900 text-right">{{ $cand->full_name }}</span>
          </div>
          <div class="flex justify-between gap-4">
            <span class="text-sm text-gray-500">Email</span>
            <span class="text-sm text-gray-900 text-right">{{ $cand->email }}</span>
          </div>
          <div class="flex justify-between gap-4">
            <span class="text-sm text-gray-500">Telepon</span>
            <span class="text-sm text-gray-900 text-right">{{ $cand->phone_number ?? '—' }}</span>
          </div>
          <div class="flex justify-between gap-4">
            <span class="text-sm text-gray-500">Posisi Dilamar</span>
            <span class="text-sm text-gray-900 text-right">
              {{ optional($cand->position)->position_name ?? $cand->position_applied }}
            </span>
          </div>
          @if(!is_null($cand->expected_salary))
            <div class="flex justify-between gap-4">
              <span class="text-sm text-gray-500">Gaji Harapan</span>
              <span class="text-sm text-gray-900 text-right">Rp {{ number_format($cand->expected_salary,0,',','.') }}</span>
            </div>
          @endif
        </div>

        <div class="mt-4">
          <a class="inline-flex items-center gap-2 px-3 py-2 rounded-lg border border-gray-300 text-gray-700 hover:bg-gray-50"
             href="{{ route('candidates.show', $cand->id) }}">
            <i class="fas fa-eye"></i> Lihat Kandidat
          </a>
        </div>
      @else
        <div class="flex flex-col items-center justify-center text-gray-500 py-6">
          <i class="fas fa-circle-info text-2xl mb-2"></i>
          <p class="text-sm">Karyawan ini tidak terhubung ke data kandidat.</p>
        </div>
      @endif
    </section>

    {{-- Catatan Sistem --}}
    <section class="bg-white border border-gray-200 rounded-xl p-5 shadow-sm">
      <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
        <i class="fas fa-clock-rotate-left text-gray-500"></i> Catatan Sistem
      </h3>

      <div class="text-sm text-gray-600 space-y-1">
        <div>Dibuat pada <strong class="text-gray-900">{{ optional($employee->created_at)->format('d M Y H:i') ?? '—' }}</strong></div>
        <div>Terakhir diperbarui <strong class="text-gray-900">{{ optional($employee->updated_at)->diffForHumans() ?? '—' }}</strong></div>
      </div>
    </section>
  </div>
</div>

@endsection
