{{-- resources/views/employees/create.blade.php --}}
@extends('layouts.app')

@section('title', 'Lengkapi Data Karyawan')
@section('page-title', 'Lengkapi Data Karyawan')

@section('content')
  <form action="{{ route('employees.store') }}" method="POST"
        class="bg-white border border-gray-200 rounded-xl p-6 shadow-sm space-y-8 max-w-4xl mx-auto">
    @csrf

    {{-- Notif error --}}
    @if ($errors->any())
      <div class="rounded-lg border border-rose-200 bg-rose-50 text-rose-800 p-4">
        <div class="font-semibold mb-2 flex items-center gap-2">
          <i class="fas fa-triangle-exclamation"></i>
          Periksa kembali isian
        </div>
        <ul class="list-disc pl-5 text-sm">
          @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
          @endforeach
        </ul>
      </div>
    @endif

    {{-- Employment data header --}}
    <div class="border-b border-gray-200 pb-4">
      <h2 class="text-xl font-semibold text-gray-900">Employment data</h2>
      <p class="text-sm text-gray-500 mt-1">Fill all employee data information related to company</p>
    </div>

    {{-- Hidden essentials --}}
    <input type="hidden" name="candidate_id" value="{{ $candidate->id }}">
    <input type="hidden" name="full_name" value="{{ $candidate->full_name }}">

    {{-- Form Grid --}}
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
      {{-- Employee ID --}}
      <div>
        <label class="block text-sm font-medium text-gray-700 mb-2">
          Employee ID<span class="text-red-500">*</span>
        </label>
        <input type="text" name="employee_code" readonly
               value="{{ old('employee_code') }}"
               placeholder="Auto Generate Employee ID"
               class="w-full px-3 py-2.5 rounded-lg border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-transparent placeholder-gray-400">
      </div>

      {{-- Barcode --}}
      <div>
        <label class="block text-sm font-medium text-gray-700 mb-2 flex items-center gap-1">
          Barcode 
          <i class="fas fa-info-circle text-gray-400 text-xs"></i>
        </label>
        <input type="text" name="barcode" readonly
               value="{{ old('barcode') }}"
               placeholder="Auto Generate Barcode"
               class="w-full px-3 py-2.5 rounded-lg border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-transparent placeholder-gray-400">
      </div>

      {{-- Group structure --}}
      <div>
        <label class="block text-sm font-medium text-gray-700 mb-2 flex items-center gap-1">
          Group structure 
          <i class="fas fa-info-circle text-gray-400 text-xs"></i>
        </label>
        <select name="group_structure"
                class="w-full px-3 py-2.5 rounded-lg border border-gray-300 bg-white focus:ring-2 focus:ring-blue-500 focus:border-transparent appearance-none">
          <option value="">Select group</option>
          <option value="group1" @selected(old('group_structure') == 'group1')>Group 1</option>
          <option value="group2" @selected(old('group_structure') == 'group2')>Group 2</option>
        </select>
      </div>

      {{-- Employment status --}}
      <div>
        <label class="block text-sm font-medium text-gray-700 mb-2">
          Employment status<span class="text-red-500">*</span>
        </label>
        <select name="employment_type" required
                class="w-full px-3 py-2.5 rounded-lg border border-gray-300 bg-white focus:ring-2 focus:ring-blue-500 focus:border-transparent appearance-none">
          <option value="">Select employment status</option>
          @foreach($employmentTypes as $et)
            <option value="{{ $et }}" @selected(old('employment_type','full-time') == $et)>{{ ucfirst($et) }}</option>
          @endforeach
        </select>
      </div>

      {{-- Join date --}}
      <div>
        <label class="block text-sm font-medium text-gray-700 mb-2">
          Join date<span class="text-red-500">*</span>
        </label>
        <input type="date" name="start_date" required
               value="{{ old('start_date', date('Y-m-d')) }}"
               class="w-full px-3 py-2.5 rounded-lg border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-transparent">
      </div>

      {{-- Branch --}}
      <div>
        <label class="block text-sm font-medium text-gray-700 mb-2">Branch</label>
        <select name="branch"
                class="w-full px-3 py-2.5 rounded-lg border border-gray-300 bg-white focus:ring-2 focus:ring-blue-500 focus:border-transparent appearance-none">
          <option value="Pusat" @selected(old('branch', 'Pusat') == 'Pusat')>Pusat</option>
          @foreach($branches as $b)
            <option value="{{ $b }}" @selected(old('branch', $prefillBranch) == $b)>{{ $b }}</option>
          @endforeach
        </select>
      </div>

      {{-- Organization --}}
      <div>
        <label class="block text-sm font-medium text-gray-700 mb-2">
          Organization<span class="text-red-500">*</span>
        </label>
        <select name="department" required
                class="w-full px-3 py-2.5 rounded-lg border border-gray-300 bg-white focus:ring-2 focus:ring-blue-500 focus:border-transparent appearance-none">
          <option value="">Select organization</option>
          @foreach($departments as $dept)
            <option value="{{ $dept }}" @selected(old('department', $prefillDepartment) == $dept)>{{ $dept }}</option>
          @endforeach
        </select>
      </div>

      {{-- Job position --}}
      <div>
        <label class="block text-sm font-medium text-gray-700 mb-2">
          Job position<span class="text-red-500">*</span>
        </label>
        <input type="text" name="position_name" required
               value="{{ old('position_name', $prefillPositionName) }}"
               placeholder="Select job position"
               class="w-full px-3 py-2.5 rounded-lg border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-transparent placeholder-gray-400">
      </div>

      {{-- Job level --}}
      <div>
        <label class="block text-sm font-medium text-gray-700 mb-2">
          Job level<span class="text-red-500">*</span>
        </label>
        <select name="job_level" required
                class="w-full px-3 py-2.5 rounded-lg border border-gray-300 bg-white focus:ring-2 focus:ring-blue-500 focus:border-transparent appearance-none">
          <option value="">Select job level</option>
          @foreach($jobLevels as $jl)
            <option value="{{ $jl }}" @selected(old('job_level') == $jl)>{{ $jl }}</option>
          @endforeach
        </select>
      </div>

      {{-- Schedule --}}
      <div>
        <label class="block text-sm font-medium text-gray-700 mb-2">
          Schedule<span class="text-red-500">*</span>
        </label>
        <select name="work_schedule" required
                class="w-full px-3 py-2.5 rounded-lg border border-gray-300 bg-white focus:ring-2 focus:ring-blue-500 focus:border-transparent appearance-none">
          <option value="">Select schedule</option>
          <option value="Shift A" @selected(old('work_schedule') == 'Shift A')>Shift A</option>
          <option value="Shift B" @selected(old('work_schedule') == 'Shift B')>Shift B</option>
          <option value="Non Shift" @selected(old('work_schedule') == 'Non Shift')>Non Shift</option>
        </select>
      </div>

      {{-- Approval line --}}
      <div>
        <label class="block text-sm font-medium text-gray-700 mb-2 flex items-center gap-1">
          Approval line 
          <i class="fas fa-info-circle text-gray-400 text-xs"></i>
        </label>
        <select name="approval_line"
                class="w-full px-3 py-2.5 rounded-lg border border-gray-300 bg-white focus:ring-2 focus:ring-blue-500 focus:border-transparent appearance-none">
          <option value="">Select approval line</option>
          <option value="line1" @selected(old('approval_line') == 'line1')>Line 1</option>
          <option value="line2" @selected(old('approval_line') == 'line2')>Line 2</option>
        </select>
      </div>

      {{-- Manager --}}
      <div>
        <label class="block text-sm font-medium text-gray-700 mb-2 flex items-center gap-1">
          Manager 
          <i class="fas fa-info-circle text-gray-400 text-xs"></i>
        </label>
        <select name="supervisor_name"
                class="w-full px-3 py-2.5 rounded-lg border border-gray-300 bg-white focus:ring-2 focus:ring-blue-500 focus:border-transparent appearance-none">
          <option value="">Select manager</option>
          <option value="manager1" @selected(old('supervisor_name') == 'manager1')>Manager 1</option>
          <option value="manager2" @selected(old('supervisor_name') == 'manager2')>Manager 2</option>
        </select>
      </div>
    </div>

    {{-- Status Pajak (PTKP) Section --}}
    <div class="pt-6">
      <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
          <label class="block text-sm font-medium text-gray-700 mb-2">Status Pajak (PTKP)</label>
          @php $ptkpOptions = ['TK/0','TK/1','TK/2','TK/3','K/0','K/1','K/2','K/3']; @endphp
          <select name="tax_status"
                  class="w-full px-3 py-2.5 rounded-lg border border-gray-300 bg-white focus:ring-2 focus:ring-blue-500 focus:border-transparent appearance-none">
            <option value="">— Pilih —</option>
            @foreach($ptkpOptions as $ts)
              <option value="{{ $ts }}" @selected(old('tax_status') == $ts)>{{ $ts }}</option>
            @endforeach
          </select>
        </div>
      </div>
    </div>

    {{-- Hidden fields for compatibility --}}
    <div class="hidden">
      <input type="hidden" name="contract_type" value="PKWT">
      <input type="hidden" name="is_active" value="1">
    </div>

    {{-- Actions --}}
    <div class="flex items-center justify-between pt-6 border-t border-gray-200">
      <a href="{{ route('employees.index') }}"
         class="inline-flex items-center gap-2 px-6 py-2.5 rounded-lg border border-gray-300 text-gray-700 hover:bg-gray-50 font-medium">
        Batal
      </a>
      <div class="flex gap-3">
        <button type="submit"
                class="inline-flex items-center gap-2 px-6 py-2.5 rounded-lg bg-blue-600 text-white hover:bg-blue-700 font-medium">
          Simpan        
        </button>
      </div>
    </div>
  </form>
@endsection

@push('styles')
<style>
  /* Custom select dropdown arrow */
  select {
    background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 20 20'%3e%3cpath stroke='%236b7280' stroke-linecap='round' stroke-linejoin='round' stroke-width='1.5' d='M6 8l4 4 4-4'/%3e%3c/svg%3e");
    background-position: right 0.5rem center;
    background-repeat: no-repeat;
    background-size: 1.5em 1.5em;
    padding-right: 2.5rem;
  }
  
  /* Remove default date picker styles */
  input[type="date"]::-webkit-calendar-picker-indicator {
    cursor: pointer;
  }
</style>
@endpush

@push('scripts')
<script>

  document.addEventListener('DOMContentLoaded', function() {
      Swal.fire({
          title: 'Informasi',
          text: 'Employee ID dan Barcode akan otomatis dibuat setelah Anda menyimpan data.',
          icon: 'info',
          confirmButtonText: 'OK'
      });
  });

  // Auto-fill functionality (keeping from original)
  (function(){
    const selectPos   = document.getElementById('position_id');
    const inputPosName= document.querySelector('input[name="position_name"]');
    const selectDept  = document.querySelector('select[name="department"]');
    const selectBranch= document.querySelector('select[name="branch"]');

    function setIfExists(select, value){
      if(!select) return;
      const exists = Array.from(select.options).some(o => o.value === value);
      if(value && exists) select.value = value;
    }

    // Prefill ketika memilih master posisi
    selectPos?.addEventListener('change', (e)=>{
      const opt   = e.target.selectedOptions[0];
      if(!opt) return;

      const pname = opt.getAttribute('data-position-name') || '';
      const dept  = opt.getAttribute('data-department') || '';
      const loc   = opt.getAttribute('data-location') || '';
      const branch= loc ? `PT. Kayu Mebel Indonesia - ${loc}` : '';

      if(pname && inputPosName) inputPosName.value = pname;
      setIfExists(selectDept, dept);
      setIfExists(selectBranch, branch);
    });
  })();
</script>
@endpush