<!-- resources/views/auth/login.blade.php -->
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Login - Sistem Recruitment</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #66ea66 0%, #4ba28f 100%);
            min-height: 100vh; display: flex; align-items: center; justify-content: center;
            position: relative; overflow-x: hidden; overflow-y: auto;
        }
        .background-animation {
            position: fixed; top: 0; left: 0; width: 100%; height: 100%;
            background: linear-gradient(45deg, rgba(255,255,255,0.1) 25%, transparent 25%), 
                        linear-gradient(-45deg, rgba(255,255,255,0.1) 25%, transparent 25%), 
                        linear-gradient(45deg, transparent 75%, rgba(255,255,255,0.1) 75%), 
                        linear-gradient(-45deg, transparent 75%, rgba(255,255,255,0.1) 75%);
            background-size: 20px 20px; background-position: 0 0, 0 10px, 10px -10px, -10px 0px;
            animation: backgroundMove 20s linear infinite; opacity: 0.3; z-index: 0;
        }
        @keyframes backgroundMove { 0% { transform: translateX(0); } 100% { transform: translateX(20px); } }
        .main-wrapper { width: 100%; min-height: 100vh; display: flex; align-items: center; justify-content: center; padding: 20px; position: relative; z-index: 1; }
        .login-container {
            background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px);
            border-radius: 20px; box-shadow: 0 25px 45px rgba(0, 0, 0, 0.1);
            overflow: hidden; width: 100%; max-width: 900px; display: flex; flex-wrap: wrap; position: relative; z-index: 10;
        }
        .login-left {
            flex: 1; min-width: 280px;
            background: linear-gradient(135deg, #00ff00 0%, #00a581 100%);
            color: white; padding: 40px 30px; display: flex; flex-direction: column; justify-content: center; align-items: center; text-align: center; position: relative; min-height: 300px;
        }
        .company-logo {
            width: 100px; height: 100px; background: rgba(255, 255, 255, 0.2);
            border-radius: 50%; display: flex; align-items: center; justify-content: center;
            margin: 0 auto 20px; backdrop-filter: blur(10px); overflow: hidden; position: relative; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .company-logo i { font-size: 36px; color: white; }
        .login-left h1 { font-size: 1.8rem; margin-bottom: 10px; font-weight: 700; }
        .login-left p { font-size: 0.95rem; opacity: 0.9; line-height: 1.5; max-width: 300px; }

        .login-right { flex: 1; min-width: 280px; padding: 30px 20px; display: flex; flex-direction: column; justify-content: center; max-height: 100vh; overflow-y: auto; }
        .login-header { text-align: center; margin-bottom: 15px; }
        .login-header h2 { color: #1f2937; font-size: 1.5rem; margin-bottom: 3px; font-weight: 600; }
        .login-header p { color: #6b7280; font-size: 0.9rem; }
        
        .form-group { margin-bottom: 18px; position: relative; }
        .form-group label { display: block; margin-bottom: 6px; color: #374151; font-weight: 500; font-size: 0.9rem; }
        .input-wrapper { position: relative; }
        .form-group input {
            width: 100%; padding: 12px 16px 12px 42px; border: 2px solid #e5e7eb;
            border-radius: 10px; font-size: 0.95rem; transition: all 0.3s ease; background: #f9fafb;
        }
        .form-group input:focus { outline: none; border-color: #4f46e5; background: white; box-shadow: 0 0 0 3px rgba(79, 70, 229, 0.1); }
        .form-group input.error { border-color: #dc2626; background: #fef2f2; }
        .input-icon { position: absolute; left: 14px; top: 50%; transform: translateY(-50%); color: #9ca3af; font-size: 0.95rem; }
        .toggle-password { position: absolute; right: 14px; top: 50%; transform: translateY(-50%); cursor: pointer; color: #9ca3af; }
        
        .form-options { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; font-size: 0.85rem; flex-wrap: wrap; gap: 10px; }
        .remember-me { display: flex; align-items: center; gap: 6px; }
        .remember-me input[type="checkbox"] { width: 16px; height: 16px; accent-color: #4f46e5; }

        .login-btn {
            width: 100%; background: linear-gradient(135deg, #4f46e5 0%, #7c3aed 100%);
            color: white; border: none; padding: 14px; border-radius: 10px;
            font-size: 1rem; font-weight: 600; cursor: pointer; transition: all 0.3s ease;
            position: relative; overflow: hidden;
        }
        .login-btn:hover { transform: translateY(-2px); box-shadow: 0 10px 25px rgba(79, 70, 229, 0.4); }
        .login-btn:active { transform: translateY(0); }
        .login-btn.loading { pointer-events: none; opacity: 0.8; }

        .error-message, .success-message, .info-message {
            padding: 12px 16px; border-radius: 8px; margin-bottom: 16px; font-size: 0.9rem; display: flex; align-items: center; gap: 10px; animation: slideIn 0.3s ease-out;
        }
        .error-message { background: #fef2f2; color: #dc2626; border-left: 4px solid #dc2626; border: 1px solid #fecaca; }
        .success-message { background: #f0fdf4; color: #16a34a; border-left: 4px solid #16a34a; border: 1px solid #bbf7d0; }
        .info-message { background: #eff6ff; color: #2563eb; border-left: 4px solid #2563eb; border: 1px solid #bfdbfe; }

        @keyframes slideIn { from { opacity: 0; transform: translateY(-10px); } to { opacity: 1; transform: translateY(0); } }
        .footer-info { text-align: center; margin-top: 15px; padding-top: 12px; border-top: 1px solid #e5e7eb; color: #6b7280; font-size: 0.75rem; }

        /* 🔹 Responsive Styles */
        @media (max-width: 992px) {
            .login-container { flex-direction: column; max-width: 600px; }
            .login-left, .login-right { width: 100%; min-height: auto; }
            .login-left { padding: 30px 20px; }
        }
        @media (max-width: 576px) {
            .login-left h1 { font-size: 1.5rem; }
            .login-left p { font-size: 0.85rem; }
            .login-header h2 { font-size: 1.3rem; }
            .form-group input { font-size: 0.85rem; padding: 10px 14px 10px 38px; }
            .login-btn { font-size: 0.9rem; padding: 12px; }
        }
    </style>
</head>
<body>
    <div class="background-animation"></div>
    <div class="main-wrapper">
        <div class="login-container">
            <div class="login-left">
                <div class="company-logo"><i class="fas fa-building"></i></div>
                <h1>HR Recruitment</h1>
                <p>Sistem manajemen recruitment modern untuk mengelola kandidat dan proses interview secara efisien</p>
            </div>

            <div class="login-right">
                <div class="login-header">
                    <h2>Selamat Datang</h2>
                    <p>Silakan login untuk mengakses sistem</p>
                </div>

                @if ($errors->any())
                    <div class="error-message">
                        <i class="fas fa-exclamation-triangle"></i>
                        <div>
                            @foreach ($errors->all() as $error)
                                <div>{{ $error }}</div>
                            @endforeach
                        </div>
                    </div>
                @endif

                @if (session('success'))
                    <div class="success-message {{ session('alert-type') === 'info' ? 'info-message' : '' }}">
                        <i class="fas fa-check-circle"></i>
                        <span>{{ session('success') }}</span>
                    </div>
                @endif

                @if (session('info'))
                    <div class="info-message">
                        <i class="fas fa-info-circle"></i>
                        <span>{{ session('info') }}</span>
                    </div>
                @endif

                <form method="POST" action="{{ route('login') }}" id="loginForm">
                    @csrf
                    <div class="form-group">
                        <label for="credential">Username atau Email</label>
                        <div class="input-wrapper">
                            <i class="fas fa-user input-icon"></i>
                            <input type="text" id="credential" name="credential" placeholder="Masukkan username atau email" value="{{ old('credential') }}" class="{{ $errors->has('credential') ? 'error' : '' }}" required>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="password">Password</label>
                        <div class="input-wrapper">
                            <i class="fas fa-lock input-icon"></i>
                            <input type="password" id="password" name="password" placeholder="Masukkan password" class="{{ $errors->has('password') ? 'error' : '' }}" required>
                            <span class="toggle-password"><i class="fas fa-eye"></i></span>
                        </div>
                    </div>

                    <div class="form-options">
                        <label class="remember-me">
                            <input type="checkbox" name="remember" {{ old('remember') ? 'checked' : '' }}>
                            <span>Ingat saya</span>
                        </label>
                        <a href="#" id="forgotPassword" style="color: #4f46e5; text-decoration: none;">Lupa password?</a>
                    </div>

                    <button type="submit" class="login-btn" id="loginBtn">
                        <span class="btn-text">Masuk</span>
                    </button>
                </form>

                <div class="footer-info">
                    <p>&copy; 2025 PT. Kayu Mebel Indonesia. All rights reserved.</p>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Toggle show/hide password
        document.querySelectorAll('.toggle-password').forEach(toggle => {
            toggle.addEventListener('click', function () {
                const input = document.getElementById('password');
                const icon = this.querySelector('i');
                if (input.type === 'password') {
                    input.type = 'text';
                    icon.classList.replace('fa-eye', 'fa-eye-slash');
                } else {
                    input.type = 'password';
                    icon.classList.replace('fa-eye-slash', 'fa-eye');
                }
            });
        });

        // Loading state on submit
        document.getElementById('loginForm').addEventListener('submit', function () {
            const loginBtn = document.getElementById('loginBtn');
            const btnText = loginBtn.querySelector('.btn-text');
            loginBtn.classList.add('loading');
            btnText.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Masuk...';
        });

        // SweetAlert untuk lupa password
        document.getElementById('forgotPassword').addEventListener('click', function(e) {
            e.preventDefault();
            Swal.fire({
                icon: 'info',
                title: 'Fitur Dalam Pengembangan',
                html: 'Fitur lupa password sedang dalam tahap pengembangan.<br>Silakan hubungi <b>IT07</b> untuk bantuan lebih lanjut.',
                confirmButtonText: 'OK',
                confirmButtonColor: '#4f46e5'
            });
        });
    </script>
</body>
</html>
